<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'charitab_mascot_shop_gallery_isotope_products_per_row_filter', 'charitab_mascot_shop_gallery_isotope_related_products_per_row' );
function charitab_mascot_shop_gallery_isotope_related_products_per_row( $products_per_row ) {
	$products_per_row = charitab_mascot_get_redux_option( 'shop-single-product-settings-related-products-per-row', 4 );
	return $products_per_row;
}

if ( $related_products ) : ?>

	<section class="related products">

		<h4 class="title"><?php esc_html_e( 'Related products', 'charitab-wp' ); ?></h4>
		
		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $related_products as $related_product ) : ?>

				<?php
				 	$post_object = get_post( $related_product->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );

					wc_get_template_part( 'content', 'product' ); ?>

			<?php endforeach; ?>

		<?php woocommerce_product_loop_end(); ?>

	</section>

<?php endif;

wp_reset_postdata();