<?php

if(!function_exists('mascot_core_charitab_sc_timeline_cd_vertical_thumb_css')) {
	/**
	 * Get Thumb Styles
	 */
	function mascot_core_charitab_sc_timeline_cd_vertical_thumb_css( $params ) {
		$css_array = array();

		if( $params['timeline_thumb_custom_bg_color'] != '' ) {
			$css_array[] = 'background-color: '.esc_attr( $params['timeline_thumb_custom_bg_color'] );
		}
		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_timeline_cd_vertical_thumb_text_css')) {
	/**
	 * Get Thumb Text Styles
	 */
	function mascot_core_charitab_sc_timeline_cd_vertical_thumb_text_css( $params ) {
		$css_array = array();

		if( $params['timeline_thumb_custom_text_color'] != '' ) {
			$css_array[] = 'color: '.esc_attr( $params['timeline_thumb_custom_text_color'] );
		}
		return implode( '; ', $css_array );
	}
}

$args = array(
	"reverse_blocks" => "",
	"timeline_thumb_image" => "",
	"timeline_thumb_image_text" => "",
	"timeline_thumb_custom_bg_color" => "",
	"timeline_thumb_custom_text_color" => "",
);

$html = "";
$reverse_blocks = "";
$timeline_thumb_image = "";
$timeline_thumb_image_text = "";
$timeline_thumb_custom_bg_color = "";
$timeline_thumb_custom_text_color = "";

$params = shortcode_atts($args, $atts);
extract($params);


$timeline_cd_vertical_thumb = charitab_mascot_get_inline_css( mascot_core_charitab_sc_timeline_cd_vertical_thumb_css( $params ) );
$timeline_cd_vertical_thumb_text = charitab_mascot_get_inline_css( mascot_core_charitab_sc_timeline_cd_vertical_thumb_text_css( $params ) );


if( $reverse_blocks == 'true' ) {
	$reverse_blocks = 'cd-timeline__block-reverse';
}

$html = '<div class="cd-timeline__block js-cd-block '.esc_attr( $reverse_blocks ).'">';
$html .= '<div class="cd-timeline__img js-cd-img d-flex align-items-center" '.$timeline_cd_vertical_thumb.'>';
if( !empty($timeline_thumb_image) ) {
	$image = wp_get_attachment_image_src( $timeline_thumb_image, 'large');
	if( !empty($image[0]) ) {
		$html .= '<img src="'.esc_url( $image[0] ).'" alt="pic">';
	}
}
if( !empty($timeline_thumb_image_text) ) {
	$html .= '<div class="cd-timeline__text" '.$timeline_cd_vertical_thumb_text.'>';
	$html .= esc_html( $timeline_thumb_image_text );
	$html .= '</div>';
}
$html .= '</div>';
$html .= do_shortcode($content);
$html .= '</div>';

$output = htmlentities($html);
echo html_entity_decode($output);


