<?php

$args = array(
	"show_anchor_menu" => "false",
	"anchor_menu" => "",
	"show_navigation_bullet_menu" => "true",
	"navigation_position" => "right",
	"show_tooltips_on_navigation_bullet_menu" => "false",
	"tooltips_on_navigation" => "",
	"show_navigation_landscape_slider" => "true",
	"scrolling_speed" => "700",
	"responsive_width" => "1000",
	"easing" => "easeInQuart",
	"looptop" => "true",
	"loopbottom" => "true",
);

$html = "";
$show_anchor_menu = "";
$anchor_menu = "";
$show_navigation_bullet_menu = "";
$navigation_position = "";
$show_tooltips_on_navigation_bullet_menu = "";
$tooltips_on_navigation = "";
$show_navigation_landscape_slider = "";
$scrolling_speed = "";
$responsive_width = "";
$easing = "";

extract(shortcode_atts($args, $atts));

wp_enqueue_script( 'jquery-fullpage' );

if( is_rtl() ) {
	wp_enqueue_style( 'jquery-fullpage' );
} else {
	wp_enqueue_style( 'jquery-fullpage' );
}


$menu_list = explode(',', $anchor_menu);
$tooltips_on_navigation_list = explode(',', $tooltips_on_navigation);

$html = "";

$html .= '<div id="fullpage-container" class="tm-full-page-slider" data-anchor="'.esc_attr( $show_anchor_menu ).'" data-anchor-menu="'.esc_attr( $anchor_menu ).'" data-navigation="'.esc_attr( $show_navigation_bullet_menu ).'" data-navigation-position="'.esc_attr( $navigation_position ).'" data-navigation-tooltip="'.esc_attr( $show_tooltips_on_navigation_bullet_menu ).'" data-navigation-tooltips="'.esc_attr( $tooltips_on_navigation ).'" data-horizontal-navigation="'.esc_attr( $show_navigation_landscape_slider ).'" data-scrolling-speed="'.esc_attr( $scrolling_speed ).'" data-responsive-width="'.esc_attr( $responsive_width ).'" data-easing="'.esc_attr( $easing ).'" data-looptop="'.esc_attr( $looptop ).'" data-loopbottom="'.esc_attr( $loopbottom ).'">';
$i = 0;
if( $show_anchor_menu && !empty($menu_list) ) {
	$html .= '<ul id="tm-full-page-menu">';
	foreach( $menu_list as $item ) {
		$item = trim( $item );
		$active = '';
		if($i==0) { 
			$active = 'class="active"';
		}
		$html .= '<li data-menuanchor="'. esc_attr( $item ) .'" '.esc_attr( $active ).'><a href="#'. esc_attr( $item ) .'">'. esc_html( $item ) .'</a></li>';
		$i++;
	}
	$html .= '</ul>';
}
$html .= do_shortcode($content);
$html .= '</div>';

$output = htmlentities($html);
echo html_entity_decode($output);

