<?php
use MASCOTCORECHARITAB\CPT\Testimonials\CPT_Testimonials;

/*
 * outputs mascot_core_charitab_widget_testimonials widget.
 */
if( !function_exists( 'mascot_core_charitab_widget_testimonials' ) ) {
	function mascot_core_charitab_widget_testimonials( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//get gallery instance
		$new_cpt_class = CPT_Testimonials::Instance();
		//default posts per page
		$posts_per_page = ( $instance['items_count'] == '' ) ? -1 : $instance['items_count'];
		//query args
		$query_args = array(
			'post_type' => $new_cpt_class->ptKey,
			'orderby' => $instance['order_by'],
			'order' => $instance['order'],
			'posts_per_page' => $posts_per_page,
		);

		$the_query = new \WP_Query( $query_args );
		$instance['the_query'] = $the_query;


		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = charitab_mascot_get_widget_template_part( 'testimonials' . '-' . $instance['type'], null, 'testimonials/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}