<?php

/*
 * outputs mascot_core_charitab_widget_social_list widget.
 */
if( !function_exists( 'mascot_core_charitab_widget_social_list' ) ) {
	function mascot_core_charitab_widget_social_list( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Enabled social links
		$instance['social_links'] = charitab_mascot_get_redux_option( 'social-links-ordering', false, 'Enabled' );

		$icon_brand_colored = isset($instance['icon_brand_colored']) ? $instance['icon_brand_colored'] : null;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = charitab_mascot_get_widget_template_part( 'social-list', $icon_brand_colored, 'social-list/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}