<?php
use MASCOTCORECHARITAB\CPT\Portfolio\CPT_Portfolio;

/*
 * outputs mascot_core_charitab_widget_portfolio widget.
 */
if( !function_exists( 'mascot_core_charitab_widget_portfolio' ) ) {
	function mascot_core_charitab_widget_portfolio( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//get gallery instance
		$new_cpt_class = CPT_Portfolio::Instance();
		//default posts per page
		$posts_per_page = ( $instance['items_count'] == '' ) ? -1 : $instance['items_count'];
		//query args
		$query_args = array(
			'post_type' => $new_cpt_class->ptKey,
			'orderby' => $instance['order_by'],
			'order' => $instance['order'],
			'posts_per_page' => $posts_per_page,
		);

		$the_query = new \WP_Query( $query_args );
		$instance['the_query'] = $the_query;

		//ptTaxKey
		$instance['ptTaxKey'] = $new_cpt_class->ptTaxKey;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = charitab_mascot_get_widget_template_part( 'portfolio' . '-' . $instance['type'], null, 'portfolio/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}