<?php

/*
 * outputs mascot_core_charitab_widget_google_map widget.
 */
if( !function_exists( 'mascot_core_charitab_widget_google_map' ) ) {
	function mascot_core_charitab_widget_google_map( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		if( $instance['lat'] == '' ) $instance['lat'] = '-37.817314';
		if( $instance['long'] == '' ) $instance['long'] = '144.955431';
		if( $instance['zoom'] == '' ) $instance['zoom'] = '10';
		if( $instance['height'] == '' ) $instance['height'] = '300';
		if( $instance['marker_url'] == '' ) $instance['marker_url'] = CHARITAB_MASCOT_ASSETS_URI . '/images/map-marker1.png';


		//Enque Google Map Scripts
		wp_enqueue_script( array( 'google-maps-api', 'google-maps-init' ) );
		

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = charitab_mascot_get_widget_template_part( 'google-map', null, 'google-map/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}