
<?php if ( $the_query->have_posts() ) : ?>
	<div class="row tm-sc tm-sc-tribe-events tm-sc-tribe-events-fullwidth <?php echo esc_attr(implode(' ', $classes)); ?>">
		<!-- the loop -->
		<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div class="col-md-12">
			<div id="post-<?php $post_id = get_the_ID() ?>" class="event <?php tribe_events_event_classes() ?>">
				<div class="row">
					<?php if ( has_post_thumbnail() && $show_thumb == 'true' ) : ?>
						<?php if ( $show_timer == 'true' ||  $show_view_details_button == 'true' ) { ?>
						<div class="col-sm-2">
						<?php } else if ( $show_timer == 'true' ) { ?>
						<div class="col-sm-2">
						<?php } else { ?>
						<div class="col-sm-4">
						<?php } ?>
							<div class="event-thumb">
								<?php echo tribe_event_featured_image( null, $feature_thumb_image_size ); ?>
							</div>
						</div>
					<?php endif; ?>
					<div class="col">
						<div class="event-content">
							<?php if ( $show_title == 'true' ) : ?>
							<h4 class="event-title mt-0">
								<a href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute(); ?>">
									<?php the_title() ?>
								</a>
							</h4>
							<?php endif; ?>

							<?php if ( $show_meta == 'true' ) : ?>
							<?php charitab_mascot_get_shortcode_template_part( 'parts-event-meta', null, 'tribe-events/tpl', $params, false );?>
							<?php endif; ?>

							<?php if ( $show_excerpt == 'true' ) : ?>
							<div class="event-excerpt">
								<?php if ( empty($excerpt_length) ) { ?>
								<?php echo tribe_events_get_the_excerpt( null, wp_kses_allowed_html( 'post' ) ); ?>
								<?php } else { ?>
								<?php $excerpt = tribe_events_get_the_excerpt( null, wp_kses_allowed_html( 'post' ) ); echo wp_kses_post( charitab_mascot_slice_excerpt_by_length( $excerpt, $excerpt_length ) ); ?>
								<?php } ?>
							</div>
							<?php endif; ?>
						</div>
					</div>
					<?php if ( $show_timer == 'true' ) : ?>
					<div class="col">
						<?php $date_string = tribe_get_start_date( $post_id, false, 'Y/m/d H:i:s' ) ?>
						<?php echo do_shortcode('[tm_countdown_timer design_style="final-countdown-smart-style" countdown_future_date_time="'.$date_string.'" word_hr="hours" word_min="minutes" word_sec="seconds"]')?>
					</div>
					<?php endif; ?>
					<?php if ( $show_view_details_button == 'true' ) { ?>
						<?php if ( has_post_thumbnail($post_id) && $show_thumb == 'true' ) : ?>
						<div class="col-sm-2 text-right">
						<?php else: ?>
						<div class="col-sm-3 text-right">
						<?php endif; ?>
							<?php charitab_mascot_get_shortcode_template_part( 'button', null, 'tribe-events/tpl', $params, false );?>
						</div>
					<?php } ?>
				</div>
			</div>

		</div>
		<?php endwhile; ?>
		<!-- end of the loop -->
	</div>
	<?php wp_reset_postdata(); ?>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>