
<?php if ( $the_query->have_posts() ) : ?>
	<div class="tm-sc tm-sc-tribe-events tm-sc-tribe-events-fullwidth <?php echo esc_attr(implode(' ', $classes)); ?>">
		<!-- the loop -->
		<div id="<?php echo esc_attr( $holder_id ) ?>" class="clearfix">
			<div class="row">
				<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
				<div class="col-md-12">
					<div id="post-<?php the_ID() ?>" class="event <?php tribe_events_event_classes() ?>">
						<div class="row">
							<div class="col-sm-2">
								<?php if ( $vertical_show_left_date == 'true' ) : ?>
								<div class="event-date">
									<span class="day"><?php echo tribe_get_start_date( get_the_ID(), false, 'd' ) ?></span>
									<span class="month"><?php echo tribe_get_start_date( get_the_ID(), false, 'F' ) ?></span>
									<!-- <span class="year"><?php echo tribe_get_start_date( get_the_ID(), false, 'Y' ) ?></span> -->
								</div>
								<?php endif; ?>
							</div>
							<div class="col-sm-3">
								<?php if ( has_post_thumbnail() && $show_thumb == 'true' ) : ?>
								<div class="event-thumb">
									<?php echo tribe_event_featured_image( null, $feature_thumb_image_size ); ?>
								</div>
								<?php endif; ?>
							</div>
							<div class="col-sm-7">
								<div class="event-content">
									<?php charitab_mascot_get_shortcode_template_part( 'parts-event-content', null, 'tribe-events/tpl', $params, false );?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endwhile; ?>
				<!-- end of the loop -->
			</div>
		</div>
	</div>
	<?php wp_reset_postdata(); ?>
		
	<?php charitab_mascot_get_shortcode_template_part( 'show-more-btn', null, 'tribe-events/tpl', $params, false ); ?>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>