<?php

if(!function_exists('mascot_core_charitab_sc_section_title_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_section_title_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_section_title_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_section_title_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'design_style' => 'style1',
			'text_alignment' => '',
			
			'title_text' => '',
			'title_part1_theme_colored' => '',

			'title_text_part2' => '',
			'title_part2_theme_colored' => '',

			'title_text_part3' => '',
			'title_part3_theme_colored' => '',

			'title_shadow_text' => '',
			'sub_title_text' => '',
			'sub_title_position' => 'above-title',
			'line_bottom_style' => '',



			'title_custom_css_class' => '',
			'title_tag' => 'h2',
			'title_text_color' => '',
			'title_font_size' => '',
			'title_line_height' => '',
			'title_letter_spacing' => '',
			'title_font_style' => '',
			'title_font_weight' => '',
			'title_text_transform' => '',

			'sub_title_custom_css_class' => '',
			'subtitle_tag' => 'h5',
			'subtitle_text_color' => '',
			'subtitle_font_size' => '',
			'subtitle_line_height' => '',
			'subtitle_letter_spacing' => '',
			'subtitle_font_style' => '',
			'subtitle_font_weight' => '',
			'subtitle_text_transform' => '',

			'title_shadow_text_text_color' => '',
			'title_shadow_text_top' => '',
			'title_shadow_text_font_size' => '',
			'title_shadow_text_line_height' => '',
			'title_shadow_text_letter_spacing' => '',
			'title_shadow_text_font_style' => '',
			'title_shadow_text_font_weight' => '',
			'title_shadow_text_text_transform' => '',

			'css_animation' => '',


			'css' => '',
		);

		$params = shortcode_atts($args, $attr);
		$params['content'] = $content;
		$params['title_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_section_title_css( $params ) );
		$params['sub_title_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_section_sub_title_css( $params ) );
		$params['title_shadow_text_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_section_title_shadow_text_css( $params ) );

		//classes
		$classes = array();

		if( $params['text_alignment'] ) {
			$classes[] = $params['text_alignment'];
		}
		
		//css animation
		VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Btn' );
		$vc_btn = new WPBakeryShortCode_VC_Btn( array( 'base' => 'vc_btn' ) );
		$classes[] = $vc_btn->getCSSAnimation( $params['css_animation'] );


		
		$classes[] = $params['line_bottom_style'];
		$classes[] = $params['custom_css_class'];
		//css
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;

		
		//title classes
		$title_classes = array();
		$title_classes[] = $params['title_custom_css_class'];
		$params['title_classes'] = $title_classes;
		
		//sub title classes
		$sub_title_classes = array();
		$sub_title_classes[] = $params['sub_title_custom_css_class'];
		$params['sub_title_classes'] = $sub_title_classes;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'section-title-' . $params['design_style'], null, 'section-title/tpl', $params, true );
		
		return $html;
	}
}

if(!function_exists('mascot_core_charitab_sc_section_title_css')) {
	/**
	 * Get Title Styles
	 */
	function mascot_core_charitab_sc_section_title_css( $params ) {
		$css_array = array();

		if( $params['title_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['title_text_color'];
		}
		if( $params['title_font_size'] != '' ) {
			$font_size = $params['title_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['title_line_height'] != '' ) {
			$line_height = $params['title_line_height'];
			$css_array[] = 'line-height: '.$line_height;
		}
		if( $params['title_letter_spacing'] != '' ) {
			$letter_spacing = $params['title_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$letter_spacing;
		}
		if( $params['title_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['title_font_style'];
		}
		if( $params['title_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['title_font_weight'];
		}
		if( $params['title_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['title_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_section_sub_title_css')) {
	/**
	 * Get Title Styles
	 */
	function mascot_core_charitab_sc_section_sub_title_css( $params ) {
		$css_array = array();

		if( $params['subtitle_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['subtitle_text_color'];
		}
		if( $params['subtitle_font_size'] != '' ) {
			$font_size = $params['subtitle_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['subtitle_line_height'] != '' ) {
			$line_height = $params['subtitle_line_height'];
			$css_array[] = 'line-height: '.$line_height;
		}
		if( $params['subtitle_letter_spacing'] != '' ) {
			$letter_spacing = $params['subtitle_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$letter_spacing;
		}
		if( $params['subtitle_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['subtitle_font_style'];
		}
		if( $params['subtitle_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['subtitle_font_weight'];
		}
		if( $params['subtitle_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['subtitle_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_section_title_shadow_text_css')) {
	/**
	 * Get Title Shadow Text Styles
	 */
	function mascot_core_charitab_sc_section_title_shadow_text_css( $params ) {
		$css_array = array();

		if( $params['title_shadow_text_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['title_shadow_text_text_color'];
		}
		if( $params['title_shadow_text_top'] != '' ) {
			$text_top = $params['title_shadow_text_top'];
			$css_array[] = 'top: '.$text_top;
		}
		if( $params['title_shadow_text_font_size'] != '' ) {
			$font_size = $params['title_shadow_text_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['title_shadow_text_line_height'] != '' ) {
			$line_height = $params['title_shadow_text_line_height'];
			$css_array[] = 'line-height: '.$line_height;
		}
		if( $params['title_shadow_text_letter_spacing'] != '' ) {
			$letter_spacing = $params['title_shadow_text_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$letter_spacing;
		}
		if( $params['title_shadow_text_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['title_shadow_text_font_style'];
		}
		if( $params['title_shadow_text_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['title_shadow_text_font_weight'];
		}
		if( $params['title_shadow_text_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['title_shadow_text_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}