<?php

if(!function_exists('mascot_core_charitab_sc_pricing_table_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_pricing_table_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}




if(!function_exists('mascot_core_charitab_sc_pricing_table_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_pricing_table_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'design_style' => 'style1',
			'pricing_image' => '',

			'title' => '',
			'sub_title' => '',

			'price_prefix' => '',
			'price' => '',
			'price_separator' => '',
			'price_postfix' => '',


			'title_custom_css_class' => '',
			'title_tag' => 'h4',
			'title_text_color' => '',
			'title_font_size' => '',
			'title_line_height' => '',
			'title_letter_spacing' => '',
			'title_font_style' => '',
			'title_font_weight' => '',
			'title_text_transform' => '',


			'subtitle_custom_css_class' => '',
			'subtitle_tag' => 'h5',
			'subtitle_text_color' => '',
			'subtitle_font_size' => '',
			'subtitle_line_height' => '',
			'subtitle_letter_spacing' => '',
			'subtitle_font_style' => '',
			'subtitle_font_weight' => '',
			'subtitle_text_transform' => '',


			'price_text_color' => '',
			'price_font_size' => '',
			'price_line_height' => '',
			'price_letter_spacing' => '',
			'price_font_style' => '',
			'price_font_weight' => '',
			'price_text_transform' => '',


			'disable_list_bullets' => '',
			'list_bordered' => '',
			'put_pricing_info_after_text' => '',
			'put_pricing_image_after_title' => '',
			'make_this_table_featured' => '',
			'make_hover_effect' => '',
			'add_box_shadow_around_table' => 'true',
			'label_text' => '',
			
			'button' => '',

			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',
			
			'css' => '',
			'css_animation' => '',
		);

		$params = shortcode_atts($args, $attr);
		$params['content'] = $content;
		
		//link url
		$params['button'] = vc_build_link( $params['button'] );
		if( empty( $params['button']['title']  ) ) {
			$params['button']['title'] = esc_html__( 'Book Now', 'charitab-wp' );
		}

		//classes
		$classes = array();
		$classes[] = (!empty($params['label_text']) ) ? 'has-label' : '';

		//css animation
		VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Btn' );
		$vc_btn = new WPBakeryShortCode_VC_Btn( array( 'base' => 'vc_btn' ) );
		$classes[] = $vc_btn->getCSSAnimation( $params['css_animation'] );
		
		$classes[] = 'pricing-table-' . $params['design_style'];

		if( ! $params['disable_list_bullets'] ) {
			$classes[] = 'pricing-list-bullet';
		}
		if( $params['list_bordered'] ) {
			$classes[] = 'pricing-list-bordered';
		}
		if( $params['make_this_table_featured'] ) {
			$classes[] = 'pricing-table-featured';
		}
		if( $params['make_hover_effect'] ) {
			$classes[] = 'pricing-table-hover-effect';
		}
		if( $params['add_box_shadow_around_table'] ) {
			$classes[] = 'pricing-table-box-shadow';
		}

		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;
		$params['title_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_pricing_table_title_css( $params ) );
		$params['subtitle_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_pricing_table_subtitle_css( $params ) );
		$params['price_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_pricing_table_price_css( $params ) );

		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );

		//title classes
		$title_classes = array();
		$title_classes[] = $params['title_custom_css_class'];
		$params['title_classes'] = $title_classes;
		
		//sub title classes
		$sub_title_classes = array();
		$sub_title_classes[] = $params['subtitle_custom_css_class'];
		$params['sub_title_classes'] = $sub_title_classes;


		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'pricing-table', $params['design_style'], 'pricing-table/tpl', $params, true );
		
		return $html;
	}
}

if(!function_exists('mascot_core_charitab_sc_pricing_table_title_css')) {
	/**
	 * Get Title Styles
	 */
	function mascot_core_charitab_sc_pricing_table_title_css( $params ) {
		$css_array = array();

		if( $params['title_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['title_text_color'];
		}
		if( $params['title_font_size'] != '' ) {
			$font_size = $params['title_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['title_line_height'] != '' ) {
			$font_size = $params['title_line_height'];
			$css_array[] = 'line-height: '.$font_size;
		}
		if( $params['title_letter_spacing'] != '' ) {
			$font_size = $params['title_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$font_size;
		}
		if( $params['title_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['title_font_style'];
		}
		if( $params['title_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['title_font_weight'];
		}
		if( $params['title_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['title_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_pricing_table_subtitle_css')) {
	/**
	 * Get Sub Title Styles
	 */
	function mascot_core_charitab_sc_pricing_table_subtitle_css( $params ) {
		$css_array = array();

		if( $params['subtitle_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['subtitle_text_color'];
		}
		if( $params['subtitle_font_size'] != '' ) {
			$font_size = $params['subtitle_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['subtitle_line_height'] != '' ) {
			$font_size = $params['subtitle_line_height'];
			$css_array[] = 'line-height: '.$font_size;
		}
		if( $params['subtitle_letter_spacing'] != '' ) {
			$font_size = $params['subtitle_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$font_size;
		}
		if( $params['subtitle_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['subtitle_font_style'];
		}
		if( $params['subtitle_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['subtitle_font_weight'];
		}
		if( $params['subtitle_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['subtitle_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_pricing_table_price_css')) {
	/**
	 * Get Price Styles
	 */
	function mascot_core_charitab_sc_pricing_table_price_css( $params ) {
		$css_array = array();

		if( $params['price_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['price_text_color'];
		}
		if( $params['price_font_size'] != '' ) {
			$font_size = $params['price_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['price_line_height'] != '' ) {
			$font_size = $params['price_line_height'];
			$css_array[] = 'line-height: '.$font_size;
		}
		if( $params['price_letter_spacing'] != '' ) {
			$font_size = $params['price_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$font_size;
		}
		if( $params['price_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['price_font_style'];
		}
		if( $params['price_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['price_font_weight'];
		}
		if( $params['price_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['price_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}