<?php
  $random_number = wp_rand( 111111, 999999 );
?>

<!-- ===== START: Paypal Both Onetime/Recurring Form ===== -->
<form id="paypal_donate_form_onetime_recurring-<?php echo esc_attr( $random_number ); ?>" class="<?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="row">
		<div class="col-md-12">
			<div class="form-group">
				<h5><?php esc_html_e( 'Payment Type', 'charitab-wp' ); ?></h5>
				<label class="radio-inline">
					<input type="radio" checked="" value="one_time" name="payment_type"> 
					<?php esc_html_e( 'One Time', 'charitab-wp' ); ?>
				</label>
				<label class="radio-inline">
					<input type="radio" value="recurring" name="payment_type"> 
					<?php esc_html_e( 'Recurring', 'charitab-wp' ); ?>
				</label>
			</div>
		</div>

		<div class="col-sm-12" id="donation_type_choice-<?php echo esc_attr( $random_number ); ?>">
			<div class="form-group mb-20">
				<h5><?php esc_html_e( 'Donation Type', 'charitab-wp' ); ?></h5>
				<div class="radio mt-3">
					<label class="radio-inline">
						<input type="radio" value="D" name="t3" checked="">
						<?php esc_html_e( 'Daily', 'charitab-wp' ); ?></label>
					<label class="radio-inline">
						<input type="radio" value="W" name="t3">
						<?php esc_html_e( 'Weekly', 'charitab-wp' ); ?></label>
					<label class="radio-inline">
						<input type="radio" value="M" name="t3">
						<?php esc_html_e( 'Monthly', 'charitab-wp' ); ?></label>
					<label class="radio-inline">
						<input type="radio" value="Y" name="t3">
						<?php esc_html_e( 'Yearly', 'charitab-wp' ); ?></label>
				</div>
			</div>
		</div>

		<div class="col-sm-6">
			<div class="form-group mb-20">
				<h5><?php esc_html_e( 'Donate for', 'charitab-wp' ); ?></h5>
				<select name="item_name" class="form-control">
					<?php foreach( $donate_for as $each_value) { ?>
					<option value="<?php echo esc_attr( strip_tags( $each_value ) ); ?>"><?php echo esc_html( strip_tags( $each_value ) ); ?></option>
					<?php } ?>
				</select>
			</div>
		</div>

		<div class="col-sm-6">
			<div class="form-group mb-20">
				<h5><?php esc_html_e( 'Currency', 'charitab-wp' ); ?></h5>
				<select name="currency_code" class="form-control">
					<option value=""><?php esc_html_e( 'Select Currency', 'charitab-wp' ); ?></option>
					<?php foreach( $currency as $key => $each_value) { ?>
					<option value="<?php echo esc_attr( strip_tags( $key ) ); ?>"><?php echo esc_html( strip_tags( $each_value ) ); ?></option>
					<?php } ?>
				</select>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group mb-20">
				<h5><?php esc_html_e( 'Donation Amount', 'charitab-wp' ); ?></h5>
				<select id="amount-<?php echo esc_attr( $random_number ); ?>" name="amount" class="form-control">
					<?php foreach( $suggested_donation_amounts as $each_value) { ?>
					<option value="<?php echo esc_attr( strip_tags( $each_value ) ); ?>"><?php echo esc_html( strip_tags( $each_value ) ); ?></option>
					<?php } ?>
					<option value="other"><?php esc_html_e( 'Other Amount', 'charitab-wp' ); ?></option>
				</select>
				<div id="custom_other_amount-<?php echo esc_attr( $random_number ); ?>" class="mt-20">
					<h5><?php esc_html_e( 'Custom Amount', 'charitab-wp' ); ?></h5>
				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<?php if( $submit_button_type == 'image' ) { ?>
				<input type="image" src="https://www.paypal.com/en_US/i/btn/btn_donateCC_LG.gif" name="submit" alt="<?php esc_attr_e( 'PayPal - The safer, easier way to pay online!', 'charitab-wp' ); ?>">
				<img alt="paypal" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
				<?php } else { ?>
				<button type="submit" class="<?php echo esc_attr( apply_filters( 'charitab_mascot_paypal_donation_onetime_recurring_donate_btn', 'btn btn-theme-colored1') ); ?>" data-loading-text="Please wait..."><?php esc_html_e( 'Donate Now', 'charitab-wp' ); ?></button>
				<?php } ?>
			</div>
		</div>
	</div>
</form>

<!-- Script for Donation Form Custom Amount -->
<script>
	$(document).ready(function(e) {
		var $donation_form = $("#paypal_donate_form_onetime_recurring-<?php echo esc_attr( $random_number ); ?>");
		var $custom_other_amount = $donation_form.find("#custom_other_amount-<?php echo esc_attr( $random_number ); ?>");
		$custom_other_amount.hide();
		$donation_form.find("[name='amount']").change(function() {
				var $this = $(this);
				if ($this.val() === 'other') {
					$custom_other_amount.show().append('<div class="input-group"><div class="input-group-prepend"><div class="input-group-text">$</div></div> <input id="input_other_amount-<?php echo esc_attr( $random_number ); ?>" type="text" name="amount" class="form-control" value="100"/></div>');
				}
				else{
					$custom_other_amount.children( ".input-group" ).remove();
					$custom_other_amount.hide();
				}
		});

		//toggle donation_type_choice
		var $donation_type_choice = $donation_form.find("#donation_type_choice-<?php echo esc_attr( $random_number ); ?>");
		$donation_type_choice.hide();
		$donation_form.find("[name='payment_type']").change(function() {
				if (this.value === 'recurring') {
						$donation_type_choice.show();
				}
				else {
						$donation_type_choice.hide();
				}
		});


		// submit form on click
		$donation_form.on('submit', function(e){
				//$( "#paypal_donate_form-onetime" ).submit();
				var item_name = $donation_form.find("select[name='item_name'] option:selected").val();
				var currency_code = $donation_form.find("select[name='currency_code'] option:selected").val();
				var amount = $donation_form.find("select[name='amount'] option:selected").val();
				var t3 = $donation_form.find("input[name='t3']:checked").val();

				if ( amount === 'other') {
					amount = $donation_form.find("#input_other_amount-<?php echo esc_attr( $random_number ); ?>").val();
				}

				// submit proper form now
				if ( $("input[name='payment_type']:checked", $donation_form).val() === 'recurring' ) {
						var recurring_form = $('#paypal_donate_form-recurring-<?php echo esc_attr( $random_number ); ?>');

						recurring_form.find("input[name='item_name']").val(item_name);
						recurring_form.find("input[name='currency_code']").val(currency_code);
						recurring_form.find("input[name='a3']").val(amount);
						recurring_form.find("input[name='t3']").val(t3);

						recurring_form.find("input[type='submit']").trigger('click');

				} else if ( $("input[name='payment_type']:checked", $donation_form).val() === 'one_time' ) {
						var onetime_form = $('#paypal_donate_form-onetime-<?php echo esc_attr( $random_number ); ?>');

						onetime_form.find("input[name='item_name']").val(item_name);
						onetime_form.find("input[name='currency_code']").val(currency_code);
						onetime_form.find("input[name='amount']").val(amount);

						onetime_form.find("input[type='submit']").trigger('click');
				}
				return false;
		});

	});
</script>

<!-- Paypal Onetime Form -->
<form id="paypal_donate_form-onetime-<?php echo esc_attr( $random_number ); ?>" class="d-none" action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_donations">
	<input type="hidden" name="business" value="<?php echo esc_attr( $paypal_email ); ?>">

	<input type="hidden" name="item_name" value=""> <!-- updated dynamically -->
	<input type="hidden" name="currency_code" value="USD"> <!-- updated dynamically -->
	<input type="hidden" name="amount" value="20"> <!-- updated dynamically -->

	<input type="hidden" name="no_shipping" value="1">
	<input type="hidden" name="cn" value="Comments...">
	<input type="hidden" name="tax" value="0">
	<input type="hidden" name="lc" value="US">
	<input type="hidden" name="bn" value="PP-DonationsBF">
	<input type="hidden" name="return" value="<?php echo esc_url( $return_url ); ?>">
	<input type="hidden" name="cancel_return" value="<?php echo esc_url( $return_url ); ?>">
	<input type="hidden" name="notify_url" value="<?php echo esc_url( $return_url ); ?>">
	<input type="submit" name="submit">
</form>

<!-- Paypal Recurring Form -->
<form id="paypal_donate_form-recurring-<?php echo esc_attr( $random_number ); ?>" class="d-none" action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_xclick-subscriptions">
	<input type="hidden" name="business" value="<?php echo esc_attr( $paypal_email ); ?>">

	<input type="hidden" name="item_name" value=""> <!-- updated dynamically -->
	<input type="hidden" name="currency_code" value="USD"> <!-- updated dynamically -->
	<input type="hidden" name="a3" value="20"> <!-- updated dynamically -->
	<input type="hidden" name="t3" value="D"> <!-- updated dynamically -->


	<input type="hidden" name="p3" value="1">
	<input type="hidden" name="rm" value="2">
	<input type="hidden" name="src" value="1">
	<input type="hidden" name="sra" value="1">
	<input type="hidden" name="no_shipping" value="0">
	<input type="hidden" name="no_note" value="1">                     
	<input type="hidden" name="lc" value="US">
	<input type="hidden" name="bn" value="PP-DonationsBF">
	<input type="hidden" name="return" value="<?php echo esc_url( $return_url ); ?>">
	<input type="hidden" name="cancel_return" value="<?php echo esc_url( $cancel_return_url ); ?>">
	<input type="hidden" name="notify_url" value="<?php echo esc_url( $notify_url ); ?>">
	<input type="submit" name="submit">
</form>
<!-- ===== END: Paypal Both Onetime/Recurring Form ===== -->


