<?php

if(!function_exists('mascot_core_charitab_sc_give_campaigns_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_give_campaigns_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_give_campaigns_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_give_campaigns_render( $attr, $content = null ) {
		$class_instance =  array();
		$args = array(
			'custom_css_class' => '',
			'display_type' => '',
			'columns' => '4',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'category' => '',
			'tag' => '',
			'campaigns_id' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'show_thumb' => 'true',
			'feature_thumb_image_size' => 'post-thumbnail',
			'show_title' => 'true',
			'show_excerpt'	=> 'true',
			'excerpt_length'	=> '',
			'show_meta' => 'true',
			'meta_options' => 'true',
			'show_progress' => 'true',
			'show_donation_stats' => 'true',

			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',

			
			//button
			'show_view_details_button' => 'true',
			'view_details_button_text' => esc_html__( 'View Details', 'charitab-wp' ),
			

			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',


			//donate button
			'donate_show_view_details_button' => 'true',
			'donate_view_details_button_text' => esc_html__( 'Donate Now', 'charitab-wp' ),
			
			'donate_btn_design_style' => 'default',
			'donate_button_size' => '',
			'donate_btn_outlined' => false,
			'donate_btn_round' => false,
			'donate_btn_flat' => false,
			'donate_btn_block' => false,
			'donate_btn_threed_effect' => false,
			'donate_button_alignment' => '',
			'donate_button_hover_animation_effect' => '',


			//loadmore button options
			'loadmore_show_view_details_button' => 'false',
			'loadmore_view_details_button_text' => esc_html__( 'Load More', 'charitab-wp' ),
			'loadmore_button_loading_text' => esc_html__( 'Loading...', 'charitab-wp' ),
			'loadmore_btn_design_style' => 'default',
			'loadmore_button_size' => '',
			'loadmore_btn_outlined' => false,
			'loadmore_btn_round' => false,
			'loadmore_btn_flat' => false,
			'loadmore_btn_block' => false,
			'loadmore_btn_threed_effect' => false,
			'loadmore_button_alignment' => '',
			'loadmore_button_hover_animation_effect' => '',

			'css' => '',
		);
		//extract(shortcode_atts($args, $attr));
		$params = shortcode_atts($args, $attr);
		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('give-campaigns');
		charitab_mascot_custom_loadmore_enque_script( 'give-campaigns', $params, $class_instance );

		return mascot_core_charitab_sc_give_campaigns_render_output( $class_instance, $params );
	}
}


if(!function_exists('mascot_core_charitab_sc_give_campaigns_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_charitab_sc_give_campaigns_render_output( $class_instance, $params ) {
		$new_cpt_class = $class_instance;
		$paged = isset($params['paged']) ? $params['paged'] : '';

		if( $params['display_type'] != 'masonry' ) {
			$params['use_masonry_tiles_featured_image_size'] = 'false';
		}
		
		
		//query args
		$args = array(
			'post_type' => 'give_forms',
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
			'paged' => $paged,
		);

		//if order by client_author_name selected
		if( $params['order_by'] == 'end-date' ) {
			$args['meta_key'] = '_campaign_end_date';
			$args['orderby']  = 'meta_value';
		}

		/* Specific campaign IDs */
		if ( ! empty( $params['campaigns_id'] ) ) {
			$args['post__in'] = explode( ',', $params['campaigns_id'] );
		}

		//if category selected
		if( ! empty( $params['category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'give_forms_category',
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['category']),
				)
			);
		}

		/* Set tag constraint */
		if ( ! empty( $params['tag'] ) ) {
			if ( ! array_key_exists( 'tax_query', $args ) ) {
				$args['tax_query'] = array();
			}

			$args['tax_query'][] = array(
				'taxonomy' => 'give_forms_tag',
				'field'    => 'slug',
				'terms'    => explode( ',', $params['tag'] ),
			);
		}


		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && $params['from_loadmore_ajax_handler'] === true ) {
			return;
		}
		
		//classes
		$classes = array();
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;

		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );
		$params['donate_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'donate_' );
		$params['loadmore_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'loadmore_' );

		//meta options
		$params['meta_options'] = explode(',', $params['meta_options']);
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'campaigns', $params['display_type'], 'give-campaigns/tpl', $params, true );
		
		return $html;
	}
}