<?php

if(!function_exists('mascot_core_charitab_sc_custom_columns_holder_item_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_custom_columns_holder_item_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_custom_columns_holder_item_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_custom_columns_holder_item_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'section_typo' => '',

			'item_padding' => '',
			'horizontal_aligment' => '',
			'vertical_alignment' => '',

			'link' => '',
			'target' => '',

			'item_padding_1199_down' => '',
			'item_padding_991_down' => '',
			'item_padding_767_down' => '',
			'item_padding_575_down' => '',


			'item_padding_992_to_1199' => '',
			'item_padding_768_to_991' => '',
			'item_padding_576_to_767' => '',

			
			'item_padding_992_up' => '',
			'item_padding_1200_up' => '',
			'item_padding_768_up' => '',
			'item_padding_576_up' => '',

			'css' => '',
		);
		$params = shortcode_atts($args, $attr);
		$params['content']= $content;

		//classes
		$classes = array();
		$classes[] = $params['section_typo'];
		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;


		$rand_class = 'charitab-mascot-custom-columns-' . mt_rand(100000,1000000);


		$params['custom_columns_holder_item_class'] = charitab_mascot_sc_custom_columns_holder_item_class($params);
		$params['custom_columns_holder_item_content_style'] = charitab_mascot_sc_custom_columns_holder_item_content_style($params);
		$params['custom_columns_holder_item_content_class'] = $rand_class;
		$params['custom_columns_holder_item_responsive_data'] = charitab_mascot_sc_custom_columns_holder_item_content_responsive_data($params);

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'custom-columns-holder-item', null, 'custom-columns-holder/tpl', $params, true );

		return $html;
	}
}

if(!function_exists('charitab_mascot_sc_custom_columns_holder_item_class')) {
	/**
	 * Return Custom Columns Item classes
	 *
	 * @param $params
	 * @return array
	 */
	function charitab_mascot_sc_custom_columns_holder_item_class( $params ) {

		$custom_columns_holder_item_class = array();

		if ($params['vertical_alignment'] !== '') {
			$custom_columns_holder_item_class[] = 'tm-vertical-alignment-'. $params['vertical_alignment'];
		}

		if ($params['horizontal_aligment'] !== '') {
			$custom_columns_holder_item_class[] = 'tm-horizontal-alignment-'. $params['horizontal_aligment'];
		}
		return implode(' ', $custom_columns_holder_item_class);
	}
}

if(!function_exists('charitab_mascot_sc_custom_columns_holder_item_content_style')) {
	/**
	 * Return Custom Columns Item Content style
	 *
	 * @param $params
	 * @return array
	 */
	function charitab_mascot_sc_custom_columns_holder_item_content_style( $params ) {

		$custom_columns_holder_item_content_style = array();

		if ($params['item_padding'] !== '') {
			$custom_columns_holder_item_content_style[] = 'padding: ' . $params['item_padding'];
		}

		return implode(';', $custom_columns_holder_item_content_style);

	}
}

if(!function_exists('charitab_mascot_sc_custom_columns_holder_item_content_responsive_data')) {
	/**
	 * Return Custom Columns Item Content Responssive style
	 *
	 * @param $params
	 * @return array
	 */
	function charitab_mascot_sc_custom_columns_holder_item_content_responsive_data( $params ) {
		$data = array();
		$data['data-item-class'] = $params['custom_columns_holder_item_content_class'];

		//media-breakpoint-down
		if ($params['item_padding_1199_down'] !== '') {
			$data['data-1199-down'] = $params['item_padding_1199_down'];
		}
		if ($params['item_padding_991_down'] !== '') {
			$data['data-991-down'] = $params['item_padding_991_down'];
		}
		if ($params['item_padding_767_down'] !== '') {
			$data['data-767-down'] = $params['item_padding_767_down'];
		}
		if ($params['item_padding_575_down'] !== '') {
			$data['data-575-down'] = $params['item_padding_575_down'];
		}


		//media-breakpoint-only
		if ($params['item_padding_992_to_1199'] !== '') {
			$data['data-992-1199'] = $params['item_padding_992_to_1199'];
		}
		if ($params['item_padding_768_to_991'] !== '') {
			$data['data-768-991'] = $params['item_padding_768_to_991'];
		}
		if ($params['item_padding_576_to_767'] !== '') {
			$data['data-576-767'] = $params['item_padding_576_to_767'];
		}


		//media-breakpoint-up
		if ($params['item_padding_1200_up'] !== '') {
			$data['data-1200-up'] = $params['item_padding_1200_up'];
		}
		if ($params['item_padding_992_up'] !== '') {
			$data['data-992-up'] = $params['item_padding_992_up'];
		}
		if ($params['item_padding_768_up'] !== '') {
			$data['data-768-up'] = $params['item_padding_768_up'];
		}
		if ($params['item_padding_576_up'] !== '') {
			$data['data-576-up'] = $params['item_padding_576_up'];
		}

		return $data;
	}
}