<div class="tm-sc tm-sc-charitable-donation-stats icon-box <?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="donation-stats-inner">
		<div class="stats-icon icon <?php echo esc_attr(implode(' ', $icon_classes)); ?>">
			<?php if( $icon_type == 'image' ) { ?>
			<img src="<?php $image = wp_get_attachment_image_src( $image_icon, 'large'); echo esc_url( $image[0] );?>" alt="<?php esc_attr_e( 'Image', 'charitab-wp' ); ?>">
			<?php } else { ?>
			<i class="<?php echo esc_attr( ${$icon_pack} );?>"></i>
			<?php } ?>
		</div>
		<div class="stats-info">
			<<?php echo esc_attr( $stat_tag );?> class="stats-info">
			<?php echo do_shortcode( '[charitable_stat display="'. $display .'" campaigns="'. $campaigns .'" goal="'. $goal .'"]' ); ?>
			</<?php echo esc_attr( $stat_tag );?>>
		</div>
		<div class="stats-text">
			<?php echo wp_kses_post( $stat_bottomline_text );?>
		</div>
	</div>
</div>