<?php

if(!function_exists('mascot_core_charitab_sc_button_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_button_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}




if(!function_exists('mascot_core_charitab_sc_button_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_button_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'link_url' => '#',
			'button_text' => esc_html__( 'Read More', 'charitab-wp' ),

			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',

			'add_icon' => false,
			'button_icon_left' => '',
			'button_icon_right' => '',

			'css_animation' => '',
		);

		$params = shortcode_atts($args, $attr);
		
		//link url
		$params['button'] = vc_build_link( $params['link_url'] );
		if( empty( $params['button']['title']  ) ) {
			$params['button']['title'] = esc_html__( 'Read More', 'charitab-wp' );
		}

		//classes
		$classes = array();

		if( $params['button_alignment'] ) {
			$classes[] = $params['button_alignment'];
		}

		//css animation
		VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Btn' );
		$vc_btn = new WPBakeryShortCode_VC_Btn( array( 'base' => 'vc_btn' ) );
		$classes[] = $vc_btn->getCSSAnimation( $params['css_animation'] );

		$classes[] = $params['custom_css_class'];
		$params['classes'] = $classes;

		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'button', null, 'button/tpl', $params, true );
		
		return $html;
	}
}