<?php

if (!function_exists('charitab_mascot_shortcode_get_blog_post_format')) {
	/**
	 * Return Shortcode Blog Post Format HTML
	 */
	function charitab_mascot_shortcode_get_blog_post_format( $post_format = '', $params = array() ) {

		$format = $post_format ? : 'standard';
		$params['post_format'] = $format;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_shortcode_template_part( 'post-format', $format, 'blog/tpl/post-format', $params, true );
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_post_shortcode_meta' ) ) {
	/**
	 * Print HTML with meta information for the current post-date/time and author.
	 *
	 */
	function charitab_mascot_post_shortcode_meta( $post_meta_options = array(), $exclude = array() ) {
		$post_meta_options = explode(',', $post_meta_options);
		if ( ! empty($exclude) ) {
			$post_meta_options = array_diff($post_meta_options, $exclude);
		}
	?>
	<ul class="entry-meta list-inline">
	<?php
		if ( in_array( "show-post-by-author", $post_meta_options ) ) {
	?>
			<li class="list-inline-item author"><i class="fa fa-user-o"></i> <?php charitab_mascot_posted_by();?></li>
	<?php
		} if ( in_array( "show-post-date", $post_meta_options ) ) {
	?>
			<li class="list-inline-item posted-date"><i class="fa fa-calendar-o"></i> <?php charitab_mascot_posted_on();?></li>
	<?php
		} if ( in_array( "show-post-category", $post_meta_options ) ) {
	?>
			<li class="list-inline-item categories"><i class="fa fa-folder-o"></i> <?php charitab_mascot_post_category();?></li>
	<?php
		} if ( in_array( "show-post-comments-count", $post_meta_options ) ) {
	?>
			<li class="list-inline-item comments"><i class="fa fa-commenting-o"></i> <?php charitab_mascot_get_comments_number(); ?></li>
	<?php
		} if ( in_array( "show-post-tag", $post_meta_options ) ) {
	?>
			<li class="list-inline-item tags"><i class="fa fa-tags"></i> <?php charitab_mascot_post_tag();?></li>
	<?php
		} if ( in_array( "show-post-like-button", $post_meta_options ) ) {
	?>
			<li class="list-inline-item likes"><?php echo charitab_mascot_sl_get_simple_likes_button( get_the_ID() ); ?></li>
	<?php
		}
	?>
	</ul>
	<?php
	}
}

if ( ! function_exists( 'charitab_mascot_post_shortcode_single_meta' ) ) {
	/**
	 * Return single post meta.
	 *
	 */
	function charitab_mascot_post_shortcode_single_meta( $post_meta = '' ) {
		if ( $post_meta == "show-post-by-author" ) {
	?>
			<i class="fa fa-user-o"></i> <?php charitab_mascot_posted_by();?>
	<?php
		} else if ( $post_meta == "show-post-date" ) {
	?>
			<i class="fa fa-calendar-o"></i> <?php charitab_mascot_posted_on();?>
	<?php
		} else if ( $post_meta == "show-post-category" ) {
	?>
			<i class="fa fa-folder-o"></i> <?php charitab_mascot_post_category();?>
	<?php
		} else if ( $post_meta == "show-post-comments-count" ) {
	?>
			<i class="fa fa-commenting-o"></i> <?php charitab_mascot_get_comments_number(); ?>
	<?php
		} else if ( $post_meta == "show-post-tag" ) {
	?>
			<i class="fa fa-tags"></i> <?php charitab_mascot_post_tag();?>
	<?php
		} else if ( $post_meta == "show-post-like-button" ) {
	?>
			<?php echo charitab_mascot_sl_get_simple_likes_button( get_the_ID() ); ?>
	<?php
		}
	}
}