<?php

use MascotCharitabNamespace\Framework\IconFonts\Lib;
use MascotCharitabNamespace\Framework\IconFonts\FontAwesome\Charitab_Mascot_Icons_Fontawesome;
use MascotCharitabNamespace\Framework\IconFonts\Elegant\Charitab_Mascot_Icons_Elegant;
use MascotCharitabNamespace\Framework\IconFonts\IcoMoon\Charitab_Mascot_Icons_IcoMoon;
use MascotCharitabNamespace\Framework\IconFonts\SevenStroke\Charitab_Mascot_Icons_SevenStroke;
use MascotCharitabNamespace\Framework\IconFonts\FlatIconSetCurrentTheme\Charitab_Mascot_Icons_FlatIconSetCurrentTheme;

/**
 * class RegIconFonts
 */
class RegIconFonts {
	/**
	 * @var Singleton The reference to *Singleton* instance of this class
	 */
	private static $instance;

	/**
	 * @var array
	 */
	private $allIconFontPacks = array();
	
	/**
	 * Returns the *Singleton* instance of this class.
	 *
	 * @return Singleton The *Singleton* instance.
	 */
	public static function getInstance()
	{
		if (null === static::$instance) {
			static::$instance = new static();
		}
		
		return static::$instance;
	}

	/**
	 * Protected constructor to prevent creating a new instance of the
	 * *Singleton* via the `new` operator from outside of this class.
	 */
	protected function __construct()
	{
		$this->allIconFontPacksToReg();
	}

	/**
	 * Private clone method to prevent cloning of the instance of the
	 * *Singleton* instance.
	 *
	 * @return void
	 */
	private function __clone()
	{
	}

	/**
	 * Private unserialize method to prevent unserializing of the *Singleton*
	 * instance.
	 *
	 * @return void
	 */
	private function __wakeup()
	{
	}

	/**
	 * Add each Icon Font Pack to array
	 */
	public function addIconFontPack($key, $name, $value) {
		$this->allIconFontPacks[$key]['name'] = $name;
		$this->allIconFontPacks[$key]['value'] = $value;
	}

	/**
	 * List of all Icon Font Packs to register
	 */
	private function allIconFontPacksToReg() {
		$this->addIconFontPack('font_awesome', 'FontAwesome',  new Charitab_Mascot_Icons_Fontawesome());
		
		if( charitab_mascot_get_redux_option( 'page-settings-use-elegant-icons' ) ) {
			$this->addIconFontPack('elegant', 'Elegant Icons', new Charitab_Mascot_Icons_Elegant());
		}

		if( charitab_mascot_get_redux_option( 'page-settings-use-icomoon' ) ) {
			$this->addIconFontPack('icomoon', 'IcoMoon', new Charitab_Mascot_Icons_IcoMoon());
		}

		if( charitab_mascot_get_redux_option( 'page-settings-use-pe-icon-7-stroke' ) ) {
			$this->addIconFontPack('seven_stroke', '7 Stroke Icons', new Charitab_Mascot_Icons_SevenStroke());
		}

		if( charitab_mascot_get_redux_option( 'page-settings-use-flaticon-current-theme' ) ) {
			$this->addIconFontPack('flaticon_set_current_theme', 'Flaticon Set Current Theme', new Charitab_Mascot_Icons_FlatIconSetCurrentTheme());
		}
	}

	/**
	 * Get Icon Font Pack by Key
	 */
	public function getIconFontPackByKey($key) {
		if(array_key_exists($key, $this->allIconFontPacks)) {
			return $this->allIconFontPacks[$key]['value'];
		}
		return false;
	}

	/**
	 * Get key of all Icon Font Packs 
	 */
	public function getIconFontPackKeys() {
		return array_keys($this->allIconFontPacks);
	}

	/**
	 * Get Icon Font Pack Names Array
	 */
	public function getIconFontPackNamesAarray() {
		$font_array = array();

		foreach($this->allIconFontPacks as $key => $icon_pack) {
			$font_array[$key] = $icon_pack['name'];
		}
		return $font_array;
	}
}

//create global variable $charitab_mascot_icon_font_packs
if ( ! function_exists( 'charitab_mascot_activate_theme_icon_packs' ) ) {
	function charitab_mascot_activate_theme_icon_packs() {
		global $charitab_mascot_icon_font_packs;
		$charitab_mascot_icon_font_packs = RegIconFonts::getInstance();
	}
	add_action('after_setup_theme', 'charitab_mascot_activate_theme_icon_packs');
}

if( !function_exists( 'charitab_mascot_icon_font_packs' ) ) {
	/**
	 * Returns instance of RegIconFonts class
	 */
	function charitab_mascot_icon_font_packs() {
		return RegIconFonts::getInstance();
	}
}