<?php


if(!function_exists('charitab_mascot_get_works')) {
	/**
	 * Function that Renders Service list HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_works( $container_type = 'container' ) {
		$params = array();

		$params['container_type'] = $container_type;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'works-parts', null, 'works/works/tpl', $params, false );
		
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_get_works_layout' ) ) {
	/**
	 * Returns Service Layout Type
	 *
	 */
	function charitab_mascot_get_works_layout() {
		$params = array();

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('works');

		$params['layout_mode'] = charitab_mascot_get_redux_option( 'cpt-settings-works-archive-layout-mode' );
		$params['items_per_row'] = charitab_mascot_get_redux_option( 'cpt-settings-works-archive-items-per-row' );

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'works-content', null, 'works/works/tpl/content', $params, false );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_works_info' ) ) {
	/**
	 * Returns Service Info
	 *
	 */
	function charitab_mascot_get_works_info() {
		$params = array();

		$cat_list = array();
		$taxonomy = 'works_category';
		$category = get_the_terms( get_the_ID(), $taxonomy );
		foreach ( $category as $cat){
			$cat_list[ $cat->slug ]['name'] = $cat->name;
			$cat_list[ $cat->slug ]['link'] = get_term_link($cat->slug, $taxonomy);
		}
		$params['cat_list'] = $cat_list;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'works-info', null, 'works/works/tpl/parts', $params, false );
		
		return $html;
	}
}


if(!function_exists('charitab_mascot_get_works_thumb')) {
	/**
	 * Returns Service Thumb
	 * @return HTML
	 */
	function charitab_mascot_get_works_thumb() {
		$params = array();

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'thumb', null, 'works/works/tpl/parts', $params, false );
		
		return $html;
	}
}