
				<div class="each-category">
					<div class="box-hover-effect">
						<?php 
						$thumb = rwmb_meta( 'featured_image', array( 'object_type' => 'term', 'limit' => 1, 'size' => $thumb_image_size ), $term->term_id );
						$thumb = reset( $thumb );
						if ( !_empty( $thumb ) ) { 
						?>
						<div class="effect-wrapper">
							<div class="thumb">
								<img src="<?php echo esc_url( $thumb['url'] );?>" alt="<?php esc_attr_e( 'Image', 'charitab-wp' ); ?>">
							</div>
							<div class="shadow-overlay"></div>
						</div>
						<div class="details">
							<?php if ( $show_title == 'true' ) : ?>
							<h4 class="title"><a href="<?php echo esc_url( get_term_link( $term ) );?>"><?php echo esc_html( $term->name );?></a></h4>
							<?php endif; ?>
							<?php if ( $show_excerpt == 'true' ) : ?>
							<div class="excerpt">
								<?php if ( empty($excerpt_length) ) { ?>
								<?php echo wp_kses_post( strip_shortcodes( $term->description ) )?>
								<?php } else { ?>
								<?php echo wp_kses_post( charitab_mascot_slice_excerpt_by_length( $term->description, $excerpt_length ) ); ?>
								<?php } ?>
							</div>
							<?php endif; ?>
							<div class="btn-view-details">
								<a href="<?php echo esc_url( get_term_link( $term ) );?>"
								class="<?php echo esc_attr(implode(' ', $btn_classes)); ?>">
									<?php echo esc_html( $view_details_button_text  ); ?>
								</a>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>