<?php

if(!function_exists('mascot_core_charitab_cpt_sc_works_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_cpt_sc_works_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_cpt_sc_works_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_cpt_sc_works_render( $attr, $content = null, $class_instance ) {
		$class_instance =  (array) $class_instance;
		$args = array(
			'custom_css_class' => '',
			'display_type' => '',
			'columns' => '4',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'selected_category' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'show_title' => 'true',
			'show_excerpt' => 'true',
			'excerpt_length'	=> '',
			'show_thumb' => 'true',
			'feature_thumb_image_size' => 'post-thumbnail',

			
			'show_view_details_button' => 'true',
			'view_details_button_text' => esc_html__( 'View Details', 'charitab-wp' ),


			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',


			//loadmore button options
			'loadmore_show_view_details_button' => 'false',
			'loadmore_view_details_button_text' => esc_html__( 'Load More', 'charitab-wp' ),
			'loadmore_button_loading_text' => esc_html__( 'Loading...', 'charitab-wp' ),
			'loadmore_btn_design_style' => 'default',
			'loadmore_button_size' => '',
			'loadmore_btn_outlined' => false,
			'loadmore_btn_round' => false,
			'loadmore_btn_flat' => false,
			'loadmore_btn_block' => false,
			'loadmore_btn_threed_effect' => false,
			'loadmore_button_alignment' => '',
			'loadmore_button_hover_animation_effect' => '',

			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',

			'css' => '',
		);
		$params = shortcode_atts($args, $attr);
		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('works');
		charitab_mascot_custom_loadmore_enque_script( 'works', $params, $class_instance );

		return mascot_core_charitab_cpt_sc_works_render_output( $class_instance, $params );
	}
}


if(!function_exists('mascot_core_charitab_cpt_sc_works_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_charitab_cpt_sc_works_render_output( $class_instance, $params ) {
		$new_cpt_class = $class_instance;
		$paged = isset($params['paged']) ? $params['paged'] : '';

		if( $params['display_type'] != 'masonry' ) {
			$params['use_masonry_tiles_featured_image_size'] = 'false';
		}
		
		//query args
		$args = array(
			'post_type' => $new_cpt_class['ptKey'],
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
			'paged' => $paged,
		);

		//if category selected
		if( ! empty( $params['selected_category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => $new_cpt_class['ptTaxKey'],
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['selected_category']),
				)
			);
		}

		//if order by works_name selected
		/*if( $params['order_by'] == 'works_name' ) {
			$args['meta_key'] = 'charitab_mascot_' . 'cpt_works_name'; //############## error
			$args['orderby']  = 'meta_value';
		}*/

		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && $params['from_loadmore_ajax_handler'] === true ) {
			return;
		}
		
		//classes
		$classes = array();
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;
		
		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );
		$params['loadmore_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'loadmore_' );
		
		//ptTaxKey
		$params['ptTaxKey'] = $new_cpt_class['ptTaxKey'];
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );

		$html = charitab_mascot_get_cpt_template_part( 'works', $params['display_type'], 'works/shortcodes/tpl', $params, true );
		
		return $html;
	}
}