<?php if ( $the_query->have_posts() ) : ?>
<?php
	wp_enqueue_script( 'jquery-datatables' );
	wp_enqueue_style( 'jquery-datatables' );
	$random_number = wp_rand( 1111, 9999 );
?>
<div class="tm-sc tm-sc-vacancies <?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="job-overview-table">
	  <table id="vacancies-data-table<?php echo esc_attr( $random_number );?>" class="table table-hover data-table">
		<thead> 
			<tr> 
				<th>Job Title</th> 
				<th>Location</th> 
				<th>Department</th> 
				<th>Start Date</th>
			</tr> 
		</thead>
		
		<!-- the loop -->
		<tbody>
		<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
			<tr>
				<td><a href="<?php the_permalink();?>"><?php the_title();?></a></td>
				<td><?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "vacancies_mb_settings", 'location' ) );?></td>
				<td><?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "vacancies_mb_settings", 'department' ) );?></td>
				<td><?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "vacancies_mb_settings", 'start_date' ) );?></td>
			</tr>
		<?php endwhile; ?>
		</tbody>
		<!-- end of the loop -->
	  </table>
	</div>
</div>
<?php wp_reset_postdata(); ?>

<?php else : ?>
  <?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>