<?php

use MASCOTCORECHARITAB\CPT\Resources\CPT_Resources;

if(!function_exists('charitab_mascot_get_resources')) {
	/**
	 * Function that Renders Resources list HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_resources( $container_type = 'container' ) {
		$params = array();

		$params['container_type'] = $container_type;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'resources-parts', null, 'resources/resources/tpl', $params, false );
		
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_get_resources_layout' ) ) {
	/**
	 * Returns Resources Layout Type
	 *
	 */
	function charitab_mascot_get_resources_layout() {
		$params = array();

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('resources');

		$params['layout_mode'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-layout-mode' );
		$params['items_per_row'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-items-per-row' );

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'resources-content', null, 'resources/resources/tpl/content', $params, false );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_resources_info' ) ) {
	/**
	 * Returns Resources Info
	 *
	 */
	function charitab_mascot_get_resources_info() {
		$params = array();

		$resources_cpt_class = CPT_Resources::Instance();
		$params['social_links'] = $resources_cpt_class->socialList();

		$params['show_featured_image'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-featured-image' );
		$params['img_size'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-featured-image-size', 'charitab_mascot_wide' );

		$params['show_title'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-title' );
		$params['title_tag'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-title-tag', 'h4' );

		$params['show_speciality'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-speciality' );
		$params['show_bio'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-bio' );
		$params['show_social'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-social' );
		$params['show_hours'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-working-hours' );
		$params['show_btn'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-btn' );
		$params['btn_text'] = charitab_mascot_get_redux_option( 'cpt-settings-resources-archive-show-btn-text' );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'resources-info', null, 'resources/resources/tpl/parts', $params, false );
		
		return $html;
	}
}