<?php
$gallery_layout_mode = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-portfolio-type-big-image-gallery-layout-mode' );
$items_per_row = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-portfolio-type-big-image-isotope-items-per-row' );
?>
<div class="portfolio-container">
	<div class="portfolio-images">
		<!-- portfolio Masonry -->
		<div class="isotope-layout grid-<?php echo esc_attr( $items_per_row ); ?> <?php echo esc_attr( $gallery_layout_mode ); ?> clearfix">
			<?php if( $gallery_layout_mode == 'masonry' ) { ?>
			<div class="isotope-item isotope-item-sizer"></div>
			<?php } ?>
			<?php
				$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				$full_image_url = $full_image_url[0];
			?>
			<div class="isotope-item box-hover-effect">
				<div class="effect-wrapper">
					<div class="thumb">
						<img src="<?php echo esc_url( $full_image_url );?>" alt="<?php the_title_attribute(); ?>">
					</div>
					<div class="overlay-shade"></div>
					<div class="icons-holder icons-holder-middle">
						<div class="icons-holder-inner">
							<div class="styled-icons icon-sm icon-dark">
								<a href="<?php echo esc_url( $full_image_url );?>" data-rel="prettyPhoto[portfolio-details-gallery-prettyphoto]" title="<?php the_title_attribute(); ?>"><i class="fa fa-picture-o"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php $gallery_images = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . "portfolio_mb_gallery_images_settings",  "gallery_images", null, false, 'all' ); ?>
			<?php
			if ( !empty( $gallery_images ) ) {
				foreach ( $gallery_images as $each_gallery_image ) {
				?>
				<div class="isotope-item box-hover-effect">
					<div class="effect-wrapper">
						<div class="thumb">
							<img src="<?php echo esc_url( $each_gallery_image['url'] );?>" alt="<?php the_title_attribute(); ?>">
						</div>
						<div class="overlay-shade"></div>
						<div class="icons-holder icons-holder-middle">
						<div class="icons-holder-inner">
							<div class="styled-icons icon-sm icon-dark">
								<a href="<?php echo esc_url( $each_gallery_image['url'] ) ?>" data-rel="prettyPhoto[portfolio-details-gallery-prettyphoto]" title="<?php the_title_attribute(); ?>"><i class="fa fa-picture-o"></i></a>
							</div>
						</div>
						</div>
					</div>
				</div>
				<?php
				}
			}
			?>
		</div>
	</div>
	<div class="portfolio-details">
	<?php charitab_mascot_get_portfolio_single_details( 'columns' ); ?>
	</div>
</div>