<?php if ( !empty( $gallery_single_id ) ) : ?>
	<div class="tm-sc tm-sc-gallery tm-sc-gallery-masonry <?php echo esc_attr(implode(' ', $classes)); ?>">

		<!-- Isotope Gallery Grid -->
		<div id="<?php echo esc_attr( $holder_id ) ?>" class="isotope-layout masonry grid-<?php echo esc_attr( $columns );?> <?php echo esc_attr( $gutter );?> clearfix lightgallery-lightbox">
			<div class="isotope-item isotope-item-sizer"></div>
			
			<?php if ( has_post_thumbnail( $gallery_single_id ) ) { ?>
			<!-- Isotope Item Post Thumb Start -->
			<div class="isotope-item">
				<div class="tm-gallery box-hover-effect">
					<div class="effect-wrapper">
						<div class="thumb <?php if( $show_gradient_effect_on_image == 'true' ) echo 'gradient-effect';?>">
							<?php echo get_the_post_thumbnail( $gallery_single_id, $thumb_image_size ); ?>
							<?php $full_image_url = get_the_post_thumbnail_url( $gallery_single_id, 'full' ); ?>
						</div>

						<div class="overlay-shade <?php echo esc_attr( $gallery_overlay_color_on_image );?>"></div>
						<div class="icons-holder icons-holder-middle">
							<div class="icons-holder-inner">
								<div class="<?php echo esc_attr( apply_filters( 'charitab_mascot_sc_gallery_social_info', 'styled-icons icon-dark icon-circled icon-theme-colored1') ); ?>">
									<a class="lightgallery-trigger styled-icons-item" data-exthumbimage="<?php echo esc_url( $full_image_url );?>" data-src="<?php echo esc_url( $full_image_url );?>" title="<?php echo the_title_attribute (array( 'post'=>$gallery_single_id ) );?>" href="<?php echo esc_url( $full_image_url );?>"><i class="fa fa-picture-o"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Isotope Item End -->
			<?php } ?>


			<!-- the loop -->
			<?php if ( !empty( $gallery_images ) ) { foreach ( $gallery_images as $each_gallery_image ) { ?>
			<!-- Isotope Item Start -->
			<div class="isotope-item">
				<div class="tm-gallery box-hover-effect">
					<div class="effect-wrapper">
						<?php if ( $each_gallery_image['url'] ) { ?>
						<div class="thumb <?php if( $show_gradient_effect_on_image == 'true' ) echo 'gradient-effect';?>">
							<?php $file_info = pathinfo($each_gallery_image['url']); $gallery_thumb_url = $file_info['dirname'] . '/' .$each_gallery_image['sizes'][$thumb_image_size]['file']; ?>
							<img src="<?php echo esc_url( $gallery_thumb_url );?>" alt="<?php esc_attr_e( 'Image', 'charitab-wp' ); ?>">
						</div>
						<?php } ?>

						<div class="overlay-shade <?php echo esc_attr( $gallery_overlay_color_on_image );?>"></div>
						<div class="icons-holder icons-holder-middle">
							<div class="icons-holder-inner">
								<div class="<?php echo esc_attr( apply_filters( 'charitab_mascot_sc_gallery_social_info', 'styled-icons icon-dark icon-circled icon-theme-colored1') ); ?>">
									<a class="lightgallery-trigger styled-icons-item" data-exthumbimage="<?php echo esc_url( $each_gallery_image['full_url'] );?>" data-src="<?php echo esc_url( $each_gallery_image['full_url'] );?>" title="<?php echo the_title_attribute (array( 'post'=>$gallery_single_id ) );?>" href="<?php echo esc_url( $each_gallery_image['full_url'] );?>"><i class="fa fa-picture-o"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Isotope Item End -->
			<?php } } ?>
			<!-- end of the loop -->
		</div>
		<!-- End Isotope Gallery Grid -->
		<?php wp_reset_postdata(); ?>
	</div>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>