<?php

if(!function_exists('mascot_core_charitab_cpt_sc_gallery_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_cpt_sc_gallery_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_cpt_sc_gallery_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_cpt_sc_gallery_render( $attr, $content = null, $class_instance ) {
		$class_instance =  (array) $class_instance;
		$args = array(
			'custom_css_class' => '',
			'design_style' => 'staff-style1-simple',
			'display_type' => '',
			'columns' => '4',
			'use_masonry_tiles_featured_image_size' => 'true',
			'featured_image_size' => 'post-thumbnail',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'selected_category' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'gutter' => 'gutter',
			'gallery_hover_effect' => '',
			'gallery_overlay_color_on_image' => '',
			'show_gradient_effect_on_image' => 'false',
			'show_gallery_title' => 'true',
			'show_gallery_description'	=> 'false',
			'show_gallery_date' => 'false',
			'show_selected_category' => 'false',

			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',


			'lightbox_scroll_through' => 'scroll-gallery-images',
			'show_link_icon_on_hover' => 'false',


			//loadmore button options
			'loadmore_show_view_details_button' => 'false',
			'loadmore_view_details_button_text' => esc_html__( 'Load More', 'charitab-wp' ),
			'loadmore_button_loading_text' => esc_html__( 'Loading...', 'charitab-wp' ),
			'loadmore_btn_design_style' => 'default',
			'loadmore_button_size' => '',
			'loadmore_btn_outlined' => false,
			'loadmore_btn_round' => false,
			'loadmore_btn_flat' => false,
			'loadmore_btn_block' => false,
			'loadmore_btn_threed_effect' => false,
			'loadmore_button_alignment' => '',
			'loadmore_button_hover_animation_effect' => '',
		);
		$params = shortcode_atts($args, $attr);
		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('gallery');
		charitab_mascot_custom_loadmore_enque_script( 'gallery', $params, $class_instance );

		return mascot_core_charitab_cpt_sc_gallery_render_output( $class_instance, $params );
	}
}


if(!function_exists('mascot_core_charitab_cpt_sc_gallery_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_charitab_cpt_sc_gallery_render_output( $class_instance, $params ) {
		$new_cpt_class = $class_instance;
		$paged = isset($params['paged']) ? $params['paged'] : '';

		if( $params['display_type'] != 'masonry' ) {
			$params['use_masonry_tiles_featured_image_size'] = 'false';
		}
		
		//query args
		$args = array(
			'post_type' => $new_cpt_class['ptKey'],
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
			'paged' => $paged,
		);

		//if category selected
		if( ! empty( $params['selected_category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => $new_cpt_class['ptTaxKey'],
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['selected_category']),
				)
			);
		}

		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && $params['from_loadmore_ajax_handler'] === true ) {
			return;
		}
		
		//ptTaxKey
		$params['ptTaxKey'] = $new_cpt_class['ptTaxKey'];
		
		//classes
		$classes = array();
		$classes[] = $params['design_style'];
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$params['classes'] = $classes;

		
		$params['loadmore_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'loadmore_' );
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );

		//get image dimension
		//$params['image_dimension'] = charitab_mascot_get_image_dimensions( $params['gallery_image_orientation'], $params['gallery_image_aspect_ratio'] );

		charitab_mascot_wp_enqueue_script_lightgallery();
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_cpt_template_part( 'gallery', $params['display_type'], 'gallery/shortcodes/tpl', $params, true );
		
		return $html;
	}
}