<?php

if(!function_exists('mascot_core_charitab_cpt_sc_departments_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_cpt_sc_departments_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_cpt_sc_departments_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_cpt_sc_departments_render( $attr, $content = null, $class_instance ) {

		$new_cpt_class = $class_instance;
		$args = array(
			'custom_css_class' => '',
			'display_type' => '',
			'columns' => '4',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'selected_category' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'show_department_title' => 'true',
			'show_department_icon' => 'true',
			'show_department_thumb' => 'true',
			'feature_thumb_image_size' => 'post-thumbnail',
			'show_department_description'	=> 'true',
			'show_department_read_more_button' => 'true',

			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',
		);
		$params = shortcode_atts($args, $attr);

		//query args
		$args = array(
			'post_type' => $new_cpt_class->ptKey,
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
		);

		//if category selected
		if( ! empty( $params['selected_category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => $new_cpt_class->ptTaxKey,
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['selected_category']),
				)
			);
		}

		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;

		//classes
		$classes = array();
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$params['classes'] = $classes;

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('departments');
		
		//ptTaxKey
		$params['ptTaxKey'] = $new_cpt_class->ptTaxKey;
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_cpt_template_part( 'departments', $params['display_type'], 'departments/shortcodes/tpl', $params, true );
		
		return $html;
	}
}