<?php
$current_page_id = charitab_mascot_get_page_id();
?>

<?php charitab_mascot_get_cpt_template_part( 'list-departments', null, 'departments/departments-details/tpl/parts', $params, false );?>


<ul class="list-group">
  <li class="list-group-item active">
	<h4 class="list-group-item-heading list-group-item-title"><?php esc_html_e( 'Contacts', 'charitab-wp' ) ?></h4>
  </li>

  <?php if ( !_empty( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_address', $current_page_id ) ) ) { ?>
  <li class="list-group-item">
	<h5 class="list-group-item-heading"><?php esc_html_e( 'Address', 'charitab-wp' ) ?></h5>
	<p class="list-group-item-text"><?php echo esc_html( $department_address = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_address', $current_page_id ) ) ?></p>
	
	<a class="<?php echo esc_attr( apply_filters( 'charitab_mascot_departments_sidebar_gmap_direction_btn', 'btn btn-theme-colored1 btn-sm mt-10') ); ?>" target="_blank" href="<?php echo esc_url( $department_address = "//www.google.com/maps/place/" . str_replace(' ', '+', $department_address) ); ?>"><?php esc_html_e( 'Get Direction', 'charitab-wp' ) ?> <i class="fa fa-arrow-circle-right"></i></a>
  </li>
  <?php } ?>

  <?php if ( !_empty( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_phone', $current_page_id ) ) ) { ?>
  <li class="list-group-item">
	<h5 class="list-group-item-heading"><?php esc_html_e( 'Phone', 'charitab-wp' ) ?></h5>
	<p class="list-group-item-text"><i class="fa fa-phone"></i> <?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_phone', $current_page_id ) ) ?></p>
  </li>
  <?php } ?>

  <?php if ( !_empty( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_fax', $current_page_id ) ) ) { ?>
  <li class="list-group-item">
	<h5 class="list-group-item-heading">Fax</h5>
	<p class="list-group-item-text"><i class="fa fa-fax"></i> <?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_fax', $current_page_id ) ) ?></p>
  </li>
  <?php } ?>

  <?php if ( !_empty( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_email', $current_page_id ) ) ) { ?>
  <li class="list-group-item">
	<h5 class="list-group-item-heading"><?php esc_html_e( 'Email', 'charitab-wp' ) ?></h5>
	<p class="list-group-item-text"><i class="fa fa-envelope-o"></i> <?php echo esc_html( charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_general_info", 'department_email', $current_page_id ) ) ?></p>
  </li>
  <?php } ?>
</ul>

<?php
//working hours
$working_hours_array = array();
for ($i=1; $i <= 7 ; $i++) { 
  $day = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_opening_hours", 'department_opening_hours_day_'.$i );
  $day_time = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "departments_mb_opening_hours", 'department_opening_hours_day_'.$i.'_time' );
  if( !empty( $day ) ) :
	$working_hours_array[$day] = $day_time;
  endif;
}
if( !empty( $working_hours_array ) ) :
?>
<ul class="list-group">
  <li class="list-group-item active">
	<h4 class="list-group-item-heading list-group-item-title"><?php esc_html_e( 'Working Hours', 'charitab-wp' ) ?></h4>
  </li>
  <li class="list-group-item">
	<div class="list-group-item-text">
  		<ul class="opening-hours">
  			<?php 
			foreach( $working_hours_array as $day => $day_time ) {
  			?>
					<li class="clearfix">
						<span><?php echo esc_html( $day ); ?></span>
						<div class="value"><?php echo esc_html( $day_time ); ?></div>
					</li>
  			<?php 
  				}
  			?>
			</ul>
	</div>
  </li>
</ul>
<?php
endif;
?>