<?php

if(!function_exists('charitab_mascot_random_word')) {
	/**
	 * Return Random Word
	 */
	function charitab_mascot_random_word( $len = 5 ) {
		$word = array_merge( range( 'a', 'z' ), range( 'A', 'Z' ));
		shuffle( $word );
		return substr( implode( $word ), 0, $len );
	}
}

if(!function_exists('charitab_mascot_number_of_theme_colors')) {
	/**
	 * Number of Theme Colors Used in this theme
	 */
	function charitab_mascot_number_of_theme_colors() {
		return 2;
	}
}

if(!function_exists('charitab_mascot_theme_color_list_vc')) {
	/**
	 * Theme Color list for VC
	 */
	function charitab_mascot_theme_color_list_vc() {
		$theme_color_list = array(
			esc_html__( 'No', 'charitab-wp' )	=>  '',
			esc_html__( 'Theme Color 1', 'charitab-wp' )	=>  '1',
			esc_html__( 'Theme Color 2', 'charitab-wp' )	=>  '2',
		);
		return $theme_color_list;
	}
}

if(!function_exists('charitab_mascot_theme_color_list')) {
	/**
	 * Theme Color list
	 */
	function charitab_mascot_theme_color_list() {
		$theme_color_list = array(
			'' => esc_html__( 'No', 'charitab-wp' ),
			'1' => esc_html__( 'Theme Color 1', 'charitab-wp' ),
			'2' => esc_html__( 'Theme Color 2', 'charitab-wp' )
		);
		return $theme_color_list;
	}
}

if(!function_exists('charitab_mascot_animate_css_animation_list')) {
	/**
	 * animate.css animation list https://daneden.github.io/animate.css/
	 */
	function charitab_mascot_animate_css_animation_list() {
		$animate_css_animation_list = array(
			'' => '',
			'fadeIn' => 'fadeIn',
			'fadeInDown' => 'fadeInDown',
			'fadeInDownBig' => 'fadeInDownBig',
			'fadeInLeft' => 'fadeInLeft',
			'fadeInLeftBig' => 'fadeInLeftBig',
			'fadeInRight' => 'fadeInRight',
			'fadeInRightBig' => 'fadeInRightBig',
			'fadeInUp' => 'fadeInUp',
			'fadeInUpBig' => 'fadeInUpBig',
			'fadeOut' => 'fadeOut',
			'fadeOutDown' => 'fadeOutDown',
			'fadeOutDownBig' => 'fadeOutDownBig',
			'fadeOutLeft' => 'fadeOutLeft',
			'fadeOutLeftBig' => 'fadeOutLeftBig',
			'fadeOutRight' => 'fadeOutRight',
			'fadeOutRightBig' => 'fadeOutRightBig',
			'fadeOutUp' => 'fadeOutUp',
			'fadeOutUpBig' => 'fadeOutUpBig',
			'bounce' => 'bounce',
			'flash' => 'flash',
			'pulse' => 'pulse',
			'rubberBand' => 'rubberBand',
			'shake' => 'shake',
			'swing' => 'swing',
			'tada' => 'tada',
			'wobble' => 'wobble',
			'jello' => 'jello',
			'bounceIn' => 'bounceIn',
			'bounceInDown' => 'bounceInDown',
			'bounceInLeft' => 'bounceInLeft',
			'bounceInRight' => 'bounceInRight',
			'bounceInUp' => 'bounceInUp',
			'bounceOut' => 'bounceOut',
			'bounceOutDown' => 'bounceOutDown',
			'bounceOutLeft' => 'bounceOutLeft',
			'bounceOutRight' => 'bounceOutRight',
			'bounceOutUp' => 'bounceOutUp',
			'flip' => 'flip',
			'flipInX' => 'flipInX',
			'flipInY' => 'flipInY',
			'flipOutX' => 'flipOutX',
			'flipOutY' => 'flipOutY',
			'lightSpeedIn' => 'lightSpeedIn',
			'lightSpeedOut' => 'lightSpeedOut',
			'rotateIn' => 'rotateIn',
			'rotateInDownLeft' => 'rotateInDownLeft',
			'rotateInDownRight' => 'rotateInDownRight',
			'rotateInUpLeft' => 'rotateInUpLeft',
			'rotateInUpRight' => 'rotateInUpRight',
			'rotateOut' => 'rotateOut',
			'rotateOutDownLeft' => 'rotateOutDownLeft',
			'rotateOutDownRight' => 'rotateOutDownRight',
			'rotateOutUpLeft' => 'rotateOutUpLeft',
			'rotateOutUpRight' => 'rotateOutUpRight',
			'slideInUp' => 'slideInUp',
			'slideInDown' => 'slideInDown',
			'slideInLeft' => 'slideInLeft',
			'slideInRight' => 'slideInRight',
			'slideOutUp' => 'slideOutUp',
			'slideOutDown' => 'slideOutDown',
			'slideOutLeft' => 'slideOutLeft',
			'slideOutRight' => 'slideOutRight',
			'zoomIn' => 'zoomIn',
			'zoomInDown' => 'zoomInDown',
			'zoomInLeft' => 'zoomInLeft',
			'zoomInRight' => 'zoomInRight',
			'zoomInUp' => 'zoomInUp',
			'zoomOut' => 'zoomOut',
			'zoomOutDown' => 'zoomOutDown',
			'zoomOutLeft' => 'zoomOutLeft',
			'zoomOutRight' => 'zoomOutRight',
			'zoomOutUp' => 'zoomOutUp',
			'hinge' => 'hinge',
			'rollIn' => 'rollIn',
			'rollOut' => 'rollOut'
		);
		return $animate_css_animation_list;
	}
}

if(!function_exists('charitab_mascot_jquery_easings_list')) {
	/**
	 * easings list http://api.jqueryui.com/easings/
	 */
	function charitab_mascot_jquery_easings_list() {
		$jquery_easings_list = array(
			'linear' => 'linear',
			'swing' => 'swing',
			'_default' => '_default',
			'easeInQuad' => 'easeInQuad',
			'easeOutQuad' => 'easeOutQuad',
			'easeInOutQuad' => 'easeInOutQuad',
			'easeInCubic' => 'easeInCubic',
			'easeOutCubic' => 'easeOutCubic',
			'easeInOutCubic' => 'easeInOutCubic',
			'easeInQuart' => 'easeInQuart',
			'easeOutQuart' => 'easeOutQuart',
			'easeInOutQuart' => 'easeInOutQuart',
			'easeInQuint' => 'easeInQuint',
			'easeOutQuint' => 'easeOutQuint',
			'easeInOutQuint' => 'easeInOutQuint',
			'easeInExpo' => 'easeInExpo',
			'easeOutExpo' => 'easeOutExpo',
			'easeInOutExpo' => 'easeInOutExpo',
			'easeInSine' => 'easeInSine',
			'easeOutSine' => 'easeOutSine',
			'easeInOutSine' => 'easeInOutSine',
			'easeInCirc' => 'easeInCirc',
			'easeOutCirc' => 'easeOutCirc',
			'easeInOutCirc' => 'easeInOutCirc',
			'easeInElastic' => 'easeInElastic',
			'easeOutElastic' => 'easeOutElastic',
			'easeInOutElastic' => 'easeInOutElastic',
			'easeInBack' => 'easeInBack',
			'easeOutBack' => 'easeOutBack',
			'easeInOutBack' => 'easeInOutBack',
			'easeInBounce' => 'easeInBounce',
			'easeOutBounce' => 'easeOutBounce',
			'easeInOutBounce' => 'easeInOutBounce',
		);
		return $jquery_easings_list;
	}
}

if(!function_exists('charitab_mascot_wp_admin_dashicons_list')) {
	/**
	 * WordPress admin Dashicons https://developer.wordpress.org/resource/dashicons
	 */
	function charitab_mascot_wp_admin_dashicons_list() {
		$animate_css_animation_list = array(
			'' => '',
			'dashicons-mascot' => 'dashicons-mascot',
			'dashicons-admin-appearance' => 'dashicons-admin-appearance',
			'dashicons-admin-collapse' => 'dashicons-admin-collapse',
			'dashicons-admin-comments' => 'dashicons-admin-comments',
			'dashicons-admin-customizer' => 'dashicons-admin-customizer',
			'dashicons-admin-generic' => 'dashicons-admin-generic',
			'dashicons-admin-home' => 'dashicons-admin-home',
			'dashicons-admin-links' => 'dashicons-admin-links',
			'dashicons-admin-media' => 'dashicons-admin-media',
			'dashicons-admin-multisite' => 'dashicons-admin-multisite',
			'dashicons-admin-network' => 'dashicons-admin-network',
			'dashicons-admin-page' => 'dashicons-admin-page',
			'dashicons-admin-plugins' => 'dashicons-admin-plugins',
			'dashicons-admin-post' => 'dashicons-admin-post',
			'dashicons-admin-settings' => 'dashicons-admin-settings',
			'dashicons-admin-site' => 'dashicons-admin-site',
			'dashicons-admin-tools' => 'dashicons-admin-tools',
			'dashicons-admin-users' => 'dashicons-admin-users',
			'dashicons-album' => 'dashicons-album',
			'dashicons-align-center' => 'dashicons-align-center',
			'dashicons-align-full-width' => 'dashicons-align-full-width',
			'dashicons-align-left' => 'dashicons-align-left',
			'dashicons-align-none' => 'dashicons-align-none',
			'dashicons-align-right' => 'dashicons-align-right',
			'dashicons-align-wide' => 'dashicons-align-wide',
			'dashicons-analytics' => 'dashicons-analytics',
			'dashicons-archive' => 'dashicons-archive',
			'dashicons-arrow-down-alt' => 'dashicons-arrow-down-alt',
			'dashicons-arrow-down-alt2' => 'dashicons-arrow-down-alt2',
			'dashicons-arrow-down' => 'dashicons-arrow-down',
			'dashicons-arrow-left-alt' => 'dashicons-arrow-left-alt',
			'dashicons-arrow-left-alt2' => 'dashicons-arrow-left-alt2',
			'dashicons-arrow-left' => 'dashicons-arrow-left',
			'dashicons-arrow-right-alt' => 'dashicons-arrow-right-alt',
			'dashicons-arrow-right-alt2' => 'dashicons-arrow-right-alt2',
			'dashicons-arrow-right' => 'dashicons-arrow-right',
			'dashicons-arrow-up-alt' => 'dashicons-arrow-up-alt',
			'dashicons-arrow-up-alt2' => 'dashicons-arrow-up-alt2',
			'dashicons-arrow-up' => 'dashicons-arrow-up',
			'dashicons-art' => 'dashicons-art',
			'dashicons-awards' => 'dashicons-awards',
			'dashicons-backup' => 'dashicons-backup',
			'dashicons-book-alt' => 'dashicons-book-alt',
			'dashicons-book' => 'dashicons-book',
			'dashicons-building' => 'dashicons-building',
			'dashicons-businessman' => 'dashicons-businessman',
			'dashicons-button' => 'dashicons-button',
			'dashicons-calendar-alt' => 'dashicons-calendar-alt',
			'dashicons-calendar' => 'dashicons-calendar',
			'dashicons-camera' => 'dashicons-camera',
			'dashicons-carrot' => 'dashicons-carrot',
			'dashicons-cart' => 'dashicons-cart',
			'dashicons-category' => 'dashicons-category',
			'dashicons-chart-area' => 'dashicons-chart-area',
			'dashicons-chart-bar' => 'dashicons-chart-bar',
			'dashicons-chart-line' => 'dashicons-chart-line',
			'dashicons-chart-pie' => 'dashicons-chart-pie',
			'dashicons-clipboard' => 'dashicons-clipboard',
			'dashicons-clock' => 'dashicons-clock',
			'dashicons-cloud' => 'dashicons-cloud',
			'dashicons-controls-back' => 'dashicons-controls-back',
			'dashicons-controls-forward' => 'dashicons-controls-forward',
			'dashicons-controls-pause' => 'dashicons-controls-pause',
			'dashicons-controls-play' => 'dashicons-controls-play',
			'dashicons-controls-repeat' => 'dashicons-controls-repeat',
			'dashicons-controls-skipback' => 'dashicons-controls-skipback',
			'dashicons-controls-skipforward' => 'dashicons-controls-skipforward',
			'dashicons-controls-volumeoff' => 'dashicons-controls-volumeoff',
			'dashicons-controls-volumeon' => 'dashicons-controls-volumeon',
			'dashicons-dashboard' => 'dashicons-dashboard',
			'dashicons-desktop' => 'dashicons-desktop',
			'dashicons-dismiss' => 'dashicons-dismiss',
			'dashicons-download' => 'dashicons-download',
			'dashicons-edit' => 'dashicons-edit',
			'dashicons-editor-aligncenter' => 'dashicons-editor-aligncenter',
			'dashicons-editor-alignleft' => 'dashicons-editor-alignleft',
			'dashicons-editor-alignright' => 'dashicons-editor-alignright',
			'dashicons-editor-bold' => 'dashicons-editor-bold',
			'dashicons-editor-break' => 'dashicons-editor-break',
			'dashicons-editor-code' => 'dashicons-editor-code',
			'dashicons-editor-contract' => 'dashicons-editor-contract',
			'dashicons-editor-customchar' => 'dashicons-editor-customchar',
			'dashicons-editor-expand' => 'dashicons-editor-expand',
			'dashicons-editor-help' => 'dashicons-editor-help',
			'dashicons-editor-indent' => 'dashicons-editor-indent',
			'dashicons-editor-insertmore' => 'dashicons-editor-insertmore',
			'dashicons-editor-italic' => 'dashicons-editor-italic',
			'dashicons-editor-justify' => 'dashicons-editor-justify',
			'dashicons-editor-kitchensink' => 'dashicons-editor-kitchensink',
			'dashicons-editor-ol' => 'dashicons-editor-ol',
			'dashicons-editor-outdent' => 'dashicons-editor-outdent',
			'dashicons-editor-paragraph' => 'dashicons-editor-paragraph',
			'dashicons-editor-paste-text' => 'dashicons-editor-paste-text',
			'dashicons-editor-paste-word' => 'dashicons-editor-paste-word',
			'dashicons-editor-quote' => 'dashicons-editor-quote',
			'dashicons-editor-removeformatting' => 'dashicons-editor-removeformatting',
			'dashicons-editor-rtl' => 'dashicons-editor-rtl',
			'dashicons-editor-spellcheck' => 'dashicons-editor-spellcheck',
			'dashicons-editor-strikethrough' => 'dashicons-editor-strikethrough',
			'dashicons-editor-table' => 'dashicons-editor-table',
			'dashicons-editor-textcolor' => 'dashicons-editor-textcolor',
			'dashicons-editor-ul' => 'dashicons-editor-ul',
			'dashicons-editor-underline' => 'dashicons-editor-underline',
			'dashicons-editor-unlink' => 'dashicons-editor-unlink',
			'dashicons-editor-video' => 'dashicons-editor-video',
			'dashicons-ellipsis' => 'dashicons-ellipsis',
			'dashicons-email-alt' => 'dashicons-email-alt',
			'dashicons-email-alt2' => 'dashicons-email-alt2',
			'dashicons-email' => 'dashicons-email',
			'dashicons-exerpt-view' => 'dashicons-exerpt-view',
			'dashicons-external' => 'dashicons-external',
			'dashicons-facebook-alt' => 'dashicons-facebook-alt',
			'dashicons-facebook' => 'dashicons-facebook',
			'dashicons-feedback' => 'dashicons-feedback',
			'dashicons-filter' => 'dashicons-filter',
			'dashicons-flag' => 'dashicons-flag',
			'dashicons-format-aside' => 'dashicons-format-aside',
			'dashicons-format-audio' => 'dashicons-format-audio',
			'dashicons-format-chat' => 'dashicons-format-chat',
			'dashicons-format-gallery' => 'dashicons-format-gallery',
			'dashicons-format-image' => 'dashicons-format-image',
			'dashicons-format-quote' => 'dashicons-format-quote',
			'dashicons-format-status' => 'dashicons-format-status',
			'dashicons-format-video' => 'dashicons-format-video',
			'dashicons-forms' => 'dashicons-forms',
			'dashicons-googleplus' => 'dashicons-googleplus',
			'dashicons-grid-view' => 'dashicons-grid-view',
			'dashicons-groups' => 'dashicons-groups',
			'dashicons-hammer' => 'dashicons-hammer',
			'dashicons-heading' => 'dashicons-heading',
			'dashicons-heart' => 'dashicons-heart',
			'dashicons-hidden' => 'dashicons-hidden',
			'dashicons-id-alt' => 'dashicons-id-alt',
			'dashicons-id' => 'dashicons-id',
			'dashicons-image-crop' => 'dashicons-image-crop',
			'dashicons-image-filter' => 'dashicons-image-filter',
			'dashicons-image-flip-horizontal' => 'dashicons-image-flip-horizontal',
			'dashicons-image-flip-vertical' => 'dashicons-image-flip-vertical',
			'dashicons-image-rotate-left' => 'dashicons-image-rotate-left',
			'dashicons-image-rotate-right' => 'dashicons-image-rotate-right',
			'dashicons-image-rotate' => 'dashicons-image-rotate',
			'dashicons-images-alt' => 'dashicons-images-alt',
			'dashicons-images-alt2' => 'dashicons-images-alt2',
			'dashicons-index-card' => 'dashicons-index-card',
			'dashicons-info' => 'dashicons-info',
			'dashicons-insert' => 'dashicons-insert',
			'dashicons-laptop' => 'dashicons-laptop',
			'dashicons-layout' => 'dashicons-layout',
			'dashicons-leftright' => 'dashicons-leftright',
			'dashicons-lightbulb' => 'dashicons-lightbulb',
			'dashicons-list-view' => 'dashicons-list-view',
			'dashicons-location-alt' => 'dashicons-location-alt',
			'dashicons-location' => 'dashicons-location',
			'dashicons-lock' => 'dashicons-lock',
			'dashicons-marker' => 'dashicons-marker',
			'dashicons-media-archive' => 'dashicons-media-archive',
			'dashicons-media-audio' => 'dashicons-media-audio',
			'dashicons-media-code' => 'dashicons-media-code',
			'dashicons-media-default' => 'dashicons-media-default',
			'dashicons-media-document' => 'dashicons-media-document',
			'dashicons-media-interactive' => 'dashicons-media-interactive',
			'dashicons-media-spreadsheet' => 'dashicons-media-spreadsheet',
			'dashicons-media-text' => 'dashicons-media-text',
			'dashicons-media-video' => 'dashicons-media-video',
			'dashicons-megaphone' => 'dashicons-megaphone',
			'dashicons-menu-alt' => 'dashicons-menu-alt',
			'dashicons-menu' => 'dashicons-menu',
			'dashicons-microphone' => 'dashicons-microphone',
			'dashicons-migrate' => 'dashicons-migrate',
			'dashicons-minus' => 'dashicons-minus',
			'dashicons-money' => 'dashicons-money',
			'dashicons-move' => 'dashicons-move',
			'dashicons-nametag' => 'dashicons-nametag',
			'dashicons-networking' => 'dashicons-networking',
			'dashicons-no-alt' => 'dashicons-no-alt',
			'dashicons-no' => 'dashicons-no',
			'dashicons-palmtree' => 'dashicons-palmtree',
			'dashicons-paperclip' => 'dashicons-paperclip',
			'dashicons-performance' => 'dashicons-performance',
			'dashicons-phone' => 'dashicons-phone',
			'dashicons-playlist-audio' => 'dashicons-playlist-audio',
			'dashicons-playlist-video' => 'dashicons-playlist-video',
			'dashicons-plus-alt' => 'dashicons-plus-alt',
			'dashicons-plus-light' => 'dashicons-plus-light',
			'dashicons-plus' => 'dashicons-plus',
			'dashicons-portfolio' => 'dashicons-portfolio',
			'dashicons-post-status' => 'dashicons-post-status',
			'dashicons-pressthis' => 'dashicons-pressthis',
			'dashicons-products' => 'dashicons-products',
			'dashicons-randomize' => 'dashicons-randomize',
			'dashicons-redo' => 'dashicons-redo',
			'dashicons-rss' => 'dashicons-rss',
			'dashicons-saved' => 'dashicons-saved',
			'dashicons-schedule' => 'dashicons-schedule',
			'dashicons-screenoptions' => 'dashicons-screenoptions',
			'dashicons-search' => 'dashicons-search',
			'dashicons-share-alt' => 'dashicons-share-alt',
			'dashicons-share-alt2' => 'dashicons-share-alt2',
			'dashicons-share' => 'dashicons-share',
			'dashicons-shield-alt' => 'dashicons-shield-alt',
			'dashicons-shield' => 'dashicons-shield',
			'dashicons-slides' => 'dashicons-slides',
			'dashicons-smartphone' => 'dashicons-smartphone',
			'dashicons-smiley' => 'dashicons-smiley',
			'dashicons-sort' => 'dashicons-sort',
			'dashicons-sos' => 'dashicons-sos',
			'dashicons-star-empty' => 'dashicons-star-empty',
			'dashicons-star-filled' => 'dashicons-star-filled',
			'dashicons-star-half' => 'dashicons-star-half',
			'dashicons-sticky' => 'dashicons-sticky',
			'dashicons-store' => 'dashicons-store',
			'dashicons-tablet' => 'dashicons-tablet',
			'dashicons-tag' => 'dashicons-tag',
			'dashicons-tagcloud' => 'dashicons-tagcloud',
			'dashicons-testimonial' => 'dashicons-testimonial',
			'dashicons-text' => 'dashicons-text',
			'dashicons-thumbs-down' => 'dashicons-thumbs-down',
			'dashicons-thumbs-up' => 'dashicons-thumbs-up',
			'dashicons-tickets-alt' => 'dashicons-tickets-alt',
			'dashicons-tickets' => 'dashicons-tickets',
			'dashicons-translation' => 'dashicons-translation',
			'dashicons-trash' => 'dashicons-trash',
			'dashicons-twitter' => 'dashicons-twitter',
			'dashicons-undo' => 'dashicons-undo',
			'dashicons-universal-access-alt' => 'dashicons-universal-access-alt',
			'dashicons-universal-access' => 'dashicons-universal-access',
			'dashicons-unlock' => 'dashicons-unlock',
			'dashicons-update' => 'dashicons-update',
			'dashicons-upload' => 'dashicons-upload',
			'dashicons-vault' => 'dashicons-vault',
			'dashicons-video-alt' => 'dashicons-video-alt',
			'dashicons-video-alt2' => 'dashicons-video-alt2',
			'dashicons-video-alt3' => 'dashicons-video-alt3',
			'dashicons-visibility' => 'dashicons-visibility',
			'dashicons-warning' => 'dashicons-warning',
			'dashicons-welcome-add-page' => 'dashicons-welcome-add-page',
			'dashicons-welcome-comments' => 'dashicons-welcome-comments',
			'dashicons-welcome-learn-more' => 'dashicons-welcome-learn-more',
			'dashicons-welcome-view-site' => 'dashicons-welcome-view-site',
			'dashicons-welcome-widgets-menus' => 'dashicons-welcome-widgets-menus',
			'dashicons-welcome-write-blog' => 'dashicons-welcome-write-blog',
			'dashicons-wordpress-alt' => 'dashicons-wordpress-alt',
			'dashicons-wordpress' => 'dashicons-wordpress',
			'dashicons-yes' => 'dashicons-yes'
		);
		return $animate_css_animation_list;
	}
}

if(!function_exists('charitab_mascot_orderby_parameters_list')) {
	/**
	 * Orderby Parameters list
	 */
	function charitab_mascot_orderby_parameters_list() {
		$orderby_parameters_list = array(
			esc_html__( 'Date', 'charitab-wp' ) 				=> 'date',
			esc_html__( 'Post Name', 'charitab-wp' ) 			=> 'name',
			esc_html__( 'Random Order', 'charitab-wp' ) 		=> 'rand',
			esc_html__( 'Last Modified Date', 'charitab-wp' ) 	=> 'modified',
			esc_html__( 'Author', 'charitab-wp' ) 				=> 'author',
			esc_html__( 'Title', 'charitab-wp' ) 				=> 'title',
			esc_html__( 'ID', 'charitab-wp' ) 					=> 'ID',
			esc_html__( 'Post/Page Parent ID', 'charitab-wp' ) 	=> 'parent',
			esc_html__( 'Number of Comments', 'charitab-wp' ) 	=> 'comment_count',
			esc_html__( 'Page Order', 'charitab-wp' ) 			=> 'menu_order'
		);
		return $orderby_parameters_list;
	}
}

if(!function_exists('charitab_mascot_list_hover_effects')) {
	/**
	 * Hover Effect list
	 */
	function charitab_mascot_list_hover_effects() {
		$hover_effects_list = array(
			esc_html__( 'Default', 'charitab-wp' )			=> '',
			esc_html__( 'Effect London', 'charitab-wp' )	=> 'effect-london',
			esc_html__( 'Effect Rome', 'charitab-wp' )		=> 'effect-rome',
			esc_html__( 'Effect Paris', 'charitab-wp' )		=> 'effect-paris',
			esc_html__( 'Effect Barlin', 'charitab-wp' )	=> 'effect-barlin'
		);
		return $hover_effects_list;
	}
}

if(!function_exists('charitab_mascot_portfolio_gutter_list')) {
	/**
	 * Portfolio Gutter list
	 */
	function charitab_mascot_portfolio_gutter_list() {
		$gutter_list = array(
			esc_html__( 'Default', 'charitab-wp' )  	=>  'gutter',
			'0'			=>  'gutter-0',
			'2px'  		=>  'gutter-2',
			'5px'  		=>  'gutter-5',
			'10px'  	=>  'gutter-10',
			'15px'  	=>  'gutter-15',
			'20px'  	=>  'gutter-20',
			'30px'  	=>  'gutter-30',
			'40px'  	=>  'gutter-40',
			'50px'  	=>  'gutter-50',
			'60px'  	=>  'gutter-60',
		);
		return $gutter_list;
	}
}

if(!function_exists('charitab_mascot_different_size_list')) {
	/**
	 * Size list
	 */
	function charitab_mascot_different_size_list() {
		$size_list = array(
			''  	=>  '',
			'xl'  	=>  'xl',
			'lg'  	=>  'lg',
			'md'  	=>  'md',
			'sm'  	=>  'sm',
			'xs'  	=>  'xs',
		);
		return $size_list;
	}
}

if(!function_exists('charitab_mascot_text_alignment_list')) {
	/**
	 * Text Alignment List
	 */
	function charitab_mascot_text_alignment_list() {
		$alignment_list = array(
			esc_html__( 'Left', 'charitab-wp' )		=> 'text-left',
			esc_html__( 'Center', 'charitab-wp' )	=> 'text-center',
			esc_html__( 'Right', 'charitab-wp' )	=> 'text-right'
		);
		return $alignment_list;
	}
}

if(!function_exists('charitab_mascot_redux_text_alignment_list')) {
	/**
	 * Text Alignment List - Redux
	 */
	function charitab_mascot_redux_text_alignment_list() {
		$alignment_list = array(
			'text-left'	 	=> esc_html__( 'Left', 'charitab-wp' ),
			'text-center'   => esc_html__( 'Center', 'charitab-wp' ),
			'text-right'	=> esc_html__( 'Right', 'charitab-wp' ),
		);
		return $alignment_list;
	}
}

if(!function_exists('charitab_mascot_redux_text_alignment_single_word_list')) {
	/**
	 * Text Alignment List Only Single Word- Redux
	 */
	function charitab_mascot_redux_text_alignment_single_word_list() {
		$alignment_list = array(
			'left'	 	=> esc_html__( 'Left', 'charitab-wp' ),
			'center'   => esc_html__( 'Center', 'charitab-wp' ),
			'right'	=> esc_html__( 'Right', 'charitab-wp' ),
		);
		return $alignment_list;
	}
}

if(!function_exists('charitab_mascot_heading_tag_list')) {
	/**
	 * Heading Tag List
	 */
	function charitab_mascot_heading_tag_list() {
		$heading_tag_list = array(
			''  	=>  '',
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
		);
		return $heading_tag_list;
	}
}

if(!function_exists('charitab_mascot_heading_tag_list_all')) {
	/**
	 * Heading Tag List
	 */
	function charitab_mascot_heading_tag_list_all() {
		$heading_tag_list_all = array(
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
		);
		return $heading_tag_list_all;
	}
}

if(!function_exists('charitab_mascot_open_link_in')) {
	/**
	 * Open Link In
	 */
	function charitab_mascot_open_link_in() {
		$open_link_in = array(
			esc_html__( 'New Window', 'charitab-wp' )   => '_blank',
			esc_html__( 'Same Window', 'charitab-wp' )  => '_self'
		);
		return $open_link_in;
	}
}

if(!function_exists('charitab_mascot_vc_font_style_list')) {
	/**
	 * Font Style List
	 */
	function charitab_mascot_vc_font_style_list() {
		$font_style_list = array(
			esc_html__( 'Normal', 'charitab-wp' )   => '',
			esc_html__( 'Italic', 'charitab-wp' )  	=> 'italic'
		);
		return $font_style_list;
	}
}

if(!function_exists('charitab_mascot_vc_font_weight_list')) {
	/**
	 * Font weight List
	 */
	function charitab_mascot_vc_font_weight_list() {
		$font_weight_list = array(
			esc_html__( 'Default', 'charitab-wp' )   => '',
			'100'   => '100',
			'200'   => '200',
			'300'   => '300',
			'400'   => '400',
			'500'   => '500',
			'600'   => '600',
			'700'   => '700',
			'800'   => '800',
		);
		return $font_weight_list;
	}
}

if(!function_exists('charitab_mascot_vc_text_transform_list')) {
	/**
	 * Text Transform List
	 */
	function charitab_mascot_vc_text_transform_list() {
		$text_transform_list = array(
			esc_html__( 'Default', 'charitab-wp' )   	=> '',
			esc_html__( 'None', 'charitab-wp' )  		=> 'none',
			esc_html__( 'Capitalize', 'charitab-wp' )  	=> 'capitalize',
			esc_html__( 'Uppercase', 'charitab-wp' )  	=> 'uppercase',
			esc_html__( 'Lowercase', 'charitab-wp' )  	=> 'lowercase',
			esc_html__( 'Initial', 'charitab-wp' )  	=> 'initial',
			esc_html__( 'Inherit', 'charitab-wp' )  	=> 'inherit'
		);
		return $text_transform_list;
	}
}

if(!function_exists('charitab_mascot_get_post_all_categories_array')) {
	/**
	 * Category List of Blog Posts as an Array
	 */
	function charitab_mascot_get_post_all_categories_array() {
		$categories = get_categories( array(
			'orderby' => 'name',
			'order'   => 'ASC'
		) );
		$cats = array();
		$cats[''] = 'All';
		foreach($categories as $cat){
			$cats[$cat->term_id] = $cat->name;
		}
		return $cats;
	}
}

if(!function_exists('charitab_mascot_get_page_list_array')) {
	/**
	 * Category List of Pages as an Array
	 */
	function charitab_mascot_get_page_list_array() {
		$all_pages = get_pages();
		$pages = array();
		foreach($all_pages as $each_page){
			$pages[$each_page->ID] = $each_page->post_title;
		}
		return $pages;
	}
}

if ( ! function_exists( 'charitab_mascot_metabox_get_list_of_predefined_theme_color_css_files' ) ) {
	/**
	 * Get list of Predefined Theme Color css files
	 */
	function charitab_mascot_metabox_get_list_of_predefined_theme_color_css_files() {
		$predefined_theme_colors = array();

		if( $handle = opendir( CHARITAB_MASCOT_TEMPLATE_DIR . '/assets/css/colors/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".."  && substr( $entry, 0, 6 ) === "theme-") {
					$predefined_theme_colors[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $predefined_theme_colors;
	}
}

if ( ! function_exists( 'charitab_mascot_metabox_get_list_of_premade_sitewise_css_files' ) ) {
	/**
	 * Get list of Premade Sitewise css files
	 */
	function charitab_mascot_metabox_get_list_of_premade_sitewise_css_files() {
		$premade_css_files = array();

		if( $handle = opendir( CHARITAB_MASCOT_TEMPLATE_DIR . '/assets/css/sites/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".."  && substr( $entry, 0, 5 ) === "main-") {
					$premade_css_files[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $premade_css_files;
	}
}


if ( ! function_exists( 'charitab_mascot_get_available_image_sizes' ) ) {
	/**
	 * Get information about available image sizes
	 */
	function charitab_mascot_get_available_image_sizes( $size = '' ) {
	
		global $_wp_additional_image_sizes;
	
		$sizes = array();
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
	
		// Create the full array with sizes and crop info
		foreach( $get_intermediate_image_sizes as $_size ) {
			if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large', 'full' ) ) ) {
				$sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
				$sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
				$sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );
				if ( $_size == 'large' ) {
					$sizes[ 'full' ] ['width'] = 0;
					$sizes[ 'full' ] ['height'] = 0;
					$sizes[ 'full' ] ['crop'] = false;
				}
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array( 
					'width' => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
					'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
				);
			}
		}
	
		// Get only 1 size if found
		if ( $size ) {
			if( isset( $sizes[ $size ] ) ) {
				return $sizes[ $size ];
			} else {
				return false;
			}
		}
		return $sizes;
	}
}


if ( ! function_exists( 'charitab_mascot_get_available_image_sizes_for_vc' ) ) {
	/**
	 * Get information about available image sizes for VC
	 */
	function charitab_mascot_get_available_image_sizes_for_vc() {
		$size = array();
		$available_image_sizes = charitab_mascot_get_available_image_sizes();
	
		// Create the full array with sizes and crop info
		foreach( $available_image_sizes as $key => $value ) {
			$sizes[ $key . ( ($value['crop'] == 1) ? ' - cropped' : '') . ' - (' .$value['width'] . 'x' . $value['height'] . ')' ] = $key;
		}
		return $sizes;
	}
}

if(!function_exists('charitab_mascot_get_btn_design_style')) {
	/**
	 * Return Design Style
	 */
	function charitab_mascot_get_btn_design_style() {
		$array = array(
			esc_html__( 'Button Primary', 'charitab-wp' )				=> 'btn-primary',
			esc_html__( 'Button Secondary', 'charitab-wp' )				=> 'btn-secondary',
			esc_html__( 'Button Success', 'charitab-wp' )				=> 'btn-success',
			esc_html__( 'Button Danger', 'charitab-wp' )					=> 'btn-danger',
			esc_html__( 'Button Warning', 'charitab-wp' )				=> 'btn-warning',
			esc_html__( 'Button Info', 'charitab-wp' )					=> 'btn-info',
			esc_html__( 'Button Light', 'charitab-wp' )					=> 'btn-light',
			esc_html__( 'Button Dark', 'charitab-wp' )					=> 'btn-dark',
			esc_html__( 'Button Gray', 'charitab-wp' )					=> 'btn-gray',
			esc_html__( 'Plain Text', 'charitab-wp' )					=> 'btn-plain-text',
			esc_html__( 'Plain Text + Arrow', 'charitab-wp' )			=> 'btn-plain-text-with-arrow'
		);

		$array_theme_color = array();
		for ($i=1; $i <= charitab_mascot_number_of_theme_colors(); $i++) { 
			$array_theme_color[ esc_html__( 'Button Theme Colored', 'charitab-wp' ) . ' ' . $i ] = 'btn-theme-colored' . $i;
		}

		$array = array_merge($array, $array_theme_color);
		return $array;
	}
}

if(!function_exists('charitab_mascot_get_button_size')) {
	/**
	 * Return Button Size
	 */
	function charitab_mascot_get_button_size() {
		$array = array(
			esc_html__( 'Default', 'charitab-wp' )		=> '',
			esc_html__( 'Large', 'charitab-wp' )			=> 'btn-lg',
			esc_html__( 'Small', 'charitab-wp' )			=> 'btn-sm',
			esc_html__( 'Extra Small', 'charitab-wp' )	=> 'btn-xs',
		);
		return $array;
	}
}


if ( ! function_exists( 'charitab_mascot_prepare_button_classes_from_params' ) ) {
	/**
	 * Return Button Classes Collecting From Params
	 */
	function charitab_mascot_prepare_button_classes_from_params( $params = array(), $prefix = '' ) {
		$btn_classes = array();

		$btn_classes[] = 'btn';
		if( filter_var( $params[$prefix . 'btn_outlined'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$oldstr = $params[$prefix . 'btn_design_style'];
			$newstr = substr_replace($oldstr, 'outline-', 4, 0);
			$btn_classes[] = $newstr;
			$btn_classes[] = 'btn-outline';
		} else if ( $params[$prefix . 'btn_design_style'] ) {
			$btn_classes[] = $params[$prefix . 'btn_design_style'];
		}

		if( $params[$prefix . 'button_size'] != "" ) {
			$btn_classes[] = $params[$prefix . 'button_size'];
		}
		if( filter_var( $params[$prefix . 'btn_round'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-round';
		}
		if( filter_var( $params[$prefix . 'btn_flat'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-flat';
		}
		if( filter_var( $params[$prefix . 'btn_block'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-block';
		}
		if( filter_var( $params[$prefix . 'btn_threed_effect'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-3d';
		}
		if( $params[$prefix . 'button_hover_animation_effect'] != "" ) {
			$btn_classes[] = $params[$prefix . 'button_hover_animation_effect'];
		}

		return $btn_classes;
	}
}


if ( ! function_exists( 'charitab_mascot_prepare_header_button_classes_from_params' ) ) {
	/**
	 * Return Header Button Classes Collecting From Params
	 */
	function charitab_mascot_prepare_header_button_classes_from_params( $params = array(), $prefix = '' ) {
		$btn_classes = array();

		$btn_classes[] = 'btn';
		if( $params[$prefix . 'custom_button_outlined'] ) {
			$oldstr = $params[$prefix . 'custom_button_design_style'];
			$newstr = substr_replace($oldstr, 'outline-', 4, 0);
			$btn_classes[] = $newstr;
			$btn_classes[] = 'btn-outline';
		} else if ( $params[$prefix . 'custom_button_design_style'] ) {
			$btn_classes[] = $params[$prefix . 'custom_button_design_style'];
		}
		if( $params[$prefix . 'custom_button_size'] ) {
			$btn_classes[] = $params[$prefix . 'custom_button_size'];
		}
		if( $params[$prefix . 'custom_button_flat'] ) {
			$btn_classes[] = 'btn-flat';
		}
		if( $params[$prefix . 'custom_button_round'] ) {
			$btn_classes[] = 'btn-round';
		}

		$btn_classes[] = 'custom-button';
		return $btn_classes;
	}
}


if ( ! function_exists( 'charitab_mascot_no_posts_match_criteria_text' ) ) {
	/**
	 * Return no posts matched your criteria text
	 */
	function charitab_mascot_no_posts_match_criteria_text() {
		return '<p>' . esc_html_e( 'Sorry, no posts matched your criteria.', 'charitab-wp' ) . '</p>';
	}
}


if ( ! function_exists( 'charitab_mascot_prepare_owlcarousel_data_from_params' ) ) {
	/**
	 * Return Owl Carousel Data Collecting From Params
	 */
	function charitab_mascot_prepare_owlcarousel_data_from_params( $params = array(), $prefix = '' ) {
		$owlcarousel_data = array();

		if( $params[$prefix . 'show_navigation'] == 'true' ) {
			$owlcarousel_data[] = 'data-nav="' . esc_attr( $params[$prefix . 'show_navigation'] ) . '"';
		}
		if( $params[$prefix . 'show_bullets'] == 'true' ) {
			$owlcarousel_data[] = 'data-dots="' . esc_attr( $params[$prefix . 'show_bullets'] ) . '"';
		}
		if( $params[$prefix . 'carousel_autoplay'] == 'true' ) {
			$owlcarousel_data[] = 'data-autoplay="' . esc_attr( $params[$prefix . 'carousel_autoplay'] ) . '"';
		}
		if( $params[$prefix . 'carousel_loop'] == 'true' ) {
			$owlcarousel_data[] = 'data-loop="' . esc_attr( $params[$prefix . 'carousel_loop'] ) . '"';
		}

		if( !empty( $params[$prefix . 'animation_speed'] ) ) {
			$owlcarousel_data[] = 'data-duration="' . esc_attr( $params[$prefix . 'animation_speed'] ) . '"';
		}
		if( $params[$prefix . 'margin'] > -1 ) {
			$owlcarousel_data[] = 'data-margin="' . esc_attr( $params[$prefix . 'margin'] ) . '"';
		}
		if( !empty( $params[$prefix . 'laptop'] ) ) {
			$owlcarousel_data[] = 'data-laptop="' . esc_attr( $params[$prefix . 'laptop'] ) . '"';
		}
		if( !empty( $params[$prefix . 'tablet'] ) ) {
			$owlcarousel_data[] = 'data-tablet="' . esc_attr( $params[$prefix . 'tablet'] ) . '"';
		}

		return $owlcarousel_data;
	}
}


if ( ! function_exists( 'charitab_mascot_get_wpml_languages' ) ) {
	/**
	 * Return wpml_languages
	 */
	function charitab_mascot_get_wpml_languages() {
		$wpml = array();
		if(defined('ICL_LANGUAGE_CODE')) {
			$current_language_code = ICL_LANGUAGE_CODE;
			$langs = icl_get_languages('skip_missing=0');

			if(!empty($langs)) {
				if(!empty($langs[$current_language_code])) {
					$current_language = $langs[$current_language_code];
					$wpml[] = array(
						'label' => $current_language['native_name'],
						'url' => $current_language['url'],
						'country_flag_url' => $current_language['country_flag_url'],
					);
				}

				foreach($langs as $lang_key => $lang_info) {
					if($lang_key !== $current_language_code) {
						$wpml[] = array(
							'label' => $lang_info['native_name'],
							'url' => $lang_info['url'],
							'country_flag_url' => $lang_info['country_flag_url'],
						);
					}
				}
			}
		}

		return apply_filters('charitab_mascot_get_wpml_languages', $wpml);
	}
}


if ( ! function_exists( 'charitab_mascot_get_wpml_language_switcher' ) ) {
	/**
	 * Return wpml_language_switcher
	 */
	function charitab_mascot_get_wpml_language_switcher() {

		$element['dropdown'] = charitab_mascot_get_wpml_languages();

		$element_id = charitab_mascot_random_word();

		if( !empty( $element['dropdown'] ) ) {
			$dropdown = charitab_mascot_get_dropdown( $element['dropdown'] );
		}

		if( !empty( $dropdown ) ): ?>
			<div class="dropdown tm-wpml-language-switcher">
				<?php if( !empty( $dropdown['first'] ) ): ?>
					<div class="dropdown-toggle"
						 id="<?php echo esc_attr( $element_id ); ?>"
						 data-toggle="dropdown"
						 aria-haspopup="true"
						 aria-expanded="true"
						 >
						 <img src="<?php echo esc_url( $dropdown['first']['country_flag_url'] ); ?>" height="12" alt="<?php echo esc_attr( $dropdown['first']['label'] ); ?>" width="18" />
						<?php echo esc_html( $dropdown['first']['label'] ); ?>
						<span class="caret"></span>
					</div>
				<?php endif; ?>

				<?php if( !empty( $dropdown['others'] ) ): ?>
					<ul class="dropdown-list dropdown-menu dropdown-menu-right"
						aria-labelledby="<?php echo esc_attr( $element_id ); ?>">
						<?php foreach( $dropdown['others'] as $key => $value): ?>
							<li>
								<a class="dropdown-item" href="<?php echo esc_url( $value['url'] ) ?>">
									<img src="<?php echo esc_url( $value['country_flag_url'] ); ?>" height="12" alt="<?php echo esc_attr( $value['label'] ); ?>" width="18" />
									<?php echo esc_html( $value['label'] ); ?>
								</a>
							</li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<?php
		
	}
}


if ( ! function_exists( 'charitab_mascot_get_dropdown' ) ) {
	/**
	 * Return dropdown
	 */
	function charitab_mascot_get_dropdown( $dropdown ) {
		$choices = array(
			'first' => array(),
			'others' => array()
		);

		if(!empty($dropdown[0]) and !empty($dropdown[0]['label'])) {
			$choices['first'] = $dropdown[0];
		}

		array_shift($dropdown);

		if(!empty($dropdown)) {
			$choices['others'] = $dropdown;
		}

		return $choices;
	}
}


if ( ! function_exists( 'charitab_mascot_get_sidebar_widget_title_line_bottom_style' ) ) {
	/**
	 * Return Sidebar Widget Title Line Bottom Classes
	 */
	function charitab_mascot_get_sidebar_widget_title_line_bottom_style() {
		$classes = array();
		if( charitab_mascot_get_redux_option( 'sidebar-settings-sidebar-title-show-line-bottom' ) ) {
			$classes[] = 'widget-title-line-bottom';
		}
		$line_bottom_theme_colored = charitab_mascot_get_redux_option( 'sidebar-settings-sidebar-title-line-bottom-theme-colored' );
		if( $line_bottom_theme_colored != '' ) {
			$classes[] .= ' line-bottom-theme-colored' . $line_bottom_theme_colored;
		}

		return implode(' ', $classes);
	}
}


if ( ! function_exists( 'charitab_mascot_wp_enqueue_script_lightgallery' ) ) {
	/**
	 * wp_enqueue_script for lightgallery
	 */
	function charitab_mascot_wp_enqueue_script_lightgallery() {
		wp_enqueue_script( 'lightgallery' );
		wp_enqueue_style( 'lightgallery' );
		wp_enqueue_script( 'mousewheel' );
		wp_enqueue_script( 'lightgallery-custom' );
	}
}



if ( ! function_exists( 'charitab_mascot_wp_enqueue_script_owl_carousel' ) ) {
	/**
	 * wp_enqueue_script for owl_carousel
	 */
	function charitab_mascot_wp_enqueue_script_owl_carousel() {
		wp_enqueue_script( 'owl-carousel' );
		wp_enqueue_script( 'owl-filter' );
		wp_enqueue_script( 'owl-carousel2-thumbs' );
	}
}



if ( ! function_exists( 'charitab_mascot_wp_enqueue_script_menuzord_navigation_skin' ) ) {
	/**
	 * wp_enqueue_script for menuzord-navigation-skin
	 */
	function charitab_mascot_wp_enqueue_script_menuzord_navigation_skin() {
		wp_enqueue_style( 'charitab-mascot-menuzord-navigation-skin' );
	}
}



if(!function_exists('charitab_mascot_social_links_colors')) {
	/**
	 * Return Social Links Colors
	 */
	function charitab_mascot_social_links_colors() {
		$social_links_color = array(
			'twitter' => array(
				"name" => "Twitter",
				"icon" => "twitter",
				"color" => "#02B0E8",
			),
			'facebook' => array(
				"name" => "Facebook",
				"icon" => "facebook",
				"color" => "#3B5998",
			),
			'youtube' => array(
				"name" => "Youtube",
				"icon" => "youtube",
				"color" => "#C71F1E",
			),
			'google-plus' => array(
				"name" => "Google Plus",
				"icon" => "google-plus",
				"color" => "#D71619",
			),
			'linkedin' => array(
				"name" => "Linkedin",
				"icon" => "linkedin",
				"color" => "#007BB6",
			),
			'tumblr' => array(
				"name" => "Tumblr",
				"icon" => "tumblr",
				"color" => "#35455C",
			),
			'vk' => array(
				"name" => "VK",
				"icon" => "vk",
				"color" => "#4C75A3",
				"target" => "_blank",
			),
			'pinterest' => array(
				"name" => "Pinterest",
				"icon" => "pinterest",
				"color" => "#E71F28",
			),
			'reddit' => array(
				"name" => "Reddit",
				"icon" => "reddit",
				"color" => "#6CC0FF",
			),
			'envelope' => array(
				"name" => "Email",
				"icon" => "envelope-o",
				"color" => "#787482",
			),
			'external-link' => array(
				"name" => "Print",
				"icon" => "external-link",
				"color" => "#333",
			),
		);

		return $social_links_color;
	}
}