<?php	
/*
*
*	Core Actions
*	---------------------------------------
*	Mascot Framework v1.0
* 	Copyright ThemeMascot 2017 - http://www.thememascot.com
*
*/


if(!function_exists('charitab_mascot_action_widgets_init')) {
	/**
	 * Init Widgets
	 */
	function charitab_mascot_action_widgets_init() {
	}
}


if(!function_exists('charitab_mascot_action_wp_head')) {
	/**
	 * Head Action
	 */
	function charitab_mascot_action_wp_head() {
		charitab_mascot_wp_head_responsive_viewport();
		charitab_mascot_wp_head_favicon();
		charitab_mascot_wp_head_apple_touch_icons();
	}
}


if(!function_exists('charitab_mascot_wp_head_responsive_viewport')) {
	/**
	 * Enable Responsive
	 */
	function charitab_mascot_wp_head_responsive_viewport() {
		if( charitab_mascot_get_redux_option( 'general-settings-enable-responsive', true ) ) { ?>
			<meta name="viewport" content="width=device-width, initial-scale=1">
		<?php } else { ?>
			<meta name="viewport" content="width=1140, user-scalable=yes">
		<?php }
	}
}


if(!function_exists('charitab_mascot_wp_head_favicon')) {
	/**
	 * Add Favicon
	 */
	function charitab_mascot_wp_head_favicon() {
		if( charitab_mascot_get_redux_option( 'general-settings-favicon', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( charitab_mascot_get_redux_option( 'general-settings-favicon', false, 'url' ) ); ?>" rel="shortcut icon">
		<?php } else { ?>
			<link href="<?php echo CHARITAB_MASCOT_ASSETS_URI;?>/images/logo/favicon.png" rel="shortcut icon" type="image/png">
		<?php }
	}
}


if(!function_exists('charitab_mascot_wp_head_apple_touch_icons')) {
	/**
	 * Add Apple Touch Icons 144x144, 114x114, 72x72, 32x32
	 */
	function charitab_mascot_wp_head_apple_touch_icons() {
		//apple-touch-icon
		if( charitab_mascot_get_redux_option( 'general-settings-apple-touch-32', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( charitab_mascot_get_redux_option( 'general-settings-apple-touch-32', false, 'url' ) ); ?>" rel="apple-touch-icon">
		<?php } else { ?>
			<link href="images/apple-touch-icon.png" rel="apple-touch-icon">
		<?php }
		
		//apple-touch-icon-72x72
		if( charitab_mascot_get_redux_option( 'general-settings-apple-touch-72', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( charitab_mascot_get_redux_option( 'general-settings-apple-touch-72', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="72x72">
		<?php } else { ?>
			<link href="images/apple-touch-icon-72x72.png" rel="apple-touch-icon" sizes="72x72">
		<?php }
		
		//apple-touch-icon-114x114
		if( charitab_mascot_get_redux_option( 'general-settings-apple-touch-114', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( charitab_mascot_get_redux_option( 'general-settings-apple-touch-114', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="114x114">
		<?php } else { ?>
			<link href="images/apple-touch-icon-114x114.png" rel="apple-touch-icon" sizes="114x114">
		<?php }
		
		//apple-touch-icon-144x144
		if( charitab_mascot_get_redux_option( 'general-settings-apple-touch-144', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( charitab_mascot_get_redux_option( 'general-settings-apple-touch-144', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="144x144">
		<?php } else { ?>
			<link href="images/apple-touch-icon-144x144.png" rel="apple-touch-icon" sizes="144x144">
		<?php }
	}
}


if(!function_exists('charitab_mascot_action_wp_head_at_the_end')) {
	/**
	 * Head Action put code at the end
	 */
	function charitab_mascot_action_wp_head_at_the_end() {
		charitab_mascot_action_wp_head_at_the_end_ie8_support();
		charitab_mascot_wp_header_custom_html_js();
	}
}


if(!function_exists('charitab_mascot_action_wp_head_at_the_end_ie8_support')) {
	/**
	 * IE8 support of HTML5 elements
	 */
	function charitab_mascot_action_wp_head_at_the_end_ie8_support() {
	?>
	<!-- IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	<![endif]-->
	<?php
	}
}


if(!function_exists('charitab_mascot_wp_header_custom_html_js')) {
	/**
	 * Custom HTML/JS Code (in Footer)
	 */
	function charitab_mascot_wp_header_custom_html_js() {
		if( charitab_mascot_get_redux_option( 'custom-codes-custom-html-script-header' ) ) {
			echo "\n";
			echo charitab_mascot_get_redux_option( 'custom-codes-custom-html-script-header' );
			echo "\n";
		}
	}
}


if(!function_exists('charitab_mascot_action_wp_footer')) {
	/**
	 * Footer Action
	 */
	function charitab_mascot_action_wp_footer() {
		charitab_mascot_wp_footer_enable_smooth_scroll();
		charitab_mascot_wp_footer_enable_backtotop();
		charitab_mascot_wp_footer_custom_html_js();
	}
}


if(!function_exists('charitab_mascot_wp_footer_enable_smooth_scroll')) {
	/**
	 * Enable Smooth Scrolling
	 */
	function charitab_mascot_wp_footer_enable_smooth_scroll() {
		if( charitab_mascot_get_redux_option( 'general-settings-smooth-scroll' ) ) {
			wp_enqueue_script( 'SmoothScroll' );
		}
	}
}


if(!function_exists('charitab_mascot_wp_footer_enable_backtotop')) {
	/**
	 * Enable Back To Top
	 */
	function charitab_mascot_wp_footer_enable_backtotop() {
		if( charitab_mascot_get_redux_option( 'general-settings-enable-backtotop' ) ) { ?>
			<a class="scrollToTop" href="#"><i class="fa fa-angle-up"></i></a>
		<?php }
	}
}


if(!function_exists('charitab_mascot_wp_footer_custom_html_js')) {
	/**
	 * Custom HTML/JS Code (in Footer)
	 */
	function charitab_mascot_wp_footer_custom_html_js() {
		if( charitab_mascot_get_redux_option( 'custom-codes-custom-html-script-footer' ) ) {
			echo "\n";
			echo charitab_mascot_get_redux_option( 'custom-codes-custom-html-script-footer' );
			echo "\n";
		}
	}
}


if(!function_exists('charitab_mascot_action_theme_admin_login_custom_logo')) {
	/**
	 * Add Admin Login Custom Logo
	 */
	function charitab_mascot_action_theme_admin_login_custom_logo() { 
		$admin_login_logo = charitab_mascot_get_redux_option( 'logo-settings-admin-login-logo' );
		if( !charitab_mascot_variable_val_is_empty( $admin_login_logo ) ) {
	?>
		<style>
			#login h1 a, .login h1 a {
				background-image: url(<?php echo esc_url( $admin_login_logo['url'] ); ?>);
				height: 50px;
				width: 250px;
				background-size: 250px 50px;
				background-repeat: no-repeat;
			}
		</style>
	<?php 
		}
	}
	add_action( 'login_enqueue_scripts', 'charitab_mascot_action_theme_admin_login_custom_logo' );
}


if (!function_exists( 'charitab_mascot_require_core_plugin_message')) {
	/**
	 * Prints a mesasge in the admin if user hides TGMPA plugin activation message
	 */
	function charitab_mascot_require_core_plugin_message() {
		if ( get_user_meta( get_current_user_id(), 'tgmpa_dismissed_notice_tgmpa', true ) && !charitab_mascot_core_plugin_installed() ) {
			$class = 'notice notice-error';
			$message = esc_html__( '&diams;&diams;&diams; For proper theme functioning, the "<strong>Mascot Core</strong>" plugin is must required. Please ', 'charitab-wp' );
			$message .= '<a href="' . esc_url( admin_url( 'themes.php?page=tgmpa-install-plugins' ) ) . '">' . esc_html__( 'install', 'charitab-wp' ) . '</a>';
			$message .= esc_html__( ' and activate this plugin.', 'charitab-wp' );
			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message ); 
		}
	}
	add_action( 'admin_notices', 'charitab_mascot_require_core_plugin_message' );
}


if(!function_exists('charitab_mascot_add_theme_page')) {
	/**
	 * Add Theme Page
	 */
	function charitab_mascot_add_theme_page() {
		global $charitab_mascot_theme_info;
		$theme_name = $charitab_mascot_theme_info->get('Name');
		add_menu_page( $theme_name, $theme_name, 'manage_options', 'mascot-about', 'charitab_mascot_theme_page_about', 'dashicons-admin-generic', 4  );
		add_submenu_page( 'mascot-about', 'Support & Help', 'Support & Help', 'manage_options', 'mascot-docs', 'charitab_mascot_theme_page_docs' );
		add_submenu_page( 'mascot-about', 'FAQ', 'FAQ', 'manage_options', 'mascot-faq', 'charitab_mascot_theme_page_faq' );
		add_submenu_page( 'mascot-about', 'System Status', 'System Status', 'manage_options', 'mascot-system-status', 'charitab_mascot_theme_page_system_status' );
	}
	add_action('admin_menu', 'charitab_mascot_add_theme_page');
}

if(!function_exists('charitab_mascot_theme_page_about')) {
	function charitab_mascot_theme_page_about() {
		echo charitab_mascot_get_template_part( 'admin/admin-tpl/mascot-about' );
	}
}

if(!function_exists('charitab_mascot_theme_page_docs')) {
	function charitab_mascot_theme_page_docs() {
		echo charitab_mascot_get_template_part( 'admin/admin-tpl/mascot-docs' );
	}
}

if(!function_exists('charitab_mascot_theme_page_faq')) {
	function charitab_mascot_theme_page_faq() {
		echo charitab_mascot_get_template_part( 'admin/admin-tpl/mascot-faq' );
	}
}

if(!function_exists('charitab_mascot_theme_page_system_status')) {
	function charitab_mascot_theme_page_system_status() {
		echo charitab_mascot_get_template_part( 'admin/admin-tpl/mascot-system-status' );
	}
}


if(!function_exists('charitab_mascot_theme_is_installed_hook')) {
	/**
	 * Theme Activated Hook
	 */
	function charitab_mascot_theme_is_installed_hook() {
		$mascot_installed_var = 'mascot_theme_is_installed';
		if ( false == get_option( $mascot_installed_var, false ) ) {		
			update_option( $mascot_installed_var, true );
			wp_redirect( admin_url( 'admin.php?page=mascot-about&theme-activated=true' ) );
			die();
		} 
		delete_option( $mascot_installed_var );
	}
	add_action( 'after_switch_theme', 'charitab_mascot_theme_is_installed_hook' );
}
