<?php

if (!function_exists('charitab_mascot_sidebar_padding')) {
	/**
	 * Generate CSS codes for Sidebar Padding
	 */
	function charitab_mascot_sidebar_padding() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-padding';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-right'] != "" ) {
			$declaration['padding-right'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-right'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-left'] != "" ) {
			$declaration['padding-left'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-left'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_padding');
}


if (!function_exists('charitab_mascot_sidebar_bg_color')) {
	/**
	 * Generate CSS codes for Sidebar Background Color
	 */
	function charitab_mascot_sidebar_bg_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-bg-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_bg_color');
}


if (!function_exists('charitab_mascot_sidebar_text_align')) {
	/**
	 * Generate CSS codes for Sidebar Text Alignment
	 */
	function charitab_mascot_sidebar_text_align() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-text-align';
		$declaration = array();
		$selector = array(
			'.sidebar-area'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['text-align'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_text_align');
}





if (!function_exists('charitab_mascot_sidebar_title_padding')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Padding
	 */
	function charitab_mascot_sidebar_title_padding() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-padding';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-right'] != "" ) {
			$declaration['padding-right'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-right'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-left'] != "" ) {
			$declaration['padding-left'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-left'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_title_padding');
}


if (!function_exists('charitab_mascot_sidebar_title_bg_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Background Color
	 */
	function charitab_mascot_sidebar_title_bg_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-bg-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_title_bg_color');
}


if (!function_exists('charitab_mascot_sidebar_title_text_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Text Color
	 */
	function charitab_mascot_sidebar_title_text_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-text-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_title_text_color');
}


if (!function_exists('charitab_mascot_sidebar_title_font_size')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Font Size
	 */
	function charitab_mascot_sidebar_title_font_size() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-font-size';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['font-size'] = $charitab_mascot_redux_theme_opt[$var_name] . 'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_title_font_size');
}


if (!function_exists('charitab_mascot_sidebar_title_line_bottom_color')) {
	/**
	 * Generate CSS codes for Sidebar Widget Title Line Bottom Color
	 */
	function charitab_mascot_sidebar_title_line_bottom_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'sidebar-settings-sidebar-title-line-bottom-color';
		$declaration = array();
		$selector = array(
			'.sidebar-area .widget .widget-title.widget-title-line-bottom:after'
		);

		if( !charitab_mascot_get_redux_option( 'sidebar-settings-sidebar-title-show-line-bottom' ) ) {
			return;
		}

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_sidebar_title_line_bottom_color');
}