<?php
add_filter( 'rwmb_meta_boxes', 'charitab_mascot_page_metaboxes' );

/**
 * Register meta boxes
 *
 * @param array $meta_boxes
 *
 * @return array
 */
function charitab_mascot_page_metaboxes( $meta_boxes ) {
	//list active sidebars
	$active_sidebar_list = array();
	$active_sidebar_list[ 'inherit' ] = esc_html__( 'Inherit from Theme Options', 'charitab-wp' );
	/** @global array $wp_registered_sidebars */
	global $wp_registered_sidebars;
	foreach ( $wp_registered_sidebars as $key => $value ) {
		$active_sidebar_list[ $key ] = $value['name'];
	}

	//list menus
	$active_menu_list = array();
	$nav_menus = wp_get_nav_menus();
	if ( ! empty ( $nav_menus ) ) {
		foreach ( $nav_menus as $item ) {
			$active_menu_list[ $item->term_id ] = $item->name;
		}
		//foreach
	}

	//get primary thme location menu item
	$theme_locations = get_nav_menu_locations();
	$primary_nav_menu_name = 'none';
	if( array_key_exists('primary', $theme_locations) && !empty($theme_locations['primary']) ) {
		$primary_nav_menu_obj = get_term( $theme_locations['primary'], 'nav_menu' );
		$primary_nav_menu_name = $primary_nav_menu_obj->name;
	}

	//ALL custom post types
	//$post_types = get_post_types();

	//Get a List of All Revolution Slider Aliases
	$list_rev_sliders = array();
	if ( class_exists( 'RevSlider' ) ) {
		$list_rev_sliders[0] = esc_html__( 'Select a Slider', 'charitab-wp' );
		$rev_slider = new RevSlider();
		$all_rev_sliders = $rev_slider->getAllSliderAliases();
		foreach ( $all_rev_sliders as $key => $value ) {
			$list_rev_sliders[$value] = $value;
		}
	}


	//Get a List of All Layer Slider Aliases
	$list_layer_sliders = array();
	if ( class_exists( 'LS_Sliders' ) ) {
		$list_layer_sliders[0] = esc_html__( 'Select a Slider', 'charitab-wp' );
		$LS_Sliders_list = LS_Sliders::find();
		foreach ( $LS_Sliders_list as $each_slide ) {
			$list_layer_sliders[ $each_slide['id'] ] = $each_slide['name'];
		}
	}


	// Background Patterns Reader
	$sample_patterns_path = CHARITAB_MASCOT_ADMIN_ASSETS_DIR . '/images/pattern/';
	$sample_patterns_url  = CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/pattern/';
	$sample_patterns      = array();
	
	if ( is_dir( $sample_patterns_path ) ) {

		if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
			$sample_patterns = array();

			while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

				if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
					$name              = explode( '.', $sample_patterns_file );
					$name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
					$sample_patterns[$sample_patterns_url . $sample_patterns_file] = $sample_patterns_url . $sample_patterns_file;
				}
			}
		}
	}


	$text_align_array = array(
		'inherit'			=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
		'text-left flip'	=> esc_html__( 'Left', 'charitab-wp' ),
		'text-center'		=> esc_html__( 'Center', 'charitab-wp' ),
		'text-right flip'	=> esc_html__( 'Right', 'charitab-wp' ),
	);

	// Page Sidebar
	$meta_boxes[] = array(
		'id'			=> 'page_sidebar',
		'title'			=> esc_html__( 'Page Sidebar', 'charitab-wp' ),
		'post_types'	=> array( 'post', 'page', 'portfolio', 'campaign' ),
		'context'		=> 'side',
		'priority'		=> 'low',
		// Sub-fields
		'fields'		=> array(
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_sidebar_layout_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// Sub-fields
				'fields' => array(
					array(
						'name'		=> esc_html__( 'Sidebar Layout', 'charitab-wp' ),
						'id'		=> 'sidebar_layout',
						'type'		=> 'image_select',
						'options' 	=> array(
							'inherit'				=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/inherit.png',
							'sidebar-right-25'		=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-right-25.png',
							'sidebar-right-33'		=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-right-33.png',
							'no-sidebar'			=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/no-sidebar.png',
							'sidebar-left-25'		=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-left-25.png',
							'sidebar-left-33'		=> CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-left-33.png',
							'both-sidebar-25-50-25' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/both-sidebar-25-50-25.png',
						),
						'std'		=> 'inherit',
					),
					array(
						'name'		=> esc_html__( 'Pick Sidebar Default', 'charitab-wp' ),
						'id'		=> 'sidebar_default',
						'type'		=> 'select',
						'options'	=> $active_sidebar_list,
					),
					array(
						'type' 		=> 'heading',
						'name' 		=> esc_html__( 'Sidebar 2 Settings', 'charitab-wp' ),
						'desc'		=> esc_html__( 'Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Pick Sidebar 2', 'charitab-wp' ),
						'id'		=> 'sidebar_two',
						'type'		=> 'select',
						'options'   => $active_sidebar_list,
					),
					array(
						'name'		=> esc_html__( 'Sidebar 2 Position', 'charitab-wp' ),
						'id'		=> 'sidebar_two_position',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Controls the position of sidebar 2. In that case, sidebar 1 will be shown on opposite side.', 'charitab-wp' ),
						'options'	=> array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'left'		=> esc_html__( 'Left', 'charitab-wp' ),
							'right'	 	=> esc_html__( 'Right', 'charitab-wp' )
						),
					),
				),
			),
		),
	);

	// Meta Box Settings for this Page
	$meta_boxes[] = array(
		'title'	 => esc_html__( 'Page Settings', 'charitab-wp' ),
		'post_types' => array( 'post', 'page', 'portfolio', 'campaign' ),
		'priority'   => 'high',

		// List of tabs, in one of the following formats:
		// 1) key => label
		// 2) key => array( 'label' => Tab label, 'icon' => Tab icon )
		'tabs'		=> array(
			'slider' => array(
				'label' => esc_html__( 'Slider Settings', 'charitab-wp' ),
				'icon'  => 'dashicons-update', // Dashicon
			),
			'general' => array(
				'label' => esc_html__( 'General Settings', 'charitab-wp' ),
				'icon'  => 'dashicons-admin-home', // Dashicon
			),
			'theme-color' => array(
				'label' => esc_html__( 'Theme Color Settings', 'charitab-wp' ),
				'icon'  => 'dashicons-admin-home', // Dashicon
			),


			'header'  => array(
				'label' => esc_html__( 'Header', 'charitab-wp' ),
				'icon'  => 'dashicons-arrow-up-alt', // Dashicon
			),


			'logo' => array(
				'label' => esc_html__( 'Logo', 'charitab-wp' ),
				'icon'  => 'dashicons-palmtree', // Dashicon
			),

			'page-title'		=> array(
				'label' => esc_html__( 'Page Title', 'charitab-wp' ),
				'icon'  => 'dashicons-archive', // Dashicon
			),
			'layout-setings'	=> array(
				'label' => esc_html__( 'Layout Settings', 'charitab-wp' ),
				'icon'  => 'dashicons-editor-table', // Dashicon
			),
			'footer-top-callout'	=> array(
				'label' => esc_html__( 'Footer Call Out', 'charitab-wp' ),
				'icon'  => 'dashicons-editor-insertmore', // Dashicon
			),
			

			'footer'	=> array(
				'label' => esc_html__( 'Footer Settings', 'charitab-wp' ),
				'icon'  => 'dashicons-arrow-down-alt', // Dashicon
			),
		),

		// Tab style: 'default', 'box' or 'left'. Optional
		'tab_style' => 'left',
		
		// Show meta box wrapper around tabs? true (default) or false. Optional
		'tab_wrapper' => true,

		'fields'	=> array(

			//slider tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_slider_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'slider',
				// Sub-fields
				'fields' => array(
					//slider tab starts
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Slider Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Slider Type', 'charitab-wp' ),
						'id'		=> 'slider_type',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the type of slider you want to display.', 'charitab-wp' ),
						'options'   => array(
							'no-slider'			=> esc_html__( 'No Slider', 'charitab-wp' ),
							'rev-slider'		=> esc_html__( 'Slider Revolution', 'charitab-wp' ),
							'layer-slider'		=> esc_html__( 'Layer Slider', 'charitab-wp' ),
						),
						'std'		=> 'no-slider',
					),
					array(
						'name'		=> esc_html__( 'Choose Revolution Slider', 'charitab-wp' ),
						'id'		=> 'select_rev_slider',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the name(alias) of the revolution slider you want to display.', 'charitab-wp' ),
						'options'   => $list_rev_sliders,
						'visible'   => array( 'slider_type', '=', 'rev-slider' ),
					),
					array(
						'name'		=> esc_html__( 'Choose Layer Slider', 'charitab-wp' ),
						'id'		=> 'select_layer_slider',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the name(alias) of the revolution slider you want to display.', 'charitab-wp' ),
						'options'   => $list_layer_sliders,
						'visible'   => array( 'slider_type', '=', 'layer-slider' ),
					),
					array(
						'name'		=> esc_html__( 'Slider Position', 'charitab-wp' ),
						'id'		=> 'slider_position',
						'type'		=> 'select',
						'desc' => esc_html__( 'Choose position of the slider you want to display. You can put it below or above the header.', 'charitab-wp' ),
						'options'   => array(
							'default'		=> esc_html__( 'Default', 'charitab-wp' ),
							'below-header'	=> esc_html__( 'Below Header', 'charitab-wp' ),
							'above-header'	=> esc_html__( 'Above Header', 'charitab-wp' ),
						),
						'std'		=> 'default',
						'visible'   => array( 'slider_position', '!=', 'no-slider' ),
					),
					//slider tab ends


				),
			),
			//slider tab ends


			//general tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_general_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'general',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'General Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Hide Featured Image', 'charitab-wp' ),
						'id'		=> 'hide_featured_image',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Show Comments', 'charitab-wp' ),
						'id'		=> 'show_comments',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
					/*array(
						'name'		=> esc_html__( 'Smooth Scroll', 'charitab-wp' ),
						'id'		=> 'smooth_scroll',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'yes'		=> esc_html__( 'On', 'charitab-wp' ),
							'no'		=> esc_html__( 'Off', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Smooth Page Transitions', 'charitab-wp' ),
						'id'		=> 'smooth_page_transition',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'yes'		=> esc_html__( 'On', 'charitab-wp' ),
							'no'		=> esc_html__( 'Off', 'charitab-wp' ),
						),
					),*/
					/*array(
						'name'		=> esc_html__( 'Enable Page Preloader', 'charitab-wp' ),
						'id'		=> 'enable_page_preloader',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'yes'		=> esc_html__( 'On', 'charitab-wp' ),
							'no'		=> esc_html__( 'Off', 'charitab-wp' ),
						),
					),*/
				),
			),
			//general tab ends


			//theme-color tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_theme_color_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'theme-color',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Theme Color Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Change Primary Theme Color', 'charitab-wp' ),
						'id'		=> 'change_primary_theme_color',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'If you want to change primary theme color of this page then check this option.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Primary Theme Color', 'charitab-wp' ),
						'id'		=> 'primary_theme_color',
						'type'		=> 'select',
						'options'   => charitab_mascot_metabox_get_list_of_predefined_theme_color_css_files(),
						'visible'   => array( 
							array( 'change_primary_theme_color', '=', true )
						),
					),
				),
			),
			//theme-color tab ends

			
			//Header tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_header_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'header',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Header Visibility', 'charitab-wp' ),
						'id'		=> 'header_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide header only for this page.', 'charitab-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'   		=> esc_html__( 'Show', 'charitab-wp' ),
							'0' 		=> esc_html__( 'Hide', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Header Container', 'charitab-wp' ),
						'id'		=> 'header_container',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   		=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'container' 		=> esc_html__( 'Container', 'charitab-wp' ),
							'container-fluid' 	=> esc_html__( 'Container Fluid', 'charitab-wp' )
						),
					),
					/*array(
						'name'		=> esc_html__( 'Header Behaviour~', 'charitab-wp' ),
						'id'		=> 'header_behaviour',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   	=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'header-fixed'  => esc_html__( 'Fixed on Scroll', 'charitab-wp' ),
							'header-sticky' => esc_html__( 'Sticky on Scroll', 'charitab-wp' ),
						),
						//'visible'   => array( 'header_visibility', '!=', '0' ),
					),*/
					array(
						'name'		=> esc_html__( 'Header Layout Type', 'charitab-wp' ),
						'id'		=> 'header_layout_type',
						'type'		=> 'select',
						'options'   => array(
							'inherit'						=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'header-2rows'					=> esc_html__( 'Standard Header - 2 Rows', 'charitab-wp' ),
							'header-3rows'					=> esc_html__( 'Standard Header - 3 Rows', 'charitab-wp' ),
							'header-2rows-floating-header'	=> esc_html__( 'Floating Header - 2 Rows', 'charitab-wp' ),
							'header-logo-center'			=> esc_html__( '3 Rows Logo Center', 'charitab-wp' ),
							'header-logo-menu-center'		=> esc_html__( '3 Rows Logo + Menu Centered', 'charitab-wp' ),
							'header-mobile-nav'				=> esc_html__( 'Mobile Nav', 'charitab-wp' ),
							'header-side-panel-nav'			=> esc_html__( 'Side Panel Nav', 'charitab-wp' ),
							'header-vertical-nav'			=> esc_html__( 'Vertical Nav', 'charitab-wp' ),
						),
					),

					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Layout - Vertical Nav', 'charitab-wp' ),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'charitab-wp' ),
						'id'		=> 'vertical_nav_bgcolor',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'charitab-wp' ),
						'id'		=> 'vertical_nav_bgimg',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Shadow', 'charitab-wp' ),
						'id'		=> 'vertical_nav_shadow',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Vertical Area Border', 'charitab-wp' ),
						'id'		=> 'vertical_nav_border',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Center Content', 'charitab-wp' ),
						'id'		=> 'vertical_nav_content',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),




					// DIVIDER
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Top Row', 'charitab-wp' ),
					),

					array(
						'name' => esc_html__( 'Choose Pre Made Header Top (From Custom Post Type)', 'charitab-wp' ),
						'id'          => 'headertop_cpt_widget_area',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'header-top',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Pre Made Header Top', 'charitab-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),
					
					//Header Top
					array(
						'name'		=> esc_html__( 'Show Header Top (From Theme Options)', 'charitab-wp' ),
						'id'		=> 'show_header_top',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Enabling this option will show Header Top section.', 'charitab-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'   		=> esc_html__( 'Yes', 'charitab-wp' ),
							'0' 		=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Use Theme Color in Background?', 'charitab-wp' ),
						'id'		=> 'header_top_bgcolor_use_themecolor',
						'type'		=> 'select',
						'options'   => charitab_mascot_theme_color_list(),
						'visible'   => array( 
							array( 'show_header_top', '=', '1' )
						),
					),


					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Navigation Menu', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Primary Navigation Menu', 'charitab-wp' ),
						'id'		=> 'custom_primary_nav_menu',
						'type'		=> 'taxonomy',
						'desc'		=> sprintf( esc_html__( 'Select which menu you want to display as primary navigation on this page. Currently set to %1$s%2$s%3$s.', 'charitab-wp' ), '<a target="_blank" href="' . esc_url( admin_url( 'nav-menus.php?action=locations' ) ) . '">', $primary_nav_menu_name, '</a>' ),
						'taxonomy'  => 'nav_menu',
						'field_type'=> 'select',
						'query_args'=> array(),
					),
					array(
						'name'		=> esc_html__( 'Enable One Page Nav Smooth Scrolling Effect', 'charitab-wp' ),
						'id'		=> 'enable_one_page_nav_scrolling_effect',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Check this box in order to enable one page navigation smooth scrollling effect.', 'charitab-wp' ),
					),
				),
			),
			//Header tab ends



			//Logo tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_logo_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'logo',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Logo Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Alternative Site Brand', 'charitab-wp' ),
						'id'		=> 'logo_site_brand',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as logo.', 'charitab-wp' ),
						'type'		=> 'text',
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Logo', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Use logo in replace of text?', 'charitab-wp' ),
						'id'		=> 'use_logo',
						'type'		=> 'select',
						'options'   => array(
							'inherit' 	=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Logo (Default)', 'charitab-wp' ),
						'id'		=> 'logo_default',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Default) Retina', 'charitab-wp' ),
						'id'		=> 'logo_default_2x',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_logo', '!=', '0' ),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Switchable logo', 'charitab-wp' ),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Switchable logo(Light/Dark)?', 'charitab-wp' ),
						'id'		=> 'use_switchable_logo',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Light)', 'charitab-wp' ),
						'id'		=> 'logo_light',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Light) Retina', 'charitab-wp' ),
						'id'		=> 'logo_light_2x',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Dark)', 'charitab-wp' ),
						'id'		=> 'logo_dark',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Dark) Retina', 'charitab-wp' ),
						'id'		=> 'logo_dark_2x',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Logo height', 'charitab-wp' ),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Maximum logo height(px)', 'charitab-wp' ),
						'id'		=> 'logo_maximum_height',
						'type'		=> 'slider',
						'desc'		=> esc_html__( 'Enter maximum logo height in px.', 'charitab-wp' ),
						'suffix' => esc_html__( 'px', 'charitab-wp' ),
						'js_options' => array(
							'min'  => 20,
							'max'  => 150,
							'step' => 1,
						),
						// Default value
						'std'		=> 40,
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
				),
			),
			//Logo tab ends



			//Page Title tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_page_title_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'page-title',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Page Title', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Enable Page Title', 'charitab-wp' ),
						'id'		=> 'enable_page_title',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Title & Subtitle', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Title Type', 'charitab-wp' ),
						'id'		=> 'page_title_type',
						'type'		=> 'select',
						'options'   => array(
							'page-title'   		=> esc_html__( 'Show This Page Title', 'charitab-wp' ),
							'custom-title'		=> esc_html__( 'Enter Custom Title', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Custom Title Text', 'charitab-wp' ),
						'id'		=> 'custom_page_title_text',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as page title.', 'charitab-wp' ),
						'type'		=> 'text',
						'visible'   => array( 
							//array( 'enable_page_title', '!=', '0' ),
							array( 'page_title_type', '=', 'custom-title' )
						),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Text', 'charitab-wp' ),
						'id'		=> 'page_sub_title_text',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as subtitle.', 'charitab-wp' ),
						'type'		=> 'text',
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Page Title Layout', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Choose Page Title Layout', 'charitab-wp' ),
						'id'		=> 'title_layout',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'standard'  => esc_html__( 'Standard', 'charitab-wp' ),
							'split'	 	=> esc_html__( 'Split', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Container', 'charitab-wp' ),
						'id'		=> 'title_container',
						'type'		=> 'select',
						'options'   => array(
							'inherit'			=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'container'			=> esc_html__( 'Container', 'charitab-wp' ),
							'container-fluid'   => esc_html__( 'Container Fluid', 'charitab-wp' )
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Text Alignment', 'charitab-wp' ),
						'id'		=> 'title_text_align',
						'type'		=> 'select',
						'options'   => $text_align_array,
					),
					array(
						'name'		=> esc_html__( 'Default Text Color', 'charitab-wp' ),
						'id'		=> 'title_default_text_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'text-light' 	=> esc_html__( 'Light Text', 'charitab-wp' ),
							'text-dark'  	=> esc_html__( 'Dark Text', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Height', 'charitab-wp' ),
						'id'		=> 'title_area_height',
						'type'		=> 'select',
						'options'   => array(
							'inherit'				=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'padding-default'		=> esc_html__( 'Default', 'charitab-wp' ),
							'padding-extra-small'   => esc_html__( 'Extra Small', 'charitab-wp' ),
							'padding-small'			=> esc_html__( 'Small', 'charitab-wp' ),
							'padding-medium'		=> esc_html__( 'Medium', 'charitab-wp' ),
							'padding-large'			=> esc_html__( 'Large', 'charitab-wp' ),
							'padding-extra-large'   => esc_html__( 'Extra Large', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Show Title', 'charitab-wp' ),
						'id'		=> 'title_area_show_title',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Show Breadcrumbs', 'charitab-wp' ),
						'id'		=> 'title_area_show_breadcrumbs',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Page Title Background', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Title Background Type', 'charitab-wp' ),
						'id'		=> 'title_area_bg_type',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'bg-color'  => esc_html__( 'Background Color', 'charitab-wp' ),
							'bg-img'	=> esc_html__( 'Background Image', 'charitab-wp' ),
							'bg-video'	=> esc_html__( 'Background Video', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'charitab-wp' ),
						'id'		=> 'title_area_bgcolor',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-color' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'charitab-wp' ),
						'id'		=> 'title_area_bgimg',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-img' )
						),
					),
					/*array(
						'name'		=> esc_html__( 'Page Title Background Parallax Effect', 'charitab-wp' ),
						'id'		=> 'title_area_bg_parallax_effect',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-img' )
						),
					),*/
					array(
						'name'		=> esc_html__( 'Add Background Video', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_status',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-video' )
						),
					),
					array(
						'name'		=> esc_html__( 'Video Type', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_type',
						'type'		=> 'select',
						'options'   => array(
							'youtube'		=> esc_html__( 'Youtube', 'charitab-wp' ),
							'self-hosted'   => esc_html__( 'Self Hosted Video', 'charitab-wp' )
						),
						'visible'   => array( 
							array( 'title_area_bg_video_status', '=', '1' )
						),
					),
					array(
						'name'		=> esc_html__( 'Youtube Video ID', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_youtube_id',
						'desc'		=> esc_html__( 'Only put video ID not the whole URL. Example: E5ln4uR4TwQ', 'charitab-wp' ),
						'type'		=> 'text',
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'youtube' )
						),
					),
					array(
						'name'		=> esc_html__( 'Video Poster', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_video_poster',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'MP4 Video', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_mp4_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'WEBM Video', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_webm_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'OGV Video', 'charitab-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_ogv_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),



					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Background Overlay', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Add Page Title Background Overlay?', 'charitab-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_status',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Overlay Opacity', 'charitab-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_opacity',
						'type'		=> 'slider',
						'desc'		=> esc_html__( 'Overlay on background image on Page Title.', 'charitab-wp' ),
						'js_options' => array(
							'min'  => 1,
							'max'  => 9,
							'step' => 1,
						),
						// Default value
						'std'		=> 7,
						'visible'   => array( 
							array( 'title_area_bg_layer_overlay_status', '=', '1' )
						),
					),
					array(
						'name'		=> esc_html__( 'Overlay Color', 'charitab-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'dark'  	=> esc_html__( 'Dark', 'charitab-wp' ),
							'white' 	=> esc_html__( 'White', 'charitab-wp' )
						),
						'visible'   => array( 
							array( 'title_area_bg_layer_overlay_status', '=', '1' )
						),
					),



					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Animation Effect', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Title Animation Effect', 'charitab-wp' ),
						'id'		=> 'title_animation_effect',
						'type'		=> 'select_advanced',
						'options'   => charitab_mascot_animate_css_animation_list(),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Animation Effect', 'charitab-wp' ),
						'id'		=> 'subtitle_animation_effect',
						'type'		=> 'select_advanced',
						'options'   => charitab_mascot_animate_css_animation_list(),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Typography', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Title Tag', 'charitab-wp' ),
						'id'		=> 'title_tag',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'h1'		=> 'h1',
							'h2'		=> 'h2',
							'h3'		=> 'h3',
							'h4'		=> 'h4',
							'h5'		=> 'h5',
							'h6'		=> 'h6',
						),
					),
					array(
						'name'		=> esc_html__( 'Title Color', 'charitab-wp' ),
						'id'		=> 'title_color',
						'type'		=> 'color',
					),
					array(
						'name'		=> esc_html__( 'Subtitle Tag', 'charitab-wp' ),
						'id'		=> 'subtitle_tag',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'h1'		=> 'h1',
							'h2'		=> 'h2',
							'h3'		=> 'h3',
							'h4'		=> 'h4',
							'h5'		=> 'h5',
							'h6'		=> 'h6',
						),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Color', 'charitab-wp' ),
						'id'		=> 'subtitle_color',
						'type'		=> 'color',
					),
				),
			),
			//Page Title tab ends



			//Layout tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_layout_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'layout-setings',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Layout Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Layout', 'charitab-wp' ),
						'id'		=> 'page_layout',
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'boxed'			=> esc_html__( 'Boxed', 'charitab-wp' ),
							'stretched'	 	=> esc_html__( 'Stretched', 'charitab-wp' )
						),
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Content Width Setting', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Content Width', 'charitab-wp' ),
						'id'		=> 'content_width',
						'desc'		=> esc_html__( 'Select content width. You can use any width by using custom CSS.', 'charitab-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'				=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'container-970px'	 	=> esc_html__( '970px', 'charitab-wp' ),
							'container-default'		=> esc_html__( '1170px (Bootstrap Default)', 'charitab-wp' ),
							'container-1230px'		=> esc_html__( '1230px (Wide)', 'charitab-wp' ),
							'container-1340px'		=> esc_html__( '1340px (Wider)', 'charitab-wp' ),
							'container-1500px'		=> esc_html__( '1500px (Wider)', 'charitab-wp' ),
							'container-1600px'		=> esc_html__( '1600px (Wider)', 'charitab-wp' ),
							'container-100pr'	 	=> esc_html__( 'Fullwidth 100%', 'charitab-wp' )
						),
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Boxed Layout Settings', 'charitab-wp' ),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),
					array(
						'name'		=> esc_html__( 'Padding Top(px)', 'charitab-wp' ),
						'id'		=> 'boxed_layout_padding_top',
						'desc'		=> esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added at the end of the value.', 'charitab-wp' ),
						'type'		=> 'number',
						'visible'   => array( 
							array( 'page_layout', '!=', 'stretched' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Padding Bottom(px)', 'charitab-wp' ),
						'id'		=> 'boxed_layout_padding_bottom',
						'desc'		=> esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added at the end of the value.', 'charitab-wp' ),
						'type'		=> 'number',
						'visible'   => array( 
							array( 'page_layout', '!=', 'stretched' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Container Shadow?', 'charitab-wp' ),
						'id'		=> 'boxed_layout_container_shadow',
						'desc'		=> esc_html__( 'Add shadow around the container.', 'charitab-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),


					array(
						'name'		=> esc_html__( 'Background Type', 'charitab-wp' ),
						'id'		=> 'boxed_layout_bg_type',
						'desc'		=> esc_html__( 'You can use patterns, image or solid color as a background.', 'charitab-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'bg-color'	 	=> esc_html__( 'Solid Color', 'charitab-wp' ),
							'bg-pattern'	=> esc_html__( 'Patterns from Theme Library', 'charitab-wp' ),
							'bg-image'	 	=> esc_html__( 'Upload Own Image', 'charitab-wp' ),
						),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'charitab-wp' ),
						'id'		=> 'boxed_layout_bg_type_color',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-color' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Pattern from Theme Library', 'charitab-wp' ),
						'id'		=> 'boxed_layout_bg_type_pattern',
						'type'		=> 'image_select',
						// Array of 'value' => 'Image Source' pairs
						'options'   => $sample_patterns,
						'std'		=> $sample_patterns[key($sample_patterns)],
						// Allow to select multiple values? Default is false
						// 'multiple' => true,
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-pattern' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'charitab-wp' ),
						'id'		=> 'boxed_layout_bg_type_img',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-image' )
						),
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Dark Layout Settings', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Enable Dark Layout Mode', 'charitab-wp' ),
						'id'		=> 'enable_dark_layout_mode',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Check this box to enable dark layout mode.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Custom Dark Background Color', 'charitab-wp' ),
						'id'		=> 'dark_layout_mode_bg_color',
						'type'		=> 'color',
						'desc'		=> esc_html__( 'You can choose custom Background Color. Otherwise it will come from style css file.', 'charitab-wp' ),
					),
				),
			),
			//Layout tab ends



			//footer-top-callout tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_footer_top_callout_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'footer-top-callout',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Footer Top Callout Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Footer Top Callout Visibility', 'charitab-wp' ),
						'id'		=> 'callout_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide Footer Top Callout only for this page.', 'charitab-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'		=> esc_html__( 'Show', 'charitab-wp' ),
							'0'		=> esc_html__( 'Hide', 'charitab-wp' ),
						),
					),
				),
			),
			//footer-top-callout tab ends



			//footer tab starts
			array(
				'id'     => 'charitab_mascot_' . 'page_mb_footer_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'footer',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Footer Settings', 'charitab-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'charitab-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Footer Visibility', 'charitab-wp' ),
						'id'		=> 'footer_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide footer only for this page.', 'charitab-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Show', 'charitab-wp' ),
							'0'			=> esc_html__( 'Hide', 'charitab-wp' ),
						),
					),
					array(
						'name' => esc_html__( 'Choose Footer', 'charitab-wp' ),
						'id'          => 'footer_widget_area',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'footer',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Footer', 'charitab-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),
					array(
						'name'		=> esc_html__( 'Fixed Footer Bottom Effect', 'charitab-wp' ),
						'id'		=> 'footer_fixed_footer_bottom',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Enabling this option will make Footer gradually appear on scroll. This is popular for OnePage Websites.', 'charitab-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'charitab-wp' ),
							'1'			=> esc_html__( 'Yes', 'charitab-wp' ),
							'0'			=> esc_html__( 'No', 'charitab-wp' ),
						),
					),
				),
			),
			//footer tab ends


		),
	);


	return $meta_boxes;
}
