<?php


if(!function_exists('charitab_mascot_get_header_parts')) {
	/**
	 * Function that Renders Header HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_parts() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Header Visibility
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_visibility', $current_page_id );
		
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_visibility'] = $temp_meta_value;
		} else {
			$params['header_visibility'] = charitab_mascot_get_redux_option( 'header-settings-choose-header-visibility', true );
		}

		/*if( !$params['header_visibility'] ) {
			return;
		}*/
		
		//Header Layout Type
		$params['header_layout_type'] = charitab_mascot_return_header_layout_type();

		$params['header_slider_type'] = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_slider_settings", 'slider_type', $current_page_id );
		$params['header_slider_position'] = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_slider_settings", 'slider_position', $current_page_id );


		$header_classes = array();
		$header_classes[] = 'header-layout-type-' . $params['header_layout_type'];

		//Header Vertical Nav Classes
		if( $params['header_layout_type'] == 'header-vertical-nav' ) {

			//Add Background Overlay
			if( charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-layer-overlay-status' ) ) {
				$header_classes[] = 'layer-overlay overlay-'.charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-layer-overlay-color' ) .'-'.charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-layer-overlay' );
			}


			if( charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-shadow', false ) == true ) {
				$header_classes[] = 'vertical-nav-shadow';
			}

			if( charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-border', false ) == true ) {
				$header_classes[] = 'vertical-nav-border';
			}

			if( charitab_mascot_get_redux_option( 'header-settings-navigation-vertical-nav-center-content', false ) == true ) {
				$header_classes[] = 'vertical-nav-center-content';
			}
		}

		$params['header_classes'] = apply_filters( 'charitab_mascot_header_classes', $header_classes );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-parts', null, 'header/tpl', $params );

		return $html;
	}
}

if(!function_exists('charitab_mascot_header_classes_add_additional_class')) {
	/**
	 * Function that Adds Additional Classes to header class
	 * @return HTML
	 */
	function charitab_mascot_header_classes_add_additional_class( $header_classes ) {
		$header_layout_type = charitab_mascot_return_header_layout_type();

		if( $header_layout_type == 'header-2rows-floating-header' ) {
			$header_classes[] = charitab_mascot_get_redux_option( 'header-settings-header-layout-other-bg-shadow', 'header-bg-dark-shadow' );
		}
		return $header_classes;
	}
	add_filter( 'charitab_mascot_header_classes', 'charitab_mascot_header_classes_add_additional_class' );
}


if(!function_exists('charitab_mascot_get_header_layout_type')) {
	/**
	 * Function that Renders Header Layout Type HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_layout_type() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		/*
		* Header Layout
		*/
		
		//Header Layout Type
		$params['header_layout_type'] = charitab_mascot_return_header_layout_type();


		//Header Container
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_container', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_layout_container_class'] = $temp_meta_value;
		} else {
			$params['header_layout_container_class'] = charitab_mascot_get_redux_option( 'header-settings-header-layout-type-container', 'container' );
		}

		
		
		//Header Behaviour
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_behaviour', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_layout_behaviour'] = $temp_meta_value;
		} else {
			$params['header_layout_behaviour'] = charitab_mascot_get_redux_option( 'header-settings-header-layout-type-behaviour');
		}
		


		/*
		* Header Navigation Row
		*/
		//if Use Theme Color in Background enabled
		$params['header_nav_row_bg_theme_colored'] = '';
		if( !_empty( charitab_mascot_get_redux_option( 'header-settings-navigation-bgcolor-use-themecolor' )) ) {
			$params['header_nav_row_bg_theme_colored'] = 'bg-theme-colored' . charitab_mascot_get_redux_option( 'header-settings-navigation-bgcolor-use-themecolor' );
		}


		//Navigation Skin
		$params['navigation_skin'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-navigation-skin' ) );

		//register and enque menuzord css skin
		if( $params['navigation_skin'] ) {
			wp_register_style( 'charitab-mascot-menuzord-navigation-skin', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/menuzord/css/skins/menuzord-'.$params['navigation_skin'].'.css', array(), CHARITAB_MASCOT_THEME_VERSION );
			add_action( 'get_footer', 'charitab_mascot_wp_enqueue_script_menuzord_navigation_skin' );
		}


		//Header Navigation Color Scheme
		$params['navigation_color_scheme'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-navigation-color-scheme' ) );


		//Header Navigation Primary Effect
		$params['navigation_primary_effect'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-navigation-primary-effect' ) );

		//Header Navigation CSS3 Animation
		$params['navigation_css3_animation'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-navigation-css3-animation' ) );


		//Show Header Navigation Row
		$params['show_header_nav_row'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-header-nav-row', true );

		if( $params['header_layout_type'] == 'header-mobile-nav' ) {
			wp_enqueue_script( 'menufullpage' );
		}



		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( $params['header_layout_type'], null, 'header/tpl/header-type', $params );

		return $html;
	}
}


if(!function_exists('charitab_mascot_header_navbar_scrolltofixed_add_class_to_body')) {
	/**
	 * Function that adds class to body
	 */
	function charitab_mascot_header_navbar_scrolltofixed_add_class_to_body ( $classes ) {
		$current_page_id = charitab_mascot_get_page_id();
		//Header Layout Type
		$header_navbar_scrolltofixed = charitab_mascot_get_redux_option( 'header-settings-navigation-show-header-nav-bar-fixed-on-scroll', true );

		if ( $header_navbar_scrolltofixed ) {
			$classes[] = 'tm-enable-navbar-scrolltofixed';
			
			$header_navbar_scrolltofixed_always_visible = charitab_mascot_get_redux_option( 'header-settings-navigation-show-header-nav-bar-always-visible-on-scroll', true );
			if ( $header_navbar_scrolltofixed_always_visible ) {
				$classes[] = 'tm-enable-navbar-always-visible-on-scroll';
			}
		}

		return $classes;
	}
	add_filter( 'body_class', 'charitab_mascot_header_navbar_scrolltofixed_add_class_to_body' );
}


if(!function_exists('charitab_mascot_header_mobile_vertical_nav_add_class_to_body')) {
	/**
	 * Function that adds class to body
	 */
	function charitab_mascot_header_mobile_vertical_nav_add_class_to_body ( $classes ) {
		$current_page_id = charitab_mascot_get_page_id();
		//Header Layout Type
		$header_layout_type = charitab_mascot_return_header_layout_type();

		if( $header_layout_type == 'header-mobile-nav' ) {
			$classes[] = 'menu-full-page';
		} else if ( $header_layout_type == 'header-vertical-nav' ) {
			$classes[] = 'tm-vertical-nav';
		}

		return $classes;
	}
	add_filter( 'body_class', 'charitab_mascot_header_mobile_vertical_nav_add_class_to_body' );
}


if(!function_exists('charitab_mascot_return_header_layout_type')) {
	/**
	 * Function that Returns Header Layout Type Class
	 */
	function charitab_mascot_return_header_layout_type() {
		$current_page_id = charitab_mascot_get_page_id();
		$header_layout_type = '';
		//Header Layout Type
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_layout_type', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$header_layout_type = $temp_meta_value;
		} else {
			$header_layout_type = charitab_mascot_get_redux_option( 'header-settings-choose-header-layout-type', 'header-2rows' );
		}

		return $header_layout_type;
	}
}


if(!function_exists('charitab_mascot_get_header_top_cpt')) {
	/**
	 * Function that Renders Header Top CPT Post HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_top_cpt() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();
		$html = '';

		if ( charitab_mascot_core_plugin_installed() ) {
			//Footer Widget Area
			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'headertop_cpt_widget_area', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
				$params['header_top_cpt_post'] = $temp_meta_value;
			} else {
				$params['header_top_cpt_post'] = charitab_mascot_get_redux_option( 'header-settings-choose-header-top-cpt-widget-area' );
			}

			if( !$params['header_top_cpt_post'] ) {
				return;
			}

			//query args
			$args = array(
				'post_type' => 'header-top',
				'p' => $params['header_top_cpt_post'],
			);
			$the_query = new \WP_Query( $args );
			$params['the_query'] = $the_query;

			//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
			$html = charitab_mascot_get_blocks_template_part( 'header-top-cpt', null, 'header/tpl/parts', $params );
		}
	}
	add_action( 'charitab_mascot_header_top_area', 'charitab_mascot_get_header_top_cpt' );
}


if(!function_exists('charitab_mascot_get_header_top')) {
	/**
	 * Function that Renders Header Top HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_top() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		//Show Header Top
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'show_header_top', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['show_header_top'] = $temp_meta_value;
		} else {
			$params['show_header_top'] = charitab_mascot_get_redux_option( 'header-settings-show-header-top' );
		}
		

		if( !$params['show_header_top'] ) {
			return;
		}


		$params['show_header_top_in_mobile_device'] = charitab_mascot_get_redux_option( 'header-settings-show-header-top-in-mobile' );
		$params['header_top_hidden_class'] = '';
		if( !$params['show_header_top_in_mobile_device'] ) {
			$params['header_top_hidden_class'] = 'hidden-mobile-mode';
		}


		
		//if Use Theme Color in Background enabled
		$params['header_top_bg_theme_colored'] = '';
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_top_bgcolor_use_themecolor', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_top_bg_theme_colored'] = $temp_meta_value;
		} else {
			$params['header_top_bg_theme_colored'] = charitab_mascot_get_redux_option( 'header-settings-header-top-bgcolor-use-themecolor' );
		}

		if( !_empty( $params['header_top_bg_theme_colored'] ) ) {
			$params['header_top_bg_theme_colored'] = 'bg-theme-colored' . $params['header_top_bg_theme_colored'];
		}


		//Header Container
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_container', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_layout_container_class'] = $temp_meta_value;
		} else {
			$params['header_layout_container_class'] = charitab_mascot_get_redux_option( 'header-settings-header-layout-type-container', 'container' );
		}

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-top', null, 'header/tpl/parts', $params );
		
		return $html;
	}
	add_action( 'charitab_mascot_header_top_area', 'charitab_mascot_get_header_top' );
}


if(!function_exists('charitab_mascot_get_header_logo')) {
	/**
	 * Function that Renders Header Logo HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_logo() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'logo_site_brand', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "" ) {
			$params['site_brand'] = trim($temp_meta_value);
		} else {
			$params['site_brand'] = esc_html( charitab_mascot_get_redux_option( 'logo-settings-site-brand', get_bloginfo( 'name' ) ) );
		}


		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'use_logo', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['use_logo'] = $temp_meta_value;
		} else {
			$params['use_logo'] = charitab_mascot_get_redux_option( 'logo-settings-want-to-use-logo', false );
		}


		if( $params['use_logo'] ) {
			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_default', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
				$params['logo_default'] = $temp_meta_value;
			} else {
				$params['logo_default'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-default', false, 'url' ) );
			}

			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_default_2x', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
				$params['logo_default_2x'] = $temp_meta_value;
			} else {
				$params['logo_default_2x'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-default-2x', false, 'url' ) );
			}


			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'use_switchable_logo', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
				$params['use_switchable_logo'] = $temp_meta_value;
			} else {
				$params['use_switchable_logo'] = charitab_mascot_get_redux_option( 'logo-settings-switchable-logo' );
			}

			

			if( $params['use_switchable_logo'] ) {
				//logo light
				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_light', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
					$params['logo_light'] = $temp_meta_value;
				} else {
					$params['logo_light'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-light', false, 'url' ) );
				}

				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_light_2x', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
					$params['logo_light_2x'] = $temp_meta_value;
				} else {
					$params['logo_light_2x'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-light-2x', false, 'url' ) );
				}




				//logo dark
				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_dark', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
					$params['logo_dark'] = $temp_meta_value;
				} else {
					$params['logo_dark'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-dark', false, 'url' ) );
				}

				//logo dark
				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . 'page_mb_logo_settings', 'logo_dark_2x', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) ) {
					$params['logo_dark_2x'] = $temp_meta_value;
				} else {
					$params['logo_dark_2x'] = esc_url( charitab_mascot_get_redux_option( 'logo-settings-logo-dark-2x', false, 'url' ) );
				}

			}

			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'logo_maximum_width', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "" ) {
				$params['logo_maximum_width'] = $temp_meta_value;
			} else {
				$params['logo_maximum_width'] = charitab_mascot_get_redux_option( 'logo-settings-maximum-logo-width' );
			}

			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'logo_maximum_height', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "" ) {
				$params['maximum_logo_height'] = $temp_meta_value;
			} else {
				$params['maximum_logo_height'] = charitab_mascot_get_redux_option( 'logo-settings-maximum-logo-height' );
			}
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-logo', null, 'header/tpl/parts', $params );
		
		return $html;
	}
	add_action( 'charitab_mascot_header_logo', 'charitab_mascot_get_header_logo' );
}


if(!function_exists('charitab_mascot_get_header_primary_nav')) {
	/**
	 * Function that Renders Header Primary Nav HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_primary_nav( $main_nav_id = 'main-nav' ) {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();
		

		//Header Layout Type
		$params['header_layout_type'] = charitab_mascot_return_header_layout_type();
		$params['main_nav_id'] = $main_nav_id;

		
		//Primary Navigation Menu Only For This Page
		$params['custom_primary_nav_menu'] = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'custom_primary_nav_menu', $current_page_id );
		$params['enable_one_page_nav_scrolling_effect'] = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'enable_one_page_nav_scrolling_effect', $current_page_id );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-primary-nav', null, 'header/tpl/parts', $params );
		
		return $html;
	}
	add_action( 'charitab_mascot_header_primary_nav', 'charitab_mascot_get_header_primary_nav', 10, 1 );
}


if (!function_exists('charitab_mascot_switchable_logo_add_class_to_body')) {
	/**
	 * Add classes to body
	 */
	function charitab_mascot_switchable_logo_add_class_to_body ( $classes ) {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_logo_settings", 'use_switchable_logo', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['use_switchable_logo'] = $temp_meta_value;
		} else {
			$params['use_switchable_logo'] = charitab_mascot_get_redux_option( 'logo-settings-switchable-logo' );
		}
		
		if( $params['use_switchable_logo'] ) {
			$classes[] = 'switchable-logo';
		}

		return $classes;
	}
	
	add_filter( 'body_class', 'charitab_mascot_switchable_logo_add_class_to_body' );
}


if (!function_exists('charitab_mascot_get_header_top_columns_layout')) {
	/**
	 * Return Header Top Columns Layout HTML
	 */
	function charitab_mascot_get_header_top_columns_layout() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();



		//Header Top Column 1 - Text Alignment
		$params['header_top_column1_text_alignment'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-header-top-column1-text-align' ) );



		//Header Top Column 2 - Text Alignment
		$params['header_top_column2_text_alignment'] = esc_attr( charitab_mascot_get_redux_option( 'header-settings-header-top-column2-text-align' ) );


		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-top-sidebar-columns-default', null, 'header/tpl/sidebar-columns', $params );
		
		return $html;
	}
}


if(!function_exists('charitab_mascot_get_header_menu')) {
	/**
	 * Function that Renders Header Menu HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_menu() {
		$params = array();

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-'.charitab_mascot_get_redux_option( 'header-settings-choose-header-navigation-type' ), null, 'header/tpl/header-type', $params );
		
		return $html;
	}
}



if (!function_exists('charitab_mascot_get_header_top_column1_content')) {
	/**
	 * Return Header Top Column1 Content HTML
	 */
	function charitab_mascot_get_header_top_column1_content() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();
		$html = '';

		//Header Top Column 1 (Left Widget) - Content Types
		$params['header_top_column1_content_type'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-content' );

		if( empty( $params['header_top_column1_content_type'] ) ) {
			return;
		}


		//foreach content type
		if (is_array($params['header_top_column1_content_type']) || is_object($params['header_top_column1_content_type'])) {
			foreach ( $params['header_top_column1_content_type'] as $each_content_type ) {
				
				switch ( $each_content_type ) {
					case 'contact-info':
						# code...
						//Contact Info
						$params['contact_info_checkbox'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-contact-info-checkbox' );

						break;

					case 'custom-text':
						# code...
						//Custom Text
						$params['custom_text'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-text' );
						break;

					case 'custom-button':
						# code...
						//Custom Text
						$params['custom_button'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button' );
						$params['custom_button_design_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-design-style' );
						$params['custom_button_size'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-size' );
						$params['custom_button_flat'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-flat' );
						$params['custom_button_outlined'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-outlined' );
						$params['custom_button_round'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-round' );
						$params['custom_button_link_open_in'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-custom-button-link-open-in-window' );
						//button classes
						$params['btn_classes'] = charitab_mascot_prepare_header_button_classes_from_params( $params );
						break;

					case 'header-top-nav':
						# code...
						//Header Top Navigatin
						$params['header_top_nav_col_number'] = esc_html__( "Columns 1", 'charitab-wp' );
						$params['header_top_nav'] = 'column1-header-top-nav';
						break;

					case 'social-links':
						# code...
						//Enabled social links
						$params['social_links'] = charitab_mascot_get_redux_option( 'social-links-ordering', false, 'Enabled' );
						$params['social_links_label'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-label' );
						$params['social_links_icon_color'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-color' );
						$params['social_links_icon_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-icon-style' );
						$params['social_links_icon_size'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-icon-size' );
						$params['social_links_icon_border_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-icon-border-style' );
						$params['social_links_icon_theme_colored'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column1-social-links-theme-colored' );

						//social links classes
						$social_links_classes = array();
						if( $params['social_links_icon_color'] ) {
							$social_links_classes[] = $params['social_links_icon_color'];
						}
						if( $params['social_links_icon_style'] ) {
							$social_links_classes[] = $params['social_links_icon_style'];
						}
						if( $params['social_links_icon_size'] ) {
							$social_links_classes[] = $params['social_links_icon_size'];
						}
						if( $params['social_links_icon_border_style'] ) {
							$social_links_classes[] = 'icon-bordered';
						}
						if( $params['social_links_icon_theme_colored'] ) {
							$social_links_classes[] = 'icon-theme-colored' . $params['social_links_icon_theme_colored'];
						}
						$params['social_links_classes'] = $social_links_classes;
						break;

					case 'search-box':
						# code...
						break;

					case 'header-top-side-push-panel':
						# code...
						break;

					case 'login-register':
						# code...
						break;

					case 'wpml-languages':
						# code...
						break;

					case 'checkout-button':
						# code...
						break;
					
					default:
						# code...
						break;
				}

				//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
				$html .= charitab_mascot_get_blocks_template_part( $each_content_type, null, 'header/tpl/content', $params );

			}//end foreach content type
		}
		
		return $html;
	}
}



if (!function_exists('charitab_mascot_get_header_top_column2_content')) {
	/**
	 * Return Header Top column2 Content HTML
	 */
	function charitab_mascot_get_header_top_column2_content() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();
		$html = '';

		//Header Top Column 2 (Right Widget) - Content Types
		$params['header_top_column2_content_type'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-content' );

		if( empty( $params['header_top_column2_content_type'] ) ) {
			return;
		}

		//foreach content type
		if (is_array($params['header_top_column2_content_type']) || is_object($params['header_top_column2_content_type'])) {
			foreach ( $params['header_top_column2_content_type'] as $each_content_type ) {
				
				switch ( $each_content_type ) {
					case 'contact-info':
						# code...
						//Contact Info
						$params['contact_info'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-contact-info' );
						$params['contact_info_checkbox'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-contact-info-checkbox' );

						break;

					case 'custom-text':
						# code...
						//Custom Text
						$params['custom_text'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-text' );
						break;

					case 'custom-button':
						# code...
						//Custom Text
						$params['custom_button'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button' );
						$params['custom_button_design_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-design-style' );
						$params['custom_button_size'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-size' );
						$params['custom_button_flat'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-flat' );
						$params['custom_button_outlined'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-outlined' );
						$params['custom_button_round'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-round' );
						$params['custom_button_link_open_in'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-custom-button-link-open-in-window' );
						//button classes
						$params['btn_classes'] = charitab_mascot_prepare_header_button_classes_from_params( $params );
						break;

					case 'header-top-nav':
						# code...
						//Header Top Navigatin
						$params['header_top_nav_col_number'] = esc_html__( "Columns 2", 'charitab-wp' );
						$params['header_top_nav'] = 'column2-header-top-nav';
						break;

					case 'social-links':
						# code...
						//Enabled social links
						$params['social_links'] = charitab_mascot_get_redux_option( 'social-links-ordering', false, 'Enabled' );
						$params['social_links_label'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-label' );
						$params['social_links_icon_color'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-color' );
						$params['social_links_icon_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-icon-style' );
						$params['social_links_icon_size'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-icon-size' );
						$params['social_links_icon_border_style'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-icon-border-style' );
						$params['social_links_icon_theme_colored'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column2-social-links-theme-colored' );

						//social links classes
						$social_links_classes = array();
						if( $params['social_links_icon_color'] ) {
							$social_links_classes[] = $params['social_links_icon_color'];
						}
						if( $params['social_links_icon_style'] ) {
							$social_links_classes[] = $params['social_links_icon_style'];
						}
						if( $params['social_links_icon_size'] ) {
							$social_links_classes[] = $params['social_links_icon_size'];
						}
						if( $params['social_links_icon_border_style'] ) {
							$social_links_classes[] = 'icon-bordered';
						}
						if( $params['social_links_icon_theme_colored'] ) {
							$social_links_classes[] = 'icon-theme-colored' . $params['social_links_icon_theme_colored'];
						}
						$params['social_links_classes'] = $social_links_classes;
						break;

					case 'search-box':
						# code...
						break;

					case 'header-top-side-push-panel':
						# code...
						break;

					case 'login-register':
						# code...
						break;

					case 'wpml-languages':
						# code...
						break;

					case 'checkout-button':
						# code...
						break;
					
					default:
						# code...
						break;
				}

				//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
				$html .= charitab_mascot_get_blocks_template_part( $each_content_type, null, 'header/tpl/content', $params );

			}//end foreach content type
		}
		
		return $html;
	}
}




if(!function_exists('charitab_mascot_get_header_mid')) {
	/**
	 * Function that Renders Header Mid HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_mid() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		
		//Header Container
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'header_container', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_layout_container_class'] = $temp_meta_value;
		} else {
			$params['header_layout_container_class'] = charitab_mascot_get_redux_option( 'header-settings-header-layout-type-container', 'container' );
		}
		
		//if Use Theme Color in Background enabled
		$params['header_mid_bg_theme_colored'] = '';
		if( !_empty( charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-bgcolor-use-themecolor' )) ) {
			$params['header_mid_bg_theme_colored'] = 'bg-theme-colored' . charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-bgcolor-use-themecolor' );
		}
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'header-mid', null, 'header/tpl/parts', $params );
		
		return $html;
	}
	add_action( 'charitab_mascot_header_mid_area', 'charitab_mascot_get_header_mid' );
}


if (!function_exists('charitab_mascot_get_header_middle_column3_content')) {
	/**
	 * Return Header Middle column3 Content HTML
	 */
	function charitab_mascot_get_header_middle_column3_content() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();
		$html = '';

		//Header Top Column 2 (Right Widget) - Content Types
		//check if meta value is provided for this page or then get it from theme options
		$params['header_mid_column3_content_type'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-content' );

		if( empty( $params['header_mid_column3_content_type'] ) ) {
			return;
		}

		//foreach content type
		if (is_array($params['header_mid_column3_content_type']) || is_object($params['header_mid_column3_content_type'])) {
			foreach ( $params['header_mid_column3_content_type'] as $each_content_type ) {
				switch ( $each_content_type ) {
					case 'column3-contact-info':
						# code...
						//Contact Info
						$params['contact_info_checkbox'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-contact-info-checkbox' );

						//Icon Box Style
						$params['iconbox_style'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-contact-info-iconbox-style' );

						//if Use Icon Theme Color
						$params['contact_info_icon_theme_colored'] = '';
						if( !_empty( charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-contact-info-icon-use-themecolor' )) ) {
							$params['contact_info_icon_theme_colored'] = 'text-theme-colored' . charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-contact-info-icon-use-themecolor' );
						}

						break;

					case 'column3-custom-text':
						# code...
						//Custom Text
						$params['custom_text'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-custom-text' );
						break;

					case 'column3-custom-button':
						# code...
						//Custom Text
						$params['custom_button'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-custom-button' );
						$params['custom_button_design_style'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-custom-button-design-style' );
						$params['custom_button_size'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-custom-button-size' );
						$params['custom_button_flat'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-custom-button-flat' );
						$params['custom_button_outlined'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-custom-button-outlined' );
						$params['custom_button_round'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-custom-button-round' );
						$params['custom_button_link_open_in'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-custom-button-link-open-in-window' );
						//button classes
						$params['btn_classes'] = charitab_mascot_prepare_header_button_classes_from_params( $params );
						break;

					case 'column3-social-links':
						# code...
						//Enabled social links
						$params['social_links'] = charitab_mascot_get_redux_option( 'social-links-ordering', false, 'Enabled' );
						$params['social_links_label'] = charitab_mascot_get_redux_option( 'header-settings-header-top-column3-social-links-label' );
						$params['social_links_icon_color'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-social-links-color' );
						$params['social_links_icon_style'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-social-links-icon-style' );
						$params['social_links_icon_size'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-social-links-icon-size' );
						$params['social_links_icon_border_style'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-social-links-icon-border-style' );
						$params['social_links_icon_theme_colored'] = charitab_mascot_get_redux_option( 'header-settings-header-mid-column3-social-links-theme-colored' );

						//social links classes
						$social_links_classes = array();
						if( $params['social_links_icon_color'] ) {
							$social_links_classes[] = $params['social_links_icon_color'];
						}
						if( $params['social_links_icon_style'] ) {
							$social_links_classes[] = $params['social_links_icon_style'];
						}
						if( $params['social_links_icon_size'] ) {
							$social_links_classes[] = $params['social_links_icon_size'];
						}
						if( $params['social_links_icon_border_style'] ) {
							$social_links_classes[] = 'icon-bordered';
						}
						if( $params['social_links_icon_theme_colored'] ) {
							$social_links_classes[] = 'icon-theme-colored' . $params['social_links_icon_theme_colored'];
						}
						$params['social_links_classes'] = $social_links_classes;
						break;

					case 'column3-search-box':
						# code...
						break;
					
					default:
						# code...
						break;
				}

				//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
				$html .= charitab_mascot_get_blocks_template_part( $each_content_type, null, 'header/tpl/content', $params );

			}//end foreach content type
		}
		
		return $html;
	}
}


if (!function_exists('charitab_mascot_get_top_main_slider')) {
	/**
	 * Return Top Main Slider do_shortcode
	 */
	function charitab_mascot_get_top_main_slider() {
		$current_page_id = charitab_mascot_get_page_id();
		$html = '';

		$slider_type = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_slider_settings", 'slider_type', $current_page_id );

		switch ( $slider_type ) {
			case 'rev-slider':
				# code...
				if ( class_exists( 'RevSlider' ) ) {
					$rev_slider_alias = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_slider_settings", 'select_rev_slider', $current_page_id );
					if( ! charitab_mascot_metabox_opt_val_is_empty( $rev_slider_alias ) && $rev_slider_alias != '0' ) {
						$html = do_shortcode( '[rev_slider alias="'.$rev_slider_alias.'"]' );
					}
					break;
				}
			
			case 'layer-slider':
				# code...
				if ( class_exists( 'LS_Sliders' ) ) {
					$layer_slider_alias = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_slider_settings", 'select_layer_slider', $current_page_id );
					if( ! charitab_mascot_metabox_opt_val_is_empty( $layer_slider_alias ) && $layer_slider_alias != '0' ) {
						$html = do_shortcode( '[layerslider id="'.$layer_slider_alias.'"]' );
					}
					break;
				}
			
			default:
				# code...
				break;
		}

		return $html;
	}
}









if (!function_exists('charitab_mascot_register_header_navigation_side_push_panel_sidebar')) {
	/**
	 * Register Side Push Panel Sidebar
	 */
	function charitab_mascot_register_header_navigation_side_push_panel_sidebar() {
		/*$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Side Push Panel
		$params['show_side_push_panel'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-side-push-panel', false );

		if( !$params['show_side_push_panel'] ) {
			return;
		}*/



		// Side Push Panel Sidebar
		register_sidebar( array(
			'name' => esc_html__( 'Side Push Panel Sidebar', 'charitab-wp' ),
			'id' => 'header-side-push-panel-sidebar',
			'description'	=> esc_html__( 'Widgets in this area will be shown on Side Push Panel section. Drag and drop your widgets here.', 'charitab-wp' ),
			'before_widget' => '<div id="%1$s" class="widget widget-side-push-panel %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>',
		) );
	}
	add_action( 'widgets_init', 'charitab_mascot_register_header_navigation_side_push_panel_sidebar', 1000 );
}


if(!function_exists('charitab_mascot_get_header_side_push_panel_sidebar')) {
	/**
	 * Function that Renders Side Push Panel Sidebar HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_side_push_panel_sidebar() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Side Push Panel
		$params['show_side_push_panel'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-side-push-panel', false );

		if( !$params['show_side_push_panel'] ) {
			return;
		}


		//hide icon in mobile device
		$params['show_side_push_panel_icon_in_mobile_device'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-side-push-panel-in-mobile-device' );
		$params['hidden_class'] = '';
		if( !$params['show_side_push_panel_icon_in_mobile_device'] ) {
			$params['hidden_class'] = 'hidden-mobile-mode';
		}


		add_action( 'wp_footer', 'charitab_mascot_get_header_side_push_panel_sidebar_html_code' );
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'side-push-panel', null, 'header/tpl/content', $params );
		return $html;
	}
	add_action( 'charitab_mascot_header_nav_side_icons', 'charitab_mascot_get_header_side_push_panel_sidebar', 20 );
}


if(!function_exists('charitab_mascot_get_header_side_push_panel_sidebar_html_code')) {
	/**
	 * Function that Renders Side Push Panel Sidebar HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_side_push_panel_sidebar_html_code() {
		$params = array();
		$html = charitab_mascot_get_blocks_template_part( 'side-push-panel-sidebar-html-code', null, 'header/tpl/content', $params );
		return $html;
	}
}


if (!function_exists('charitab_mascot_header_side_push_panel_sidebar_add_class_to_body')) {
	/**
	 * Add classes to body for Side Push Panel Sidebar
	 */
	function charitab_mascot_header_side_push_panel_sidebar_add_class_to_body( $classes ) {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Side Push Panel
		$params['show_side_push_panel'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-side-push-panel', false );

		
		if( $params['show_side_push_panel'] ) {
			$classes[] = 'has-side-panel side-panel-right';
		}

		return $classes;
	}
	add_filter( 'body_class', 'charitab_mascot_header_side_push_panel_sidebar_add_class_to_body' );
}





if (!function_exists('charitab_mascot_register_header_navigation_vertical_nav_sidebar')) {
	/**
	 * Register Vertical Nav Sidebar
	 */
	function charitab_mascot_register_header_navigation_vertical_nav_sidebar() {
		// Side Push Panel Sidebar
		register_sidebar( array(
			'name' => esc_html__( 'Vertical Nav Sidebar', 'charitab-wp' ),
			'id' => 'header-vertical-nav-sidebar',
			'description'	=> esc_html__( 'Widgets in this area will be shown on Vertical Nav section. Drag and drop your widgets here.', 'charitab-wp' ),
			'before_widget' => '<div id="%1$s" class="widget widget-vertical-nav %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5 class="widget-title">',
			'after_title'   => '</h5>',
		) );
	}
	add_action( 'widgets_init', 'charitab_mascot_register_header_navigation_vertical_nav_sidebar', 1000 );
}



if(!function_exists('charitab_mascot_get_header_search_icon')) {
	/**
	 * Function that Renders Header Search Icon HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_search_icon() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Search Icon
		$params['show_menu_search_icon'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-menu-search-icon' );

		if( !$params['show_menu_search_icon'] ) {
			return;
		}

		//hide icon in mobile device
		$params['show_menu_search_icon_in_mobile_device'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-menu-search-icon-in-mobile-device' );
		$params['hidden_class'] = '';
		if( !$params['show_menu_search_icon_in_mobile_device'] ) {
			$params['hidden_class'] = 'hidden-mobile-mode';
		}

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'nav-search-icon', null, 'header/tpl/content', $params );
		return $html;
	}
	add_action( 'charitab_mascot_header_nav_side_icons', 'charitab_mascot_get_header_search_icon', 10 );
}

if(!function_exists('charitab_mascot_get_header_search_form')) {
	/**
	 * Function that Renders Header Search Form HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_search_form() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Search Icon
		$params['show_menu_search_icon'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-menu-search-icon' );

		if( !$params['show_menu_search_icon'] ) {
			return;
		}

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'nav-search-form', null, 'header/tpl/content', $params );
		return $html;
	}
	add_action( 'charitab_mascot_header_nav_container_end', 'charitab_mascot_get_header_search_form' );
}

if(!function_exists('charitab_mascot_get_header_nav_custom_button')) {
	/**
	 * Function that Renders Header Nav Custom Button HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_nav_custom_button() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();


		//Show Custom Button
		$params['show_custom_button'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-custom-button' );

		if( !$params['show_custom_button'] ) {
			return;
		}


		//Custom Button Info
		$params['custom_button'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-info' );
		$params['custom_button_design_style'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-design-style' );
		$params['custom_button_size'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-size' );
		$params['custom_button_flat'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-flat' );
		$params['custom_button_outlined'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-outlined' );
		$params['custom_button_round'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-round' );
		$params['custom_button_link_open_in'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-link-open-in-window' );
		$params['show_custom_button_in_mobile_device'] = charitab_mascot_get_redux_option( 'header-settings-navigation-custom-button-show-in-mobile-device' );
		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_header_button_classes_from_params( $params );
		$params['hidden_class'] = '';
		if( !$params['show_custom_button_in_mobile_device'] ) {
			$params['hidden_class'] = 'hidden-mobile-mode';
		}
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'nav-custom-button', null, 'header/tpl/content', $params );
		return $html;
	}
	add_action( 'charitab_mascot_header_nav_side_icons', 'charitab_mascot_get_header_nav_custom_button', 25 );
}








if(!function_exists('charitab_mascot_get_header_mini_cart_icon')) {
	/**
	 * Function that Renders Header Mini Cart Icon HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_header_mini_cart_icon() {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		if ( !class_exists( 'WooCommerce' ) ) {
			return;
		}
		
		//Show Cart Icon
		$params['show_menu_cart_icon'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-menu-cart-icon' );

		if( !$params['show_menu_cart_icon'] ) {
			return;
		}


		//hide icon in mobile device
		$params['show_menu_cart_icon_in_mobile_device'] = charitab_mascot_get_redux_option( 'header-settings-navigation-show-menu-cart-icon-in-mobile-device' );
		$params['hidden_class'] = '';
		if( !$params['show_menu_cart_icon_in_mobile_device'] ) {
			$params['hidden_class'] = 'hidden-mobile-mode';
		}

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'nav-mini-cart-icon', null, 'header/tpl/content', $params );
		return $html;
	}
	add_action( 'charitab_mascot_header_nav_side_icons', 'charitab_mascot_get_header_mini_cart_icon', 15 );
}


if(!function_exists('woocommerce_header_add_to_cart_fragment')) {
	/**
	 * Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
	 * @return HTML
	 */
	function woocommerce_header_add_to_cart_fragment( $fragments ) {
		ob_start();
		?>
		<div class="top-nav-mini-cart-icon-contents">
			<a class="mini-cart-icon" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_html_e( 'View your shopping cart', 'charitab-wp' ); ?>"><i class="<?php echo charitab_mascot_get_redux_option( 'header-settings-navigation-menu-cart-icon-code', 'fa fa-shopping-cart' ); ?>"></i><span class="items-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'charitab-wp' ), WC()->cart->get_cart_contents_count() ); ?></span> <span class="cart-quick-info"><?php echo sprintf (_n( '%d item', '%d items', WC()->cart->get_cart_contents_count(), 'charitab-wp' ), WC()->cart->get_cart_contents_count() ); ?> - <?php echo WC()->cart->get_cart_total(); ?></span></a>

			<div class="dropdown-content">
				<?php woocommerce_mini_cart(); ?>
			</div>
		</div>

		<?php
		$fragments['div.top-nav-mini-cart-icon-contents'] = ob_get_clean();
		return $fragments;
	}
	add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
}
