<?php


if (!function_exists('charitab_mascot_give_form_supports')){
	/*
	* Add comments support for give plugin
	*/
	function charitab_mascot_give_form_supports( $give_form_supports ){
		$give_form_supports[] = 'comments';
		return $give_form_supports;
	}
	
}



if(!function_exists('charitab_mascot_get_give_donation_form')) {
	/**
	 * Function that Renders Page HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_give_donation_form( $container_type = 'container', $page_layout = null ) {
		$params = array();
		$params['container_type'] = $container_type;

		//page layout
		$params['page_layout'] = '';
		if( isset( $page_layout ) && $page_layout != '' ) {
			$params['page_layout'] = $page_layout;
		}
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page-parts', null, 'give/tpl', $params );
		
		return $html;
	}
}


if (!function_exists('charitab_mascot_get_give_campaigns_sidebar_layout')) {
	/**
	 * Return Page Sidebar Layout HTML
	 */
	function charitab_mascot_get_give_campaigns_sidebar_layout( $page_layout = null ) {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		//Page Sidebar Layout
		//check if meta value is provided for this page or then get it from theme options
		$params['page_layout'] = charitab_mascot_get_redux_option( 'give-donation-settings-sidebar-layout', 'no-sidebar' );

		//page layout
		if( isset( $page_layout ) && $page_layout != '' ) {
			$params['page_layout'] = $page_layout;
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page', $params['page_layout'], 'give/tpl/sidebar-columns', $params );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_give_campaigns_loop' ) ) {
	/**
	 * Returns Page Loop
	 *
	 */
	function charitab_mascot_get_give_campaigns_loop() {
		$params = array();
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page-loop', null, 'give/tpl/parts', $params );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_give_each_campaign_content' ) ) {
	/**
	 * Returns Content Campaign
	 *
	 */
	function charitab_mascot_get_give_each_campaign_content() {
		$params = array();
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'content-campaign', null, 'give/tpl/parts', $params );
		
		return $html;
	}
}

