<?php

if (!function_exists('charitab_mascot_get_footer_parts_wpb_shortcodes_custom_css')) {
	/**
	 * Add VC inline css to body
	 */
	function charitab_mascot_get_footer_parts_wpb_shortcodes_custom_css() {
		$current_page_id = charitab_mascot_get_page_id();

		//Footer Widget Area
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_footer_settings", 'footer_widget_area', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['footer_widget_area'] = $temp_meta_value;
		} else {
			$params['footer_widget_area'] = charitab_mascot_get_redux_option( 'footer-settings-choose-footer-widget-area', 'default' );
		}


		//VC Custom CSS
		$shortcodes_custom_css = get_post_meta( $params['footer_widget_area'], '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $shortcodes_custom_css ) ) {
			wp_add_inline_style( 'charitab-mascot-dynamic-style', $shortcodes_custom_css );
		}


	}
	add_action( 'wp_enqueue_scripts', 'charitab_mascot_get_footer_parts_wpb_shortcodes_custom_css' );
}












if (!function_exists('charitab_mascot_footer_widget_title_line_bottom_color')) {
	/**
	 * Generate CSS codes for Footer Top Widget Title Custom Line Bottom Color
	 */
	function charitab_mascot_footer_widget_title_line_bottom_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'footer-settings-footer-widget-title-line-bottom-custom-color';
		//If Make Line Bottom Theme Colored?
		if( $charitab_mascot_redux_theme_opt['footer-settings-footer-widget-title-line-bottom-theme-colored'] != '' ) {
			return;
		}

		$declaration = array();
		$selector = array(
			'footer#footer .footer-widget-area .widget .widget-title.widget-title-line-bottom:after',
			'footer#footer.footer-inverted .footer-widget-area  .widget .widget-title.widget-title-line-bottom:after'
		);

		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_footer_widget_title_line_bottom_color');
}











if (!function_exists('charitab_mascot_footer_widget_title_typography')) {
	/**
	 * Generate CSS codes for Footer Top Widget Title Typography
	 */
	function charitab_mascot_footer_widget_title_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'footer-settings-footer-top-widget-title-typography';
		$declaration = array();
		$selector = array(
			'footer#footer .footer-widget-area .widget .widget-title',
			//'footer#footer.footer-inverted .footer-widget-area .widget .widget-title'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_footer_widget_title_typography');
}

if (!function_exists('charitab_mascot_footer_widget_text_typography')) {
	/**
	 * Generate CSS codes for Footer Top Widget Text Typography
	 */
	function charitab_mascot_footer_widget_text_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'footer-settings-footer-top-widget-text-typography';
		$declaration = array();
		$selector = array(
			'footer#footer .footer-widget-area',
			//'footer#footer.footer-inverted .footer-widget-area'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_footer_widget_text_typography');
}

if (!function_exists('charitab_mascot_footer_widget_link_typography')) {
	/**
	 * Generate CSS codes for Footer Top Widget Link Typography
	 */
	function charitab_mascot_footer_widget_link_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'footer-settings-footer-top-widget-link-typography';
		$declaration = array();
		$selector = array(
			'footer#footer .footer-widget-area a',
			//'footer#footer.footer-inverted .footer-widget-area a'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_footer_widget_link_typography');
}

if (!function_exists('charitab_mascot_footer_widget_link_hover_color')) {
	/**
	 * Generate CSS codes for Footer Top Widget Link Hover Color
	 */
	function charitab_mascot_footer_widget_link_hover_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'footer-settings-footer-top-widget-link-hover-color';
		$declaration = array();
		$selector = array(
			'footer#footer .footer-widget-area a:hover',
			//'footer#footer.footer-inverted .footer-widget-area a:hover'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_footer_widget_link_hover_color');
}