<?php


add_action( 'charitab_mascot_charitable_campaign_content_loop_footer_end', 'charitab_mascot_charitable_template_campaign_loop_more_link', 10 );
if( !function_exists('charitab_mascot_charitable_template_campaign_loop_more_link') ) {
	function charitab_mascot_charitable_template_campaign_loop_more_link( $campaign ) {
		charitable_template( 'campaign-loop/more-link.php', array( 'campaign' => $campaign ) );
	}
}

if ( ! function_exists( 'charitab_mascot_charitable_template_campaign_progress_bar' ) ) {
	/**
	 * Returns Campaign Progress Bar
	 *
	 */
	function charitab_mascot_charitable_template_campaign_progress_bar($campaign) {
	?>
		<div class="progress-item charitable-progress-bar">
			<div class="progress">
				<div class="progress-bar" data-percent="<?php echo esc_html( $campaign->get_percent_donated_raw() ) ?>">
					<span class="progress-percentage"><?php echo esc_html( round($campaign->get_percent_donated_raw(), 1) ) ?>%</span>
				</div>
			</div>
		</div>
	<?php
	}
}


if ( ! function_exists( 'charitab_mascot_charitable_template_campaign_easypiechart' ) ) {
	/**
	 * Returns Campaign easypiechart
	 *
	 */
	function charitab_mascot_charitable_template_campaign_easypiechart($campaign) {
		wp_enqueue_script( 'jquery-easypiechart' );
	?>
		<div class="campaign-easypiechart-block">
			<div class="easypiechart" data-barcolor="#f89d35" data-trackcolor="#f2f2f2" data-scalecolor="#222" data-percent="<?php echo esc_attr( $campaign->get_percent_donated_raw() ) ?>" data-linewidth="5" data-size="70">
				<span class="percent"></span>
			</div>
		</div>
	<?php
	}
}

if ( ! function_exists( 'charitab_mascot_charitable_turn_on_campaign_archives' ) ) {
	/**
	 * Turn on post type archives for the campaigns.
	 *
	 * @param   array $post_type_args
	 * @return  array
	 */
	function charitab_mascot_charitable_turn_on_campaign_archives( $post_type_args ) {
		$post_type_args['has_archive'] = true;
		return $post_type_args;
	}
	add_filter( 'charitable_campaign_post_type', 'charitab_mascot_charitable_turn_on_campaign_archives' );
}



if(!function_exists('charitab_mascot_get_charitable_campaigns')) {
	/**
	 * Function that Renders Page HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_charitable_campaigns( $container_type = 'container', $page_layout = null ) {
		$params = array();
		$params['container_type'] = $container_type;

		//page layout
		$params['page_layout'] = '';
		if( isset( $page_layout ) && $page_layout != '' ) {
			$params['page_layout'] = $page_layout;
		}
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page-parts', null, 'charitable/tpl', $params );
		
		return $html;
	}
}


if (!function_exists('charitab_mascot_get_charitable_campaigns_sidebar_layout')) {
	/**
	 * Return Page Sidebar Layout HTML
	 */
	function charitab_mascot_get_charitable_campaigns_sidebar_layout( $page_layout = null ) {
		$current_page_id = charitab_mascot_get_page_id();
		$params = array();

		//Page Sidebar Layout
		//check if meta value is provided for this page or then get it from theme options
		$params['page_layout'] = charitab_mascot_get_redux_option( 'charitable-donation-settings-sidebar-layout', 'no-sidebar' );

		//page layout
		if( isset( $page_layout ) && $page_layout != '' ) {
			$params['page_layout'] = $page_layout;
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page', $params['page_layout'], 'charitable/tpl/sidebar-columns', $params );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_charitable_campaigns_loop' ) ) {
	/**
	 * Returns Page Loop
	 *
	 */
	function charitab_mascot_get_charitable_campaigns_loop() {
		$params = array();
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'page-loop', null, 'charitable/tpl/parts', $params );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_charitable_each_campaign_content' ) ) {
	/**
	 * Returns Content Campaign
	 *
	 */
	function charitab_mascot_get_charitable_each_campaign_content() {
		$params = array();
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'content-campaign', null, 'charitable/tpl/parts', $params );
		
		return $html;
	}
}

if (!function_exists('charitab_mascot_register_charitable_page_sidebar')) {
	/**
	 * Register Charitable Page Sidebar
	 */
	function charitab_mascot_register_charitable_page_sidebar() {
		$title_line_bottom_class = '';

		if( charitab_mascot_get_redux_option( 'sidebar-settings-sidebar-title-show-line-bottom' ) ) {
			$title_line_bottom_class = 'widget-title-line-bottom';
		}
		$line_bottom_theme_colored = charitab_mascot_get_redux_option( 'sidebar-settings-sidebar-title-line-bottom-theme-colored' );
		if( $line_bottom_theme_colored != '' ) {
			$title_line_bottom_class .= ' line-bottom-theme-colored' . $line_bottom_theme_colored;
		}
		
		// Page Default Sidebar
		register_sidebar( array(
			'name'			=> esc_html__( 'Charitable Campaign Sidebar', 'charitab-wp' ),
			'id'			=> 'charitable-campaign-sidebar',
			'description'   => esc_html__( 'This is a default sidebar for Charitable Campaign Archive and Single pages. Widgets in this area will be shown on sidebar of Charitable Campaign Archive and Single pages. Drag and drop your widgets here.', 'charitab-wp' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title ' . esc_attr( $title_line_bottom_class ) . '">',
			'after_title'   => '</h4>',
		) );
	}
	add_action( 'widgets_init', 'charitab_mascot_register_charitable_page_sidebar', 1000 );
}


if (!function_exists('charitab_mascot_charitable_donation_meta_info')) {
	function charitab_mascot_charitable_donation_meta_info( $campaign ) {

		$count_campaign_donations = charitable_get_table( 'campaign_donations' )->get_donations_report( array( 'campaign_id' => $campaign->ID, 'status' => 'charitable-completed' ) );

		if( !empty($count_campaign_donations) ) {
			$count_campaign_donations = count($count_campaign_donations);
		}else{
			$count_campaign_donations = '';
		}

		if( $count_campaign_donations == '' ) {
			$count_campaign_donation_ending = esc_html__( 'No donation yet', 'charitab-wp' );
		}elseif( $count_campaign_donations == 1 ) {
			$count_campaign_donation_ending = esc_html__( ' Donation', 'charitab-wp' );
		}else{
			$count_campaign_donation_ending = esc_html__( ' Donations', 'charitab-wp' );
		}

		$campaign_location = '';

		if( function_exists( 'charitable_geolocation_template_campaign_loop_location' ) ) {
			$campaign_location = get_post_meta( $campaign->ID, '_campaign_location', true );
		}

		?>
			<ul class="campaign-entry-meta list-inline">
				<?php
					if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-creation-date', true ) ) {
				?>
				<li class="list-inline-item posted-date"><i class="fa fa-calendar-o"></i> <?php charitab_mascot_posted_on();?></li>
				<?php
					} if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-donation-count', true ) ) {
				?>

				<li class="list-inline-item campaign-donation-count"><i class="fa fa-heart-o"></i> <?php echo esc_html( $count_campaign_donations . apply_filters( 'charitus_campaign_donation_count_ending', $count_campaign_donation_ending, $count_campaign_donations ) ); ?></li>
				<?php
					} if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-categories', true ) ) {
						$campaign_category = charitab_mascot_get_custom_post_type_terms_with_link('campaign_category');
						if( !empty($campaign_category) ) {
				?>

				<li class="list-inline-item campaign-donation-categories"><i class="fa fa-folder-o"></i> <?php echo wp_kses_post( $campaign_category );?></li>
				<?php
						}
					} if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-tags', true ) ) {
						$campaign_tag = charitab_mascot_get_custom_post_type_terms_with_link('campaign_tag');
						if( !empty($campaign_tag) ) {
				?>

				<li class="list-inline-item campaign-donation-tags"><i class="fa fa-tags"></i> <?php echo wp_kses_post( $campaign_tag );?></li>
				<?php
						}
					} if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-location', true ) ) {
				?>

				<?php if( function_exists( 'charitable_geolocation_template_campaign_loop_location' ) && $campaign_location != '' ): ?>
				<li class="list-inline-item campaign-location-wrapper"><i class="fa fa-map-marker"></i> <?php esc_html( charitable_geolocation_template_campaign_loop_location( $campaign ) ); ?></li>	
				<?php endif; ?>	
				<?php
					}
				?>

			</ul>
		<?php
	}
}


if (!function_exists('charitab_mascot_charitable_campaign_progress_bar')) {
	/**
	 * Campaign progress bar
	 */
	function charitab_mascot_charitable_campaign_progress_bar( $campaign ) {
		charitable_template_campaign_progress_bar( $campaign );
	}
}

if (!function_exists('charitab_mascot_charitable_campaign_get_donation_summary')) {
	/**
	 * Campaign Donation Summery
	 */
	function charitab_mascot_charitable_campaign_get_donation_summary( $campaign ) {
		$currency_helper = charitable_get_currency_helper();
		$amount          = $campaign->get_donated_amount();
		$goal            = $campaign->get( 'goal' );
		$ret = '<div class="campaign-donation-stats">';
		if ( $goal ) {
			$ret .= sprintf( _x( '%s %s', 'amount donated of goal', 'charitab-wp' ),
				'<div class="donation-raised"><span class="progress-title">'.__( 'Raised:', 'charitab-wp').'</span> <span class="amount">' . $currency_helper->get_monetary_amount( $amount ) . '</span></div>',
				'<div class="donation-goal"><span class="progress-title">'.__( 'Goal:', 'charitab-wp').'</span> <span class="amount goal-amount">' . $currency_helper->get_monetary_amount( $goal ) . '</span></div>'
			);
		} else {
			$ret .= sprintf( _x( '%s donated', 'amount donated', 'charitab-wp' ),
				'<span class="amount">' . $currency_helper->get_monetary_amount( $amount ) . '</span>'
			);
		}
		$ret .= '</div>';
		echo wp_kses_post( $ret );
	}
}


add_action( 'after_setup_theme', 'charitab_mascot_charitable_campaign_add_donation_summary_action' );
if (!function_exists('charitab_mascot_charitable_campaign_add_donation_summary_action')) {
	/**
	 * Register Charitable Campaign Summery
	 */
	function charitab_mascot_charitable_campaign_add_donation_summary_action() {
		if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-raised-goal', true ) ) { 
			add_action( 'charitab_mascot_charitable_campaign_content_loop_content_end', 'charitable_template_campaign_loop_donation_stats', 2 );
			//add_action( 'charitab_mascot_charitable_campaign_content_loop_header_end', 'charitab_mascot_charitable_campaign_get_donation_summary', 2 );
		}
	}
}