<?php
/**
 * ThemeMascot functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 */

global $charitab_mascot_theme_info;
$charitab_mascot_theme_info = wp_get_theme();

if (!function_exists('charitab_mascot_core_plugin_installed')) {
	/**
	 * Core Plugin installed?
	 */
	function charitab_mascot_core_plugin_installed() {
		return defined( 'MASCOT_CORE_CHARITAB_VERSION' );
	}
}

/* VARIABLE DEFINITIONS
================================================== */
define( 'CHARITAB_MASCOT_AUTHOR', 'ThemeMascot' );
define( 'CHARITAB_MASCOT_FRAMEWORK_VERSION', '1.0' );
define( 'CHARITAB_MASCOT_TEMPLATE_URI', get_template_directory_uri() );
define( 'CHARITAB_MASCOT_CHILD_THEME_URI', get_stylesheet_directory_uri() );
define( 'CHARITAB_MASCOT_TEMPLATE_DIR', get_template_directory() );
define( 'CHARITAB_MASCOT_STYLESHEET_DIR', get_stylesheet_directory() );

define( 'CHARITAB_MASCOT_ASSETS_URI', CHARITAB_MASCOT_TEMPLATE_URI . '/assets' );
define( 'CHARITAB_MASCOT_ASSETS_DIR', CHARITAB_MASCOT_TEMPLATE_DIR . '/assets' );

define( 'CHARITAB_MASCOT_ADMIN_ASSETS_URI', CHARITAB_MASCOT_TEMPLATE_URI . '/admin/assets' );
define( 'CHARITAB_MASCOT_ADMIN_ASSETS_DIR', CHARITAB_MASCOT_TEMPLATE_DIR . '/admin/assets' );

define( 'CHARITAB_MASCOT_FRAMEWORK_FOLDER', 'mascot-framework' );
define( 'CHARITAB_MASCOT_FRAMEWORK_URI', CHARITAB_MASCOT_TEMPLATE_URI . '/'. CHARITAB_MASCOT_FRAMEWORK_FOLDER );
define( 'CHARITAB_MASCOT_FRAMEWORK_DIR', CHARITAB_MASCOT_TEMPLATE_DIR . '/'. CHARITAB_MASCOT_FRAMEWORK_FOLDER );

define( 'CHARITAB_MASCOT_LANG_DIR', CHARITAB_MASCOT_TEMPLATE_DIR . '/languages' );

define( 'CHARITAB_MASCOT_THEME_NAME', $charitab_mascot_theme_info->get( 'Name' ) );
define( 'CHARITAB_MASCOT_THEME_SHORT', strtolower($charitab_mascot_theme_info->get( 'Name' )) );
define( 'CHARITAB_MASCOT_THEME_VERSION', $charitab_mascot_theme_info->get( 'Version' ) );
define( 'CHARITAB_MASCOT_POST_EXCERPT_LENGTH', 25 );
define( 'CHARITAB_MASCOT_MENUZORD_MEGAMENU_BREAKPOINT_BW', '1199px' );
define( 'CHARITAB_MASCOT_MENUZORD_MEGAMENU_BREAKPOINT_FW', '1200px' );


/* Initial Actions
================================================== */
add_action( 'after_setup_theme', 		'charitab_mascot_action_after_setup_theme' );
add_action( 'wp_enqueue_scripts', 		'charitab_mascot_action_wp_enqueue_scripts' );
add_action( 'widgets_init', 			'charitab_mascot_action_widgets_init' );
add_action( 'wp_head', 					'charitab_mascot_action_wp_head',1 );
add_action( 'wp_head', 					'charitab_mascot_action_wp_head_at_the_end', 100 );

//admin actions
add_action( 'admin_enqueue_scripts',	'charitab_mascot_action_theme_admin_enqueue_scripts' );

add_action( 'wp_footer', 				'charitab_mascot_action_wp_footer' );


/* MASCOT FRAMEWORK
================================================== */
require_once( CHARITAB_MASCOT_FRAMEWORK_DIR . '/mascot-framework.php' );



if(!function_exists('charitab_mascot_action_after_setup_theme')) {
	/**
	 * After Setup Theme
	 */
	function charitab_mascot_action_after_setup_theme() {
		//Theme Support
		global $supported_post_formats;
		$supported_post_formats = array( 'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video' );
		
		//This feature enables Post Formats support for this theme
		add_theme_support( 'post-formats', $supported_post_formats );

		//This feature enables Automatic Feed Links for post and comment in the head
		add_theme_support( 'automatic-feed-links' );

		//This feature enables Post Thumbnails support for this theme
		add_theme_support( 'post-thumbnails' );

		//Woocommerce theme suport
		add_theme_support( 'woocommerce' );

		// Custom Backgrounds
		add_theme_support( 'custom-background', array(
			'default-color' => 'fff',
		) );

		//This feature enables plugins and themes to manage the document title tag. This should be used in place of wp_title() function
		add_theme_support( 'title-tag' );

		//This feature allows the use of HTML5 markup for the search forms, comment forms, comment lists, gallery, and caption
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );


		// add excerpt support for pages
		add_post_type_support( 'page', 'excerpt' );

		//Thumbnail Sizes
		set_post_thumbnail_size( 672, 448, true );
		add_image_size( 'charitab_mascot_featured_image', 1100 );

		add_image_size( 'charitab_mascot_square', 550, 550, true );
		add_image_size( 'charitab_mascot_square_150', 150, 150, true );
		add_image_size( 'charitab_mascot_square_120', 120, 120, true );
		add_image_size( 'charitab_mascot_square_64', 64, 64, true );
		add_image_size( 'charitab_mascot_widget_100', 100, 70, true );

		add_image_size( 'charitab_mascot_bootstrap_3col', 260, 173, true );
		add_image_size( 'charitab_mascot_bootstrap_4col', 360, 240, true );
		add_image_size( 'charitab_mascot_bootstrap_6col', 560, 373, true );

		add_image_size( 'charitab_mascot_wide', 900, 600, true );
		add_image_size( 'charitab_mascot_height', 600, 816, true );
		add_image_size( 'charitab_mascot_height_small', 350, 476, true );
		add_image_size( 'charitab_mascot_large_width', 1800, 600, true );
		add_image_size( 'charitab_mascot_large_height', 900, 1224, true );
		add_image_size( 'charitab_mascot_large_width_height', 1800, 1200, true );

		//Content Width
		if ( ! isset( $content_width ) ) $content_width = 1170;

		//Theme Textdomain
		load_theme_textdomain( 'charitab-wp', get_template_directory() . '/languages' );

		//Register Nav Menus
		register_nav_menus( array(
			'primary' 					=> esc_html__( 'Primary Navigation Menu', 'charitab-wp' ),
			'page-404-helpful-links' 	=> esc_html__( 'Page 404 Helpful Links', 'charitab-wp' ),
			'column1-header-top-nav' 	=> esc_html__( 'Column 1 - Header Top Navigation', 'charitab-wp' ),
			'column2-header-top-nav' 	=> esc_html__( 'Column 2 - Header Top Navigation', 'charitab-wp' ),
			'column1-footer-nav' 		=> esc_html__( 'Columns 1 - Footer Bottom Navigation', 'charitab-wp' ),
			'column2-footer-nav' 		=> esc_html__( 'Columns 2 - Footer Bottom Navigation', 'charitab-wp' ),
			'column3-footer-nav' 		=> esc_html__( 'Columns 3 - Footer Bottom Navigation', 'charitab-wp' ),
		) );

		require_once( 'gutenberg-functions.php' );
	}
}


if(!function_exists('charitab_mascot_action_wp_enqueue_scripts')) {
	/**
	 * Enqueue Script/Style
	 */
	function charitab_mascot_action_wp_enqueue_scripts() {
		wp_enqueue_script( 'jquery-ui-core');
		wp_enqueue_script( 'jquery-ui-tabs');
		wp_enqueue_script( 'jquery-ui-accordion');
		
		wp_enqueue_style( 'wp-mediaelement' );
		wp_enqueue_script( 'wp-mediaelement' );

		if( !is_admin() ){

			/**
			 * Enqueue Style
			 */

			if( is_rtl() ) {
				wp_enqueue_style( 'bootstrap-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/bootstrap-rtl.min.css' );
			} else {
				wp_enqueue_style( 'bootstrap', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/bootstrap.min.css' );
			}
			wp_enqueue_style( 'animate-css', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/animate.min.css' );

			wp_register_style( 'charitab-mascot-preloader', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/preloader.css' );

			/**
			 * Enqueue Fonts
			 */
			//font-awesome icons
			wp_deregister_style( 'font-awesome' );
			wp_enqueue_style( 'font-awesome', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome.min.css' );
			wp_enqueue_style( 'font-awesome-animation', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome-animation.min.css' );

			if( charitab_mascot_get_redux_option( 'page-settings-use-flaticon-current-theme' ) ) {
				wp_enqueue_style( 'flaticon-set-current-theme', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-set-current-theme.css' );
			}
			if( charitab_mascot_get_redux_option( 'page-settings-use-elegant-icons' ) ) {
				wp_enqueue_style( 'elegant-icons', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/elegant-icons.css' );
			}
			if( charitab_mascot_get_redux_option( 'page-settings-use-pe-icon-7-stroke' ) ) {
				wp_enqueue_style( 'pe-icon-7-stroke', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/pe-icon-7-stroke.css' );
			}
			if( charitab_mascot_get_redux_option( 'page-settings-use-icomoon' ) ) {
				wp_enqueue_style( 'icomoon', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/fonts/icomoon/icomoon.css' );
			}
			if( charitab_mascot_get_redux_option( 'page-settings-use-ion-icons' ) ) {
				wp_enqueue_style( 'ion-icons', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/ionicons.css' );
			}
			if( charitab_mascot_get_redux_option( 'page-settings-use-simple-line' ) ) {
				wp_enqueue_style( 'simple-line', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/simple-line-icons.css' );
			}


			//google fonts
			wp_enqueue_style( 'charitab-mascot-google-fonts', charitab_mascot_google_fonts_url(), null, false, 'all' );



			/**
			 * Enqueue Script
			 */
			wp_enqueue_script( 'popper', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/popper.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'bootstrap', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/bootstrap.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'charitab-mascot-menuzord-megamenu', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/menuzord/js/menuzord.js', array('jquery'), false, true );

			//external plugins single file:
			wp_enqueue_script( 'jquery-appear', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.appear.js', array('jquery'), false, true );
			wp_enqueue_script( 'isotope', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/isotope.pkgd.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'imagesloaded', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/imagesloaded.pkgd.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'scrolltofixed', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery-scrolltofixed-min.js', array('jquery'), false, true );
			wp_enqueue_script( 'easing', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.easing.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'fitvids', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.fitvids.js', array('jquery'), false, true );
			wp_enqueue_script( 'localscroll', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.localscroll.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'scrollto', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.scrollto.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'wow', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/wow.min.js', array('jquery'), false, true );

			//external plugins js & css:
			//used when needed:
			wp_register_script( 'owl-carousel', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
			wp_register_script( 'owl-filter', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/jquery.owl-filter.js', array('jquery'), false, true );
			wp_register_script( 'owl-carousel2-thumbs', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl.carousel2.thumbs.min.js', array('jquery'), false, true );
			wp_enqueue_style( 'owl-carousel', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/assets/owl.carousel.min.css' );

			
			wp_register_script( 'lightgallery', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/lightgallery/js/lightgallery-all.min.js', array('jquery'), false, true );
			wp_register_style( 'lightgallery', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/lightgallery/css/lightgallery.min.css' );
			wp_register_script( 'mousewheel', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.mousewheel.min.js', array('jquery'), false, true );
			wp_register_script( 'lightgallery-custom', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/tm-custom-lightgallery.js', array('jquery'), false, true );


			wp_register_script( 'nivo-lightbox', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/nivo-lightbox.min.js', array('jquery'), false, true );
			wp_register_style( 'nivo-lightbox', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/nivo-lightbox.min.css' );
			wp_register_style( 'nivo-lightbox-theme', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/themes/default/default.css' );

			wp_register_script( 'prettyphoto', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/prettyphoto/js/jquery.prettyphoto.js', array('jquery'), false, true );
			wp_register_style( 'prettyphoto', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/prettyphoto/css/prettyphoto.css' );
			
			wp_register_script( 'magnific-popup', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/magnific-popup/jquery.magnific-popup.min.js', array('jquery'), false, true );
			wp_register_style( 'magnific-popup', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/magnific-popup/magnific-popup.css' );
			
			wp_register_script( 'flipclock', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/flipclock/flipclock.min.js', array('jquery'), false, true );
			wp_register_style( 'flipclock', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/flipclock/flipclock.css' );
			
			wp_register_script( 'flexslider', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/flexslider/jquery.flexslider-min.js', array('jquery'), false, true );
			wp_register_style( 'flexslider', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/flexslider/flexslider.css' );
			
			wp_register_script( 'bxslider', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/bxslider/jquery.bxslider.min.js', array('jquery'), false, true );
			wp_register_style( 'bxslider', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/bxslider/jquery.bxslider.min.css' );
			
			wp_register_script( 'instafeed', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/instafeed.min.js', array('jquery'), false, true );
			wp_register_script( 'jflickrfeed', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jflickrfeed.min.js', array('jquery'), false, true );
			wp_register_script( 'animatenumbers', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.animatenumbers.min.js', array('jquery'), false, true );
			wp_register_script( 'countdown', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.countdown.min.js', array('jquery'), false, true );
			wp_register_script( 'final-countdown', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.final-countdown.min.js', array('jquery'), false, true );
			wp_register_script( 'final-countdown-kinetic', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/kinetic.js', array('jquery'), false, true );

			wp_register_script( 'event-move', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/twentytwenty/jquery.event.move.js', array('jquery'), false, true );
			wp_register_script( 'twentytwenty', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/twentytwenty/jquery.twentytwenty.js', array('jquery'), false, true );
			wp_register_style( 'twentytwenty', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/twentytwenty/twentytwenty.css' );

			//Register Google Map Scripts
			$google_maps_api_key = charitab_mascot_get_redux_option( 'theme-api-settings-gmaps-api-key' );
			if( $google_maps_api_key ) {
				wp_register_script( 'google-maps-api', 'https://maps.google.com/maps/api/js?key=' . $google_maps_api_key, array(), false, true );
			} else {
				wp_register_script( 'google-maps-api', 'https://maps.google.com/maps/api/js', array(), false, true );
			}
			wp_register_script( 'google-maps-init', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/google-map-init.js', array('jquery'), false, true );


			//CD timeline vertical
			wp_register_script( 'timeline-cd-vertical', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-vertical/js/timeline-cd-vertical.js', array('jquery'), false, true );
			wp_register_style( 'timeline-cd-vertical', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-vertical/css/timeline-cd-vertical.css' );
			wp_register_style( 'timeline-cd-vertical-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-vertical/css/timeline-cd-vertical-rtl.css' );


			//CD timeline horizontal
			wp_register_script( 'timeline-cd-horizontal', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-horizontal/js/timeline-cd-horizontal.js', array('jquery'), false, true );
			wp_register_style( 'timeline-cd-horizontal', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-horizontal/css/timeline-cd-horizontal.css' );
			wp_register_style( 'timeline-cd-horizontal-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cd-horizontal/css/timeline-cd-horizontal-rtl.css' );


			//Horizontal Vertical timeline
			wp_register_script( 'timeline-horizontal-vertical', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-horizontal-vertical/js/timeline-horizontal-vertical.min.js', array('jquery'), false, true );
			wp_register_script( 'timeline-horizontal-vertical-custom', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-horizontal-vertical/js/custom.js', array('jquery'), false, true );
			wp_register_style( 'timeline-horizontal-vertical', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-horizontal-vertical/css/timeline-horizontal-vertical.css' );
			wp_register_style( 'timeline-horizontal-vertical-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-horizontal-vertical/css/timeline-horizontal-vertical-rtl.css' );



			//responsive vertical timeline CP
			wp_register_style( 'timeline-cp-responsive-vertical', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cp-responsive-vertical/timeline-cp-responsive-vertical.css' );
			wp_register_style( 'timeline-cp-responsive-vertical-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/timeline-cp-responsive-vertical/timeline-cp-responsive-vertical-rtl.css' );


			wp_register_script( 'jquery-swiper', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/swiper-slider/js/swiper.jquery.min.js', array('jquery'), false, true );
			wp_register_style( 'jquery-swiper', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/swiper-slider/css/swiper.min.css' );

			

			wp_register_script( 'menufullpage', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/menufullpage/menufullpage.min.js', array('jquery'), false, true );



			wp_register_script( 'jquery-fullpage', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-fullpage/fullpage.min.js', array('jquery'), false, true );
			wp_register_style( 'jquery-fullpage', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-fullpage/fullpage.min.css' );
			wp_register_style( 'jquery-fullpage-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-fullpage/fullpage.min-rtl.css' );
			


			wp_register_script( 'jquery-multiscroll', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-multiscroll/jquery.multiscroll.extensions.min.js', array('jquery'), false, true );
			wp_register_script( 'jquery-multiscroll-responsive', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-multiscroll/multiscroll.responsiveexpand.min.js', array('jquery'), false, true );
			wp_register_style( 'jquery-multiscroll', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-multiscroll/jquery.multiscroll.css' );
			wp_register_style( 'jquery-multiscroll-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-multiscroll/jquery.multiscroll-rtl.css' );
			



			wp_register_script( 'jquery-pagepiling', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-pagepiling/jquery.pagepiling.min.js', array('jquery'), false, true );
			wp_register_style( 'jquery-pagepiling', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-pagepiling/jquery.pagepiling.css' );
			wp_register_style( 'jquery-pagepiling-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slider-pagepiling/jquery.pagepiling-rtl.css' );



			
			wp_register_script( 'jquery-datatables', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/datatables/js/jquery.datatables.min.js', array('jquery'), false, true );
			wp_register_style( 'jquery-datatables', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/datatables/css/jquery.datatables.min.css' );
			
			wp_register_script( 'jquery-easypiechart', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.easypiechart.min.js', array('jquery'), false, true );


			//Theme Custom JS
			wp_enqueue_script( 'charitab-mascot-custom', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/custom.js', array('jquery'), false, true );



			//Enqueue comment-reply.js 
			if ( is_singular() && comments_open() && get_option('thread_comments') ) {
				wp_enqueue_script( 'comment-reply' );
			}


			//style main for this theme
			if( is_rtl() ) {
				wp_enqueue_style( 'charitab-mascot-style-main-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/style-main-rtl.css', array(), CHARITAB_MASCOT_THEME_VERSION );
			} else {
				wp_enqueue_style( 'charitab-mascot-style-main', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/style-main.css', array(), CHARITAB_MASCOT_THEME_VERSION );
			}

			//Theme Color
			$mascot_primary_theme_color = '';
			$page_metabox_change_primary_theme_color = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_theme_color_settings", 'change_primary_theme_color', charitab_mascot_get_page_id() );

			if( $page_metabox_change_primary_theme_color ) {
				//Theme Color from page meta box
				$mascot_primary_theme_color = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_theme_color_settings", 'primary_theme_color', charitab_mascot_get_page_id() );
			
			} else if ( !_empty( charitab_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) ) ) {
				//Theme Color from Theme Options
				if( charitab_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) == 'predefined' ) {
					//Primary Theme Color
					$mascot_primary_theme_color = !_empty( charitab_mascot_get_redux_option( 'theme-color-settings-primary-theme-color' ) ) ? charitab_mascot_get_redux_option( 'theme-color-settings-primary-theme-color' ) : '';
				} else if ( charitab_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) == 'custom' ) {
					//Custom Theme Color
					$redux_css_file_name = charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color-filename' );
					if( !empty( $redux_css_file_name ) ) {
						$mascot_primary_theme_color = $redux_css_file_name . '.css';
					} else if ( !is_multisite() ) {
						if ( file_exists( CHARITAB_MASCOT_ASSETS_DIR . '/css/colors/custom-theme-color.css' ) ) {
							$mascot_primary_theme_color = 'custom-theme-color.css';
						}
					} else {
						if ( file_exists( CHARITAB_MASCOT_ASSETS_DIR . '/css/colors/custom-theme-color-msid-' . charitab_mascot_get_multisite_blog_id() . '.css' ) ) {
							$mascot_primary_theme_color = 'custom-theme-color-msid-' . charitab_mascot_get_multisite_blog_id() . '.css';
						}
					}
				}
			} else {
				$mascot_primary_theme_color = 'theme-skin-color-set1.css';
			}

			wp_enqueue_style( 'charitab-mascot-primary-theme-color', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/colors/' . $mascot_primary_theme_color );


			//Attach Premade CSS File into the header
			$mascot_premade_sitewise_css_file = charitab_mascot_get_redux_option( 'theme-color-settings-premade-sitewise-css-file' );
			if( !empty($mascot_premade_sitewise_css_file) ) {
				wp_enqueue_style( 'charitab-mascot-premade-sitewise-css-file', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/sites/' . $mascot_premade_sitewise_css_file );
			}


			if( is_rtl() ) {
				wp_enqueue_style( 'charitab-mascot-style-main-rtl-extra', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/style-main-rtl-extra.css' );
			}

			//Dynamic Style
			if ( !is_multisite() ) {
				if ( file_exists( CHARITAB_MASCOT_ASSETS_DIR . '/css/dynamic-style.css' ) ) {
					wp_enqueue_style( 'charitab-mascot-dynamic-style', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/dynamic-style.css' );
				}
			} else {
				if ( file_exists( CHARITAB_MASCOT_ASSETS_DIR . '/css/dynamic-style-msid-' . charitab_mascot_get_multisite_blog_id() . '.css' ) ) {
					wp_enqueue_style( 'charitab-mascot-dynamic-style', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/dynamic-style-msid-' . charitab_mascot_get_multisite_blog_id() . '.css' );
				}
			}

		}
	}
}



if(!function_exists('charitab_mascot_action_theme_admin_enqueue_scripts')) {
	/**
	 * Add Admin Scripts
	 */
	function charitab_mascot_action_theme_admin_enqueue_scripts() {
		wp_enqueue_style( 'font-awesome', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome.min.css' );
		wp_enqueue_style( 'pe-icon-7-stroke', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/pe-icon-7-stroke.css' );
		wp_enqueue_style( 'ion-icons', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/ionicons.css' );
		wp_enqueue_style( 'flaticon-set-charitab', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-set-charitab.css' );
			
		wp_enqueue_style( 'charitab-mascot-custom-admin', CHARITAB_MASCOT_TEMPLATE_URI . '/admin/assets/css/custom-admin.css' );

		wp_enqueue_script( 'charitab-mascot-admin-js', CHARITAB_MASCOT_TEMPLATE_URI . '/admin/assets/js/admin.js', array('jquery'), null, true );
	}
}



if(!function_exists('charitab_mascot_detect_visual_composer_and_add_class')) {
	/**
	 * Detect VC Enabled in Page Content and then add class to body
	 */
	function charitab_mascot_detect_visual_composer_and_add_class( $classes ) {
		$vc_enabled = get_post_meta( get_the_ID() , '_wpb_vc_js_status', true);
		if (  is_archive() ) {
			$classes[] = 'tm_wpb_vc_js_status_false';
		} else if ( $vc_enabled != 'false' && $vc_enabled == true ) {
			$classes[] = 'tm_wpb_vc_js_status_true';
		} else {
			$classes[] = 'tm_wpb_vc_js_status_false';
		}
		return $classes;
	}
	add_filter( 'body_class','charitab_mascot_detect_visual_composer_and_add_class' );
}



if(!function_exists('charitab_mascot_google_fonts_url')) {
	/**
	 * @return string Google fonts URL
	 */
	function charitab_mascot_google_fonts_url() {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		//fonts
		$fonts = apply_filters( 'charitab_mascot_google_web_fonts', $fonts );

		//font subsets
		$subsets = apply_filters('charitab_mascot_google_font_subset', 'latin,latin-ext');

		if ( !empty( $fonts ) ) {
			$fonts_url = add_query_arg(
				array(
					'family' => urlencode( implode( '|', $fonts ) ),
					'subset' => urlencode( $subsets ),
				),
				'https://fonts.googleapis.com/css'
			);
		}		

		return apply_filters( 'google_web_fonts_url', $fonts_url );
	}
}


if(!function_exists('charitab_mascot_primary_google_fonts')) {
	/**
	 * @return primary google fonts used in this theme
	 */
	function charitab_mascot_primary_google_fonts( $fonts ) {

		/* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Google font: on or off', 'charitab-wp' ) ) {
			$fonts[] = 'Open Sans:300,400,500,600,700,800';
			$fonts[] = 'Merriweather:300,400,700,900';
			$fonts[] = 'Playfair Display:400,400i,700,700i';
		}

		return $fonts;
	}
	add_filter( 'charitab_mascot_google_web_fonts', 'charitab_mascot_primary_google_fonts' );
}