<?php
/**
 * Displays the donate button to be displayed within campaign loops.
 *
 * Override this template by copying it to yourtheme/charitable/campaign-loop/more-link.php
 *
 * @author  Studio 164a
 * @package Charitable/Templates/Campaign
 * @since   1.2.3
 * @version 1.5.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) { exit; }

/* @var Charitable_Campaign */
$campaign = $view_args['campaign'];

if( ! $campaign->has_ended() ) :
	return;
endif;

?>
<p><a class="<?php echo esc_attr( apply_filters( 'charitab_mascot_charitable_campaign_loop_more_link_btn', 'btn btn-theme-colored1 button') ); ?>" href="<?php echo get_permalink( $campaign->ID ) ?>" aria-label="<?php echo esc_attr( sprintf( _x( 'Continue reading about %s', 'Continue reading about campaign', 'charitab-wp' ), get_the_title( $campaign->ID ) ) ) ?>">
	<?php echo esc_html( charitab_mascot_get_redux_option( 'charitable-donation-settings-donate-button-text-expired', __( 'Read More', 'charitab-wp' ) ) ) ?>
	</a>
</p>