<?php
/**
 * Displays the donate button to be displayed on campaign pages.
 *
 * Override this template by copying it to yourtheme/charitable/campaign-loop/donate-modal.php
 *
 * @author  Studio 164a
 * @since   1.2.3
 * @version 1.3.2
 */

$campaign = $view_args['campaign'];

?>
<div class="campaign-donation-btn">
	<a data-trigger-modal="charitable-donation-form-modal-loop"
		data-campaign-id="<?php echo esc_attr( $campaign->ID ) ?>"
		class="<?php echo esc_attr( apply_filters( 'charitab_mascot_charitable_campaign_loop_donate_modal_btn', 'btn btn-theme-colored1 donate-button button') ); ?>" 
		href="<?php echo esc_url( charitable_get_permalink( 'campaign_donation_page', array( 'campaign_id' => $campaign->ID ) ) ) ?>" 
		aria-label="<?php esc_attr_e( 'Make a donation', 'charitab-wp' ) ?>">
		<?php echo esc_html( charitab_mascot_get_redux_option( 'charitable-donation-settings-donate-button-text', __( 'Donate', 'charitab-wp' ) ) ) ?>
	</a>
</div>
