<?php
/**
 * The template for displaying campaign content within loops.
 *
 * Override this template by copying it to yourtheme/charitable/campaign-loop/campaign.php
 *
 * @author  Studio 164a
 * @package Charitable/Templates/Campaign
 * @since   1.0.0
 * @version 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) { exit; }

$campaign = charitable_get_current_campaign();


//custom parameters from shortcode
global $tm_query_array;

//progress bar
remove_action( 'charitable_campaign_content_loop_before_title', 'charitable_template_campaign_loop_thumbnail', 10 );
add_action( 'charitable_campaign_content_loop_before', 'charitable_template_campaign_loop_thumbnail', 9 );

remove_action( 'charitable_campaign_content_loop_after', 'charitable_template_campaign_progress_bar', 6 );
add_action( 'charitable_campaign_content_loop_after', 'charitable_template_campaign_progress_bar', 7 );

if( isset( $tm_query_array['show_featured_image'] ) && $tm_query_array['show_featured_image'] == 'false' ) :
remove_action( 'charitable_campaign_content_loop_before_title', 'charitable_template_campaign_loop_thumbnail', 10 );
endif;

if( isset( $tm_query_array['show_excerpt'] ) && $tm_query_array['show_excerpt'] == 'false' ) :
remove_action( 'charitable_campaign_content_loop_after', 'charitable_template_campaign_description', 4 );
endif;

if( isset( $tm_query_array['show_progress'] ) && $tm_query_array['show_progress'] == 'false' ) :
remove_action( 'charitable_campaign_content_loop_before_title', 'charitable_template_campaign_progress_bar', 10 );
endif;

if( isset( $tm_query_array['show_donation_stats'] ) && $tm_query_array['show_donation_stats'] == 'false' ) :
remove_action( 'charitable_campaign_content_loop_after', 'charitable_template_campaign_loop_donation_stats', 8 );
endif;

if( isset( $tm_query_array['show_donate_button'] ) && $tm_query_array['show_donate_button'] != true ) :
remove_action( 'charitable_campaign_content_loop_after', 'charitable_template_campaign_loop_donate_link', 10, 2 );
endif;

$extra_class = array();
$extra_class[] = 'charitable-campaign';

if( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'masonry' ) :
$extra_class[] = 'isotope-item';
endif;
?>
<li id="campaign-<?php echo get_the_ID() ?>" <?php post_class( $extra_class ) ?>>
<?php
	/**
	 * @hook charitable_campaign_content_loop_before
	 */
	do_action( 'charitable_campaign_content_loop_before', $campaign, $view_args );

	?>
	<div class="campaign-content">
		<?php
			/**
			 * @hook charitable_campaign_content_loop_before_title
			 */
			do_action( 'charitable_campaign_content_loop_before_title', $campaign, $view_args );
		?>
		<a class="campaign-title" href="<?php the_permalink() ?>">
			<?php if( !isset( $tm_query_array['show_title'] ) ) { ?>
			<h4 class="title"><?php the_title() ?></h4>
			<?php } else if( isset( $tm_query_array['show_title'] ) && $tm_query_array['show_title'] != 'false' ) { ?>
			<h4 class="title"><?php the_title() ?></h4>
			<?php } ?>
		</a>
		<?php
			/**
			 * @hook charitable_campaign_content_loop_after_title
			 */
			do_action( 'charitable_campaign_content_loop_after_title', $campaign, $view_args );
		?>
	<?php

	/**
	 * @hook charitable_campaign_content_loop_after
	 */
	do_action( 'charitable_campaign_content_loop_after', $campaign, $view_args );
?>
	</div>
</li>
