<?php

/**
 * Search 
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<form role="search" method="get" id="bbp-search-form" action="<?php bbp_search_url(); ?>">
	<div class="bbp-search-form-content">
		<label class="screen-reader-text d-none" for="bbp_search"><?php _e( 'Search for:', 'charitab-wp' ); ?></label>
		<input type="hidden" name="action" value="bbp-search-request" />
		<input tabindex="<?php bbp_tab_index(); ?>" type="text" placeholder="<?php esc_attr_e( 'Search the Forum...', 'charitab-wp' ); ?>" class="form-control" value="<?php echo esc_attr( bbp_get_search_terms() ); ?>" name="bbp_search" id="bbp_search" />
		<input tabindex="<?php bbp_tab_index(); ?>" class="button" type="submit" id="bbp_search_submit" value="<?php esc_attr_e( 'Search', 'charitab-wp' ); ?>" />
	</div>
</form>
