jQuery(function($){
	var $tm_loadmore = $(".tm-btn-loadmore");
	if( $tm_loadmore.length > 0 ) {
		$tm_loadmore.each(function(){
			var this_button = $(this);
			this_button.on('click', function(e) {
				e.preventDefault();
				var button = $(this),
					target_id = button.data('target'),
					target_id_hash = '#'+target_id,
					target_id_underline = '_'+target_id.replace(/-/g, "_"),
					tm_this_btn_loadmore_params = eval('tm_loadmore_params'+target_id_underline),

					data = {
						'action': 'tm_loadmore_ajax_action',
						'page' : tm_this_btn_loadmore_params.current_page,
						'class_instance': tm_this_btn_loadmore_params.class_instance,
						'params': tm_this_btn_loadmore_params.params,
					};
				button.prop('disabled', true);

				$.ajax({
					url : tm_this_btn_loadmore_params.ajaxurl, // AJAX handler
					data : data,
					type : 'POST',
					beforeSend : function ( xhr ) {
						button.text( tm_this_btn_loadmore_params.params.loadmore_button_loading_text ); // change the button text, you can also add a preloader image
					},
					success : function( data_output ) {
						if( data_output ) {
							button.text( tm_this_btn_loadmore_params.params.loadmore_view_details_button_text );
							var div = $(target_id_hash, $(data_output));
							$(target_id_hash).append(div.html());

							if ($(target_id_hash).hasClass('isotope-layout')) {
								setTimeout(function(){
									$(target_id_hash).isotope( 'reloadItems' ).isotope();
								},200);
							}

							tm_this_btn_loadmore_params.current_page++;

							button.prop('disabled', false);

							if( tm_this_btn_loadmore_params.params.wp_ajax_load_for_cpt == 'gallery' ) {
								$('.tm-loadmore-btn-trigger-lightgallery').trigger("click");
							}

							if ( tm_this_btn_loadmore_params.current_page == tm_this_btn_loadmore_params.max_page ) {
								button.remove(); // if last page, remove the button
							}
						} else {
							button.remove(); // if no data, remove the button as well
						}
					}
				});
			});
		});
	}
});