<?php

if(!function_exists('mascot_core_charitab_theme_color_list_vc')) {
	/**
	 * Theme Color list for VC
	 */
	function mascot_core_charitab_theme_color_list_vc() {
		$theme_color_list = array();
		if( function_exists('charitab_mascot_theme_color_list_vc') ) {
			$theme_color_list = charitab_mascot_theme_color_list_vc();
		}
		return $theme_color_list;
	}
}

if(!function_exists('mascot_core_charitab_theme_color_list')) {
	/**
	 * Theme Color list
	 */
	function mascot_core_charitab_theme_color_list() {
		$theme_color_list = array();
		if( function_exists('charitab_mascot_theme_color_list') ) {
			$theme_color_list = charitab_mascot_theme_color_list();
		}
		return $theme_color_list;
	}
}

if(!function_exists('mascot_core_charitab_number_of_theme_colors')) {
	/**
	 * Number of Theme Colors Used in this theme
	 */
	function mascot_core_charitab_number_of_theme_colors() {
		$number_of_theme_colors = 2;
		if( function_exists('charitab_mascot_number_of_theme_colors') ) {
			$number_of_theme_colors = charitab_mascot_number_of_theme_colors();
		}
		return $number_of_theme_colors;
	}
}

if(!function_exists('mascot_core_charitab_icon_font_packs')) {
	/**
	 * Theme Color list
	 */
	function mascot_core_charitab_icon_font_packs( $icon_type = 'font_awesome' ) {
		$icon_font_packs = array();
		if( function_exists('charitab_mascot_icon_font_packs') ) {
			$icon_font_packs = charitab_mascot_icon_font_packs()->getIconFontPackByKey($icon_type)->getFileTypeIconList();
		}
		return $icon_font_packs;
	}
}

if(!function_exists('mascot_core_charitab_animate_css_animation_list')) {
	/**
	 * animate.css animation list https://daneden.github.io/animate.css/
	 */
	function mascot_core_charitab_animate_css_animation_list() {
		$animate_css_animation_list = array(
			'' => '',
			'fadeIn' => 'fadeIn',
			'fadeInDown' => 'fadeInDown',
			'fadeInDownBig' => 'fadeInDownBig',
			'fadeInLeft' => 'fadeInLeft',
			'fadeInLeftBig' => 'fadeInLeftBig',
			'fadeInRight' => 'fadeInRight',
			'fadeInRightBig' => 'fadeInRightBig',
			'fadeInUp' => 'fadeInUp',
			'fadeInUpBig' => 'fadeInUpBig',
			'fadeOut' => 'fadeOut',
			'fadeOutDown' => 'fadeOutDown',
			'fadeOutDownBig' => 'fadeOutDownBig',
			'fadeOutLeft' => 'fadeOutLeft',
			'fadeOutLeftBig' => 'fadeOutLeftBig',
			'fadeOutRight' => 'fadeOutRight',
			'fadeOutRightBig' => 'fadeOutRightBig',
			'fadeOutUp' => 'fadeOutUp',
			'fadeOutUpBig' => 'fadeOutUpBig',
			'bounce' => 'bounce',
			'flash' => 'flash',
			'pulse' => 'pulse',
			'rubberBand' => 'rubberBand',
			'shake' => 'shake',
			'swing' => 'swing',
			'tada' => 'tada',
			'wobble' => 'wobble',
			'jello' => 'jello',
			'bounceIn' => 'bounceIn',
			'bounceInDown' => 'bounceInDown',
			'bounceInLeft' => 'bounceInLeft',
			'bounceInRight' => 'bounceInRight',
			'bounceInUp' => 'bounceInUp',
			'bounceOut' => 'bounceOut',
			'bounceOutDown' => 'bounceOutDown',
			'bounceOutLeft' => 'bounceOutLeft',
			'bounceOutRight' => 'bounceOutRight',
			'bounceOutUp' => 'bounceOutUp',
			'flip' => 'flip',
			'flipInX' => 'flipInX',
			'flipInY' => 'flipInY',
			'flipOutX' => 'flipOutX',
			'flipOutY' => 'flipOutY',
			'lightSpeedIn' => 'lightSpeedIn',
			'lightSpeedOut' => 'lightSpeedOut',
			'rotateIn' => 'rotateIn',
			'rotateInDownLeft' => 'rotateInDownLeft',
			'rotateInDownRight' => 'rotateInDownRight',
			'rotateInUpLeft' => 'rotateInUpLeft',
			'rotateInUpRight' => 'rotateInUpRight',
			'rotateOut' => 'rotateOut',
			'rotateOutDownLeft' => 'rotateOutDownLeft',
			'rotateOutDownRight' => 'rotateOutDownRight',
			'rotateOutUpLeft' => 'rotateOutUpLeft',
			'rotateOutUpRight' => 'rotateOutUpRight',
			'slideInUp' => 'slideInUp',
			'slideInDown' => 'slideInDown',
			'slideInLeft' => 'slideInLeft',
			'slideInRight' => 'slideInRight',
			'slideOutUp' => 'slideOutUp',
			'slideOutDown' => 'slideOutDown',
			'slideOutLeft' => 'slideOutLeft',
			'slideOutRight' => 'slideOutRight',
			'zoomIn' => 'zoomIn',
			'zoomInDown' => 'zoomInDown',
			'zoomInLeft' => 'zoomInLeft',
			'zoomInRight' => 'zoomInRight',
			'zoomInUp' => 'zoomInUp',
			'zoomOut' => 'zoomOut',
			'zoomOutDown' => 'zoomOutDown',
			'zoomOutLeft' => 'zoomOutLeft',
			'zoomOutRight' => 'zoomOutRight',
			'zoomOutUp' => 'zoomOutUp',
			'hinge' => 'hinge',
			'rollIn' => 'rollIn',
			'rollOut' => 'rollOut'
		);
		return $animate_css_animation_list;
	}
}

if(!function_exists('mascot_core_charitab_jquery_easings_list')) {
	/**
	 * easings list http://api.jqueryui.com/easings/
	 */
	function mascot_core_charitab_jquery_easings_list() {
		$jquery_easings_list = array(
			'linear' => 'linear',
			'swing' => 'swing',
			'_default' => '_default',
			'easeInQuad' => 'easeInQuad',
			'easeOutQuad' => 'easeOutQuad',
			'easeInOutQuad' => 'easeInOutQuad',
			'easeInCubic' => 'easeInCubic',
			'easeOutCubic' => 'easeOutCubic',
			'easeInOutCubic' => 'easeInOutCubic',
			'easeInQuart' => 'easeInQuart',
			'easeOutQuart' => 'easeOutQuart',
			'easeInOutQuart' => 'easeInOutQuart',
			'easeInQuint' => 'easeInQuint',
			'easeOutQuint' => 'easeOutQuint',
			'easeInOutQuint' => 'easeInOutQuint',
			'easeInExpo' => 'easeInExpo',
			'easeOutExpo' => 'easeOutExpo',
			'easeInOutExpo' => 'easeInOutExpo',
			'easeInSine' => 'easeInSine',
			'easeOutSine' => 'easeOutSine',
			'easeInOutSine' => 'easeInOutSine',
			'easeInCirc' => 'easeInCirc',
			'easeOutCirc' => 'easeOutCirc',
			'easeInOutCirc' => 'easeInOutCirc',
			'easeInElastic' => 'easeInElastic',
			'easeOutElastic' => 'easeOutElastic',
			'easeInOutElastic' => 'easeInOutElastic',
			'easeInBack' => 'easeInBack',
			'easeOutBack' => 'easeOutBack',
			'easeInOutBack' => 'easeInOutBack',
			'easeInBounce' => 'easeInBounce',
			'easeOutBounce' => 'easeOutBounce',
			'easeInOutBounce' => 'easeInOutBounce',
		);
		return $jquery_easings_list;
	}
}

if(!function_exists('mascot_core_charitab_orderby_parameters_list')) {
	/**
	 * Orderby Parameters list
	 */
	function mascot_core_charitab_orderby_parameters_list() {
		$orderby_parameters_list = array(
			esc_html__( 'Date', 'mascot-core' ) 				=> 'date',
			esc_html__( 'Post Name', 'mascot-core' ) 			=> 'name',
			esc_html__( 'Random Order', 'mascot-core' ) 		=> 'rand',
			esc_html__( 'Last Modified Date', 'mascot-core' ) 	=> 'modified',
			esc_html__( 'Author', 'mascot-core' ) 				=> 'author',
			esc_html__( 'Title', 'mascot-core' ) 				=> 'title',
			esc_html__( 'ID', 'mascot-core' ) 					=> 'ID',
			esc_html__( 'Post/Page Parent ID', 'mascot-core' ) 	=> 'parent',
			esc_html__( 'Number of Comments', 'mascot-core' ) 	=> 'comment_count',
			esc_html__( 'Page Order', 'mascot-core' ) 			=> 'menu_order'
		);
		return $orderby_parameters_list;
	}
}

if(!function_exists('mascot_core_charitab_category_orderby_parameters_list')) {
	/**
	 * Category Orderby Parameters list
	 */
	function mascot_core_charitab_category_orderby_parameters_list() {
		$orderby_parameters_list = array(
			esc_html__( 'name', 'mascot-core' ) 	=> 'name',
			esc_html__( 'id', 'mascot-core' ) 		=> 'id',
			esc_html__( 'count', 'mascot-core' ) 	=> 'count',
			esc_html__( 'slug', 'mascot-core' ) 	=> 'slug',
		);
		return $orderby_parameters_list;
	}
}

if(!function_exists('mascot_core_charitab_list_hover_effects')) {
	/**
	 * Hover Effect list
	 */
	function mascot_core_charitab_list_hover_effects() {
		$hover_effects_list = array(
			esc_html__( 'Default', 'mascot-core' )   		=> '',
			esc_html__( 'Effect London', 'mascot-core' )	=> 'effect-london',
			esc_html__( 'Effect Rome', 'mascot-core' )	  => 'effect-rome',
			esc_html__( 'Effect Paris', 'mascot-core' )	 => 'effect-paris',
			esc_html__( 'Effect Barlin', 'mascot-core' )	=> 'effect-barlin'
		);
		return $hover_effects_list;
	}
}

if(!function_exists('mascot_core_charitab_portfolio_gutter_list')) {
	/**
	 * Portfolio Gutter list
	 */
	function mascot_core_charitab_portfolio_gutter_list() {
		$gutter_list = array(
			esc_html__( 'Default', 'mascot-core' )  	=>  'gutter',
			'0px'			=>  'gutter-0',
			'2px'  		=>  'gutter-2',
			'5px'  		=>  'gutter-5',
			'10px'  	=>  'gutter-10',
			'15px'  	=>  'gutter-15',
			'20px'  	=>  'gutter-20',
			'30px'  	=>  'gutter-30',
			'40px'  	=>  'gutter-40',
			'50px'  	=>  'gutter-50',
			'60px'  	=>  'gutter-60',
		);
		return $gutter_list;
	}
}

if(!function_exists('mascot_core_charitab_different_size_list')) {
	/**
	 * Size list
	 */
	function mascot_core_charitab_different_size_list() {
		$size_list = array(
			''  	=>  '',
			'xl'  	=>  'xl',
			'lg'  	=>  'lg',
			'md'  	=>  'md',
			'sm'  	=>  'sm',
			'xs'  	=>  'xs',
		);
		return $size_list;
	}
}

if(!function_exists('mascot_core_charitab_text_alignment_list')) {
	/**
	 * Text Alignment List
	 */
	function mascot_core_charitab_text_alignment_list() {
		$alignment_list = array(
			''	=> '',
			esc_html__( 'Left', 'mascot-core' )		=> 'text-left',
			esc_html__( 'Center', 'mascot-core' )	=> 'text-center',
			esc_html__( 'Right', 'mascot-core' )	=> 'text-right'
		);
		return $alignment_list;
	}
}

if(!function_exists('mascot_core_charitab_heading_tag_list')) {
	/**
	 * Heading Tag List
	 */
	function mascot_core_charitab_heading_tag_list() {
		$heading_tag_list = array(
			''  	=>  '',
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
		);
		return $heading_tag_list;
	}
}

if(!function_exists('mascot_core_charitab_heading_tag_list_all')) {
	/**
	 * Heading Tag List
	 */
	function mascot_core_charitab_heading_tag_list_all() {
		$heading_tag_list_all = array(
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
		);
		return $heading_tag_list_all;
	}
}

if(!function_exists('mascot_core_charitab_open_link_in')) {
	/**
	 * Open Link In
	 */
	function mascot_core_charitab_open_link_in() {
		$open_link_in = array(
			esc_html__( 'New Window', 'mascot-core' )   => '_blank',
			esc_html__( 'Same Window', 'mascot-core' )  => '_self'
		);
		return $open_link_in;
	}
}

if(!function_exists('mascot_core_charitab_vc_font_style_list')) {
	/**
	 * Font Style List
	 */
	function mascot_core_charitab_vc_font_style_list() {
		$font_style_list = array(
			esc_html__( 'Normal', 'mascot-core' )   => '',
			esc_html__( 'Italic', 'mascot-core' )  	=> 'italic'
		);
		return $font_style_list;
	}
}

if(!function_exists('mascot_core_charitab_vc_font_weight_list')) {
	/**
	 * Font weight List
	 */
	function mascot_core_charitab_vc_font_weight_list() {
		$font_weight_list = array(
			esc_html__( 'Default', 'mascot-core' )   => '',
			'100'   => '100',
			'200'   => '200',
			'300'   => '300',
			'400'   => '400',
			'500'   => '500',
			'600'   => '600',
			'700'   => '700',
			'800'   => '800',
		);
		return $font_weight_list;
	}
}

if(!function_exists('mascot_core_charitab_vc_text_transform_list')) {
	/**
	 * Text Transform List
	 */
	function mascot_core_charitab_vc_text_transform_list() {
		$text_transform_list = array(
			esc_html__( 'Default', 'mascot-core' )   	=> '',
			esc_html__( 'None', 'mascot-core' )  		=> 'none',
			esc_html__( 'Capitalize', 'mascot-core' )  	=> 'capitalize',
			esc_html__( 'Uppercase', 'mascot-core' )  	=> 'uppercase',
			esc_html__( 'Lowercase', 'mascot-core' )  	=> 'lowercase',
			esc_html__( 'Initial', 'mascot-core' )  	=> 'initial',
			esc_html__( 'Inherit', 'mascot-core' )  	=> 'inherit'
		);
		return $text_transform_list;
	}
}

if(!function_exists('mascot_core_charitab_get_post_all_categories_array')) {
	/**
	 * Category List of Blog Posts as an Array
	 */
	function mascot_core_charitab_get_post_all_categories_array() {
		$categories = get_categories( array(
			'orderby' => 'name',
			'order'   => 'ASC'
		) );
		$cats = array();
		$cats[''] = 'All';
		foreach($categories as $cat){
			$cats[$cat->term_id] = $cat->name;
		}
		return $cats;
	}
}

if(!function_exists('mascot_core_charitab_get_page_list_array')) {
	/**
	 * Category List of Pages as an Array
	 */
	function mascot_core_charitab_get_page_list_array() {
		$all_pages = get_pages();
		$pages = array();
		foreach($all_pages as $each_page){
			$pages[$each_page->ID] = $each_page->post_title;
		}
		return $pages;
	}
}

if ( ! function_exists( 'mascot_core_charitab_metabox_get_list_of_predefined_theme_color_css_files' ) ) {
	/**
	 * Get list of Predefined Theme Color css files
	 */
	function mascot_core_charitab_metabox_get_list_of_predefined_theme_color_css_files() {
		$predefined_theme_colors = array();

		if( $handle = opendir( MASCOT_TEMPLATE_DIR . '/assets/css/colors/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".." ) {
					$predefined_theme_colors[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $predefined_theme_colors;
	}
}

if ( ! function_exists( 'mascot_core_charitab_category_list_array' ) ) {
	/**
	 * Return category list array
	 */
	function mascot_core_charitab_category_list_array( $taxonomy ) {
		$list_categories = array(
			'' => esc_html__( 'All', 'mascot-core' )
		);
		$terms = get_terms( $taxonomy );

		if ( $terms && !is_wp_error( $terms ) ) :
			foreach ( $terms as $term ) {
				$list_categories[ $term->slug ] = $term->name;
			}
		endif;

		return $list_categories;
	}
}


if ( ! function_exists( 'mascot_core_charitab_get_available_image_sizes_for_vc' ) ) {
	/**
	 * Get information about available image sizes for VC
	 */
	function mascot_core_charitab_get_available_image_sizes_for_vc() {
		if( mascot_core_charitab_theme_installed() ) {
			return charitab_mascot_get_available_image_sizes_for_vc();
		} else {
			return array();
		}
	}
}

if ( ! function_exists( 'mascot_core_charitab_load_styles' ) ) {
	/**
	 * Get style array
	 */
	function mascot_core_charitab_load_styles( $qty = 1, $param_name = 'design_style', $admin_label = false ) {
		$options = array();
		for ($i = 1; $i <= $qty; $i++) {
			$options[sprintf(esc_html__("Style %s", 'mascot-core'), $i)] = "style{$i}";
		}

		$array = array(
			'type'       => 'dropdown',
			'heading'    => esc_html__('Design Style', 'mascot-core'),
			'param_name' => $param_name,
			'value'      => $options,
			'std'        => 'style1'
		);

		if ($admin_label) $array['admin_label'] = true;

		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_btn_design_style')) {
	/**
	 * Return Design Style
	 */
	function mascot_core_charitab_get_btn_design_style() {
		$array = array(
			esc_html__( 'Button Primary', 'mascot-core' )				=> 'btn-primary',
			esc_html__( 'Button Secondary', 'mascot-core' )				=> 'btn-secondary',
			esc_html__( 'Button Success', 'mascot-core' )				=> 'btn-success',
			esc_html__( 'Button Danger', 'mascot-core' )				=> 'btn-danger',
			esc_html__( 'Button Warning', 'mascot-core' )				=> 'btn-warning',
			esc_html__( 'Button Info', 'mascot-core' )					=> 'btn-info',
			esc_html__( 'Button Light', 'mascot-core' )					=> 'btn-light',
			esc_html__( 'Button Dark', 'mascot-core' )					=> 'btn-dark',
			esc_html__( 'Button Gray', 'mascot-core' )					=> 'btn-gray',
			esc_html__( 'Plain Text', 'mascot-core' )					=> 'btn-plain-text',
			esc_html__( 'Plain Text + Arrow', 'mascot-core' )			=> 'btn-plain-text-with-arrow'
		);

		$array_theme_color = array();
		for ($i=1; $i <= mascot_core_charitab_number_of_theme_colors(); $i++) { 
			$array_theme_color[ esc_html__( 'Button Theme Colored ' . $i, 'mascot-core' ) ] = 'btn-theme-colored' . $i;
		}

		$array = array_merge($array, $array_theme_color);
		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_button_size')) {
	/**
	 * Return Button Size
	 */
	function mascot_core_charitab_get_button_size() {
		$array = array(
			esc_html__( 'Default', 'mascot-core' )		=> '',
			esc_html__( 'Large', 'mascot-core' )		=> 'btn-lg',
			esc_html__( 'Small', 'mascot-core' )		=> 'btn-sm',
			esc_html__( 'Extra Small', 'mascot-core' )	=> 'btn-xs',
		);
		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_button_arraylist')) {
	/**
	 * Return Button Array List
	 */
	function mascot_core_charitab_get_button_arraylist( $serial, $group = 'Button Options', $prefix = '' ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Design Style", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_design_style",
					"description"	=> "",
					'value'			=> mascot_core_charitab_get_btn_design_style(),
					'std'   		=> 'btn-success',
					'save_always'   => true,
					'admin_label'   => true,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Size", 'mascot-core' ),
					"param_name"	=> $prefix . "button_size",
					"description"	=> "",
					'value'			=> mascot_core_charitab_get_button_size(),
					'std'   		=> 'btn-sm',
					'save_always'   => true,
					'admin_label'   => true,
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Outlined", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_outlined",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '4':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Round", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_round",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '5':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Flat", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_flat",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '6':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Button Fullwidth (Block Level Button)", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_block",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '7':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "3D Effect", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_threed_effect",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '8':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Alignment", 'mascot-core' ),
					"param_name"	=> $prefix . "button_alignment",
					"description"	=> "",
					'value'			=> mascot_core_charitab_text_alignment_list(),
					'group'			=> $group
				);
				break;

			case '9':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Hover Animation Effect", 'mascot-core' ),
					"param_name"	=> $prefix . "button_hover_animation_effect",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'None', 'mascot-core' )	=> '',
						esc_html__( 'Sweep To Right', 'mascot-core' )	=> 'hvr-sweep-to-right',
						esc_html__( 'Bounce To Right', 'mascot-core' )	=> 'hvr-bounce-to-right',
						esc_html__( 'Shutter Out Horizontal', 'mascot-core' )	=> 'hvr-shutter-out-horizontal'
					),
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_viewdetails_button_arraylist')) {
	/**
	 * Return Button Show Array List
	 */
	function mascot_core_charitab_get_viewdetails_button_arraylist( $serial, $group = 'Button Options', $btn_text = '', $prefix = '', $std = 'true' ) {
		$array = array();
		if( $btn_text == '' ) $btn_text = esc_html__( 'View Details', 'mascot-core' );

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> sprintf( __( "Show %s Button", 'mascot-core' ), $btn_text ),
					"param_name"	=> $prefix . "show_view_details_button",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'std'			=> $std,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> sprintf( __( "%s Button Text", 'mascot-core' ), $btn_text ),
					"param_name"	=> $prefix . "view_details_button_text",
					'std'			=> $btn_text,
					'save_always'   => true,
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_owl_carousel_arraylist')) {
	/**
	 * Return Owl Carousel Array List
	 */
	function mascot_core_charitab_get_owl_carousel_arraylist( $serial, $group = 'Carousel Options', $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Arrow Navigation", 'mascot-core' ),
					"param_name"	=> $prefix . "show_navigation",
					"description"	=> esc_html__( 'Show Left Right Navigation Arrow for Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'admin_label'   => true,
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Bullets/Dots Navigation", 'mascot-core' ),
					"param_name"	=> $prefix . "show_bullets",
					"description"	=> esc_html__( 'Show Bottom Bullets for Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'admin_label'   => true,
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Bullets/Dots Skin", 'mascot-core' ),
					"param_name"	=> $prefix . "bullets_skin",
					"description"	=> esc_html__( 'Bottom Bullets Skin', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Light Bullets', 'mascot-core' )	=> 'owl-dots-light-skin',
						esc_html__( 'Dark Bullets', 'mascot-core' )		=> 'owl-dots-dark-skin',
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '4':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Bullets/Dots Alignment", 'mascot-core' ),
					"param_name"	=> $prefix . "bullets_alignment",
					"description"	=> esc_html__( 'Bottom Bullets Alignment', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Center', 'mascot-core' )	=> 'owl-dots-center',
						esc_html__( 'Left', 'mascot-core' )		=> 'owl-dots-left',
						esc_html__( 'Right', 'mascot-core' )	=> 'owl-dots-right'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '5':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Autoplay", 'mascot-core' ),
					"param_name"	=> $prefix . "carousel_autoplay",
					"description"	=> esc_html__( 'Autoplay Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '6':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Loop", 'mascot-core' ),
					"param_name"	=> $prefix . "carousel_loop",
					"description"	=> esc_html__( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '7':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Animation Speed", 'mascot-core' ),
					"param_name"	=> $prefix . "animation_speed",
					"description"	=> esc_html__( 'Speed of slide animation in milliseconds. Default value is 6000', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '8':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Margin", 'mascot-core' ),
					"param_name"	=> $prefix . "margin",
					"description"	=> esc_html__( 'Margin between two slides. Default 30px', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '9':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Responsive Slider Columns in Laptop / Small Desktop", 'mascot-core' ),
					"param_name"	=> $prefix . "laptop",
					"description"	=> esc_html__( 'Number of Visible Sliding Items in Laptop or Small Desktop', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '10':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Responsive Slider Columns in Tablet", 'mascot-core' ),
					"param_name"	=> $prefix . "tablet",
					"description"	=> esc_html__( 'Number of Visible Sliding Items in Tablet', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_cat_filter_arraylist')) {
	/**
	 * Return Category Filter Array List
	 */
	function mascot_core_charitab_get_cat_filter_arraylist( $serial, $group = 'Content Options', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Category Filter?", 'mascot-core' ),
					"param_name"	=> "show_cat_filter",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'No', 'mascot-core' )	=> 'false',
						esc_html__( 'Yes', 'mascot-core' )	=> 'true'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Filter Style", 'mascot-core' ),
					"param_name"	=> "cat_filter_style",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Style 1', 'mascot-core' )	=> 'filter-style-1',
						esc_html__( 'Style 2', 'mascot-core' )	=> 'filter-style-2',
						esc_html__( 'Style 3', 'mascot-core' )	=> 'filter-style-3',
						esc_html__( 'Style 4', 'mascot-core' )	=> 'filter-style-4',
						esc_html__( 'Style 5', 'mascot-core' )	=> 'filter-style-5',
						esc_html__( 'Style 6', 'mascot-core' )	=> 'filter-style-6',
						esc_html__( 'Style 7', 'mascot-core' )	=> 'filter-style-7',
						esc_html__( 'Style 8', 'mascot-core' )	=> 'filter-style-8',
						esc_html__( 'Style 9', 'mascot-core' )	=> 'filter-style-9',
						esc_html__( 'Style 10', 'mascot-core' )	=> 'filter-style-10',
						esc_html__( 'Style 11', 'mascot-core' )	=> 'filter-style-11',
						esc_html__( 'Style 12', 'mascot-core' )	=> 'filter-style-12',
						esc_html__( 'Style 13', 'mascot-core' )	=> 'filter-style-13',
						esc_html__( 'Style 14', 'mascot-core' )	=> 'filter-style-14',
						esc_html__( 'Style 15', 'mascot-core' )	=> 'filter-style-15',
						esc_html__( 'Style 16', 'mascot-core' )	=> 'filter-style-16',
						esc_html__( 'Style flat', 'mascot-core' )	=> 'filter-style-flat',
					),
					'save_always'   => true,
					'dependency'	=> array('element' => 'show_cat_filter', 'value' => 'true'),
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Filter Alignment", 'mascot-core' ),
					"param_name"	=> "cat_filter_alignment",
					"description"	=> "",
					'value'			=> mascot_core_charitab_text_alignment_list(),
					'save_always'   => true,
					'dependency'	=> array('element' => 'show_cat_filter', 'value' => 'true'),
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_charitab_get_post_list_array_by_post_type')) {
	/**
	 * Return Post List Array By Post Type
	 */
	function mascot_core_charitab_get_post_list_array_by_post_type( $cpt = '', $for_vc = false ) {
		$post_list = array();
		$args = array(
			'post_type'			=> $cpt,
			'posts_per_page'	=> -1,
			'orderby'			=> 'title',
			'order'				=> 'ASC'
		);

		$the_query = new WP_Query( $args );

		// The Loop
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				if( $for_vc ) {
					$post_list[ get_the_title() ] = get_the_ID();
				} else {
					$post_list[ get_the_ID() ] = get_the_title();
				}
			}
			wp_reset_postdata();
		}

		return $post_list;
	}
}

if(!function_exists('mascot_core_charitab_set_admin_ajax_url')){
	/**
	 * Set admin ajax url via javascript
	 * 
	 */
	function mascot_core_charitab_set_admin_ajax_url() {
		echo '<script type="application/javascript">var MascotCoreAjaxUrl = "'.admin_url('admin-ajax.php').'"</script>';
	}
	add_action('wp_enqueue_scripts', 'mascot_core_charitab_set_admin_ajax_url');
}

if(!function_exists('mascot_core_charitab_row_typography')){
	/**
	 * Return Row Typography Array
	 * 
	 */
	function mascot_core_charitab_row_typography() {
		$array = array();
					
		$array = array(
			"type"			=> 'dropdown',
			"heading"		=> esc_html__( "Row Typography", 'mascot-core' ) ,
			"param_name"	=> "section_typo",
			"description"	=> esc_html__( "Define the color typography of the text of this row.", 'mascot-core' ) ,
			"value" => array(
				esc_html__( 'Default', 'mascot-core' ) => '',
				esc_html__( 'Light Typography - on Dark Background', 'mascot-core' ) => 'section-typo-light',
				esc_html__( 'Dark Typography - on White Background', 'mascot-core' ) => 'section-typo-dark',
			) ,
			"weight" => "99"
		);

		return $array;
	}
}