<?php
use MASCOTCORECHARITAB\CPT\Testimonials\CPT_Testimonials;

/*
 * Adds Mascot_Core_Charitab_Widget_Testimonials widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_Testimonials' ) ) {
class Mascot_Core_Charitab_Widget_Testimonials extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-testimonials clearfix',
			'description'	=> esc_html__( 'The widget lets you easily display Testimonials as list or carousel.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_testimonials', esc_html__( '(TM) Testimonials', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$new_cpt_class = CPT_Testimonials::Instance();
		$categories_array = mascot_core_charitab_category_list_array( $new_cpt_class->ptTaxKey );
		$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Testimonials', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'testimonials_category',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Testimonials Category', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> $categories_array
			),
			array(
				'id'		=> 'order_by',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Order By:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'date'			=> esc_html__( 'Date', 'mascot-core' ),
					'title'		=> esc_html__( 'Title', 'mascot-core' ),
					'comment_count' => esc_html__( 'Number of Comments', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'order',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Order:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'DESC' => esc_html__( 'DESC', 'mascot-core' ),
					'ASC'  => esc_html__( 'ASC', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'items_count',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Number of Items to Show', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'type',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Testimonials Type:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'list'		=> esc_html__( 'List', 'mascot-core' ),
					'carousel'   => esc_html__( 'Carousel', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'show_thumb',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Thumb', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
			array(
				'id'		=> 'show_testimonial_text',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Testimonial Text', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
			array(
				'id'		=> 'show_author_name',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Author Name', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
			array(
				'id'		=> 'show_author_job_position',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Job Position', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
			array(
				'id'		=> 'show_author_company',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Company', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_widget_testimonials') ) {
			return mascot_core_charitab_widget_testimonials( $args, $instance );
		}

	}
}
}