<?php
use MASCOTCORECHARITAB\CPT\Gallery\CPT_Gallery;

/*
 * Adds Mascot_Core_Charitab_Widget_GalleryImages widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_GalleryImages' ) ) {
class Mascot_Core_Charitab_Widget_GalleryImages extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-gallery-images clearfix',
			'description'	=> esc_html__( 'The widget lets you easily add gallery images.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_gallery_images', esc_html__( '(TM) Gallery Images', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$new_cpt_class = CPT_Gallery::Instance();
		$categories_array = mascot_core_charitab_category_list_array( $new_cpt_class->ptTaxKey );
		$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Gallery Images', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'gallery_category',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Gallery Category', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> $categories_array
			),
			array(
				'id'		=> 'order_by',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Order By:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'date'			=> esc_html__( 'Date', 'mascot-core' ),
					'title'		=> esc_html__( 'Title', 'mascot-core' ),
					'comment_count' => esc_html__( 'Number of Comments', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'order',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Order:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'DESC' => esc_html__( 'DESC', 'mascot-core' ),
					'ASC'  => esc_html__( 'ASC', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'grid',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Grid:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'1'	=> esc_html__( '1', 'mascot-core' ),
					'2'	=> esc_html__( '2', 'mascot-core' ),
					'3'	=> esc_html__( '3', 'mascot-core' ),
					'4'	=> esc_html__( '4', 'mascot-core' ),
					'5'	=> esc_html__( '5', 'mascot-core' ),
					'6'	=> esc_html__( '6', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'gutter',				
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Gutter:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'5' => esc_html__( 'Gutter', 'mascot-core' ),
					'0'  => esc_html__( 'No Gutter', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'items_count',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Number of Items to Show', 'mascot-core' ),
				'desc'		=> '',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_widget_gallery') ) {
			return mascot_core_charitab_widget_gallery( $args, $instance );
		}

	}
}
}