<?php

/*
 * Adds Mascot_Core_Charitab_Widget_FlickrFeed widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_FlickrFeed' ) ) {
class Mascot_Core_Charitab_Widget_FlickrFeed extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-flickr-feed clearfix',
			'description'	=> esc_html__( 'The widget lets you easily add flickr feed.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_flickr_feed', esc_html__( '(TM) Flickr Feed', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	 => esc_html__( 'Flickr Feed', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'userid',
				'type'		=> 'text',
				'title'		=> esc_html__( 'User Id', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Example: 52617155@N08. Collect your userid from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://idgettr.com/' ) . '">', '</a>' ),
			),
			array(
				'id'		=> 'count',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Number of Images', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'size',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Image Size', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					's' => esc_html__( 'Small Square Box', 'mascot-core' ),
					't' => esc_html__( 'Thumbnail Size', 'mascot-core' ),
					'm' => esc_html__( 'Medium Size', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'orderby',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Order By', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'latest' => esc_html__( 'Latest', 'mascot-core' ),
					'random' => esc_html__( 'Random', 'mascot-core' ),
				)
			)
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		wp_enqueue_script( 'jflickrfeed' );
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'flickr-feed', null, 'flickr-feed/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}