<?php

/*
 * Adds Mascot_Core_Charitab_Widget_FeaturedPage widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_FeaturedPage' ) ) {
class Mascot_Core_Charitab_Widget_FeaturedPage extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-featured-page clearfix',
			'description'	=> esc_html__( 'A widget that displays Featured Page.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_featured_page', esc_html__( '(TM) Featured Page', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Featured Page', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'choose_page',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Choose Page:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> mascot_core_charitab_get_page_list_array()
			),
			array(
				'id'		=> 'presentation_style',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Presentation Style:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'big-featured-img'	=> esc_html__( 'Big Featured Image', 'mascot-core' ),
					'small-featured-img'  => esc_html__( 'Small Featured Image', 'mascot-core' ),
				)
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		$the_page = get_page( $instance['choose_page'] );
		$instance['the_page'] = $the_page;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'featured-page-' . $instance['presentation_style'], null, 'featured-page/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}