<?php
namespace MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolderItem;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Working_Steps_Holder_Item
 * @package MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolderItem;
 */
class SC_Working_Steps_Holder_Item implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_working_steps_holder_item';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Working Steps Holder Item', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-working-steps-item',
				'as_child' => array('only' => 'tm_working_steps_holder'),
				'as_parent' => array('except' => 'vc_accordion'),
				'show_settings_on_create' => true,
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'        => 'attach_image',
						'heading'     => esc_html__('Featured Image','mascot-core'),
						'param_name'  => 'image'
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__('Title','mascot-core'),
						'param_name'  => 'title',
						'admin_label' => true
					),
					array(
						'type'        => 'textarea',
						'heading'     => esc_html__('Paragraph','mascot-core'),
						'param_name'  => 'text'
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__('Highlight Item?','mascot-core'),
						'param_name'  => 'highlighted',
						'value'       => array(
							esc_html__('No','mascot-core')  => 'no',
							esc_html__('Yes','mascot-core') => 'yes'
						),
						'admin_label' => true
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__('Push Left?','mascot-core'),
						'param_name'  => 'push_left',
						'value'       => array(
							esc_html__('No','mascot-core')  => 'no',
							esc_html__('Yes','mascot-core') => 'yes'
						),
						'admin_label' => true
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__('Push Right?','mascot-core'),
						'param_name'  => 'push_right',
						'value'       => array(
							esc_html__('No','mascot-core')  => 'no',
							esc_html__('Yes','mascot-core') => 'yes'
						),
						'admin_label' => true
					),
					
					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_working_steps_holder_item_vc_map_modifier') ) {
				mascot_core_charitab_sc_working_steps_holder_item_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_working_steps_holder_item_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_working_steps_holder_item_render( $attr, $content );
		}
		
	}
}