<?php
namespace MASCOTCORECHARITAB\Shortcodes\WCProducts;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_WC_Products
 * @package MASCOTCORECHARITAB\Shortcodes\WCProducts;
 */
class SC_WC_Products implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_wc_products';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
		$group_carousel_options = esc_html__( 'Carousel Options', 'mascot-core' );
		$group_query_options = esc_html__( 'Query Options', 'mascot-core' );

		$categories_array = mascot_core_charitab_category_list_array_for_vc( 'product_cat' );
		$orderby_parameters_list1 = mascot_core_charitab_orderby_parameters_list();
		$orderby_parameters_list2 = array(
		);
		$orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );


		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Woocommerce Products', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'WC Products Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-wcproduct',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )	=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
						'save_always'   => true,
						'admin_label'   => true,
					),











					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "category",
						"description"	=> esc_html__( 'Choose a category to pull from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Date', 'mascot-core' )		=> 'date',
							esc_html__( 'Title', 'mascot-core' )		=> 'title',
							esc_html__( 'Popular', 'mascot-core' )	=> 'popular',
							esc_html__( 'Ending', 'mascot-core' )		=> 'ending',
						),
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),

					





				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_wc_products_vc_map_modifier') ) {
				mascot_core_charitab_sc_wc_products_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_wc_products_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_wc_products_render( $attr, $content );
		}
		
	}
}