<?php
namespace MASCOTCORECHARITAB\Shortcodes\VideoPopup;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Video_Popup
 * @package MASCOTCORECHARITAB\Shortcodes\VideoPopup;
 */
class SC_Video_Popup implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_video_popup';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Video Popup', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-video-play',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Play Button over Featured Image', 'mascot-core' )	=> 'style1-button-over-image',
							esc_html__( 'Play Button with Text on Right', 'mascot-core' )	=> 'style2-button-with-text-right',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),

					array(
						'type'			=> 'attach_image',
						"heading"		=> esc_html__( "Choose Featured Image", 'mascot-core' ),
						"param_name"	=> "style1_featured_image",
						"description"	=> esc_html__( 'You can upload & select background featured image.', 'mascot-core' ),
						'save_always'   => true,
						'dependency'	=> array('element' => 'design_style', 'value' => 'style1-button-over-image'),
						'admin_label'   => true,
					),

					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Featured Image Size", 'mascot-core' ),
						"param_name"	=> "style1_featured_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'large',
						'dependency'	=> array('element' => 'design_style', 'value' => 'style1-button-over-image'),
						'save_always'   => true,
					),

					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Play Button on Image", 'mascot-core' ),
						"param_name"	=> "style1_featured_play_btn",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Default', 'mascot-core' )		=> '',
							esc_html__( 'Play Button 1', 'mascot-core' )	=> 's1.png',
							esc_html__( 'Play Button 1', 'mascot-core' )	=> 's1.png',
							esc_html__( 'Play Button 2', 'mascot-core' )	=> 's2.png',
							esc_html__( 'Play Button 3', 'mascot-core' )	=> 's3.png',
							esc_html__( 'Play Button 4', 'mascot-core' )	=> 's4.png',
							esc_html__( 'Play Button 5', 'mascot-core' )	=> 's5.png',
							esc_html__( 'Play Button 6', 'mascot-core' )	=> 's6.png',
							esc_html__( 'Play Button 7', 'mascot-core' )	=> 's7.png',
							esc_html__( 'Play Button 8', 'mascot-core' )	=> 's8.png',
							esc_html__( 'Play Button 9', 'mascot-core' )	=> 's9.png',
							esc_html__( 'Play Button 10', 'mascot-core' )	=> 's10.png',
							esc_html__( 'Play Button 11', 'mascot-core' )	=> 's11.png',
							esc_html__( 'Play Button 12', 'mascot-core' )	=> 's12.png',
							esc_html__( 'Play Button 13', 'mascot-core' )	=> 's13.png',
							esc_html__( 'Play Button 14', 'mascot-core' )	=> 's14.png',
							esc_html__( 'Play Button 15', 'mascot-core' )	=> 's15.png',
							esc_html__( 'Play Button 16', 'mascot-core' )	=> 's16.png',
							esc_html__( 'Play Button 17', 'mascot-core' )	=> 's17.png',
						),
						'dependency'	=> array('element' => 'design_style', 'value' => 'style1-button-over-image'),
						'save_always'   => true,
					),

					array(
						'type'			=> 'attach_image',
						"heading"		=> esc_html__( "Choose Play Button From Media", 'mascot-core' ),
						"param_name"	=> "style2_play_btn",
						"description"	=> esc_html__( 'You can upload and choose play button.', 'mascot-core' ),
						'save_always'   => true,
						'dependency'	=> array('element' => 'design_style', 'value' => 'style2-button-with-text-right'),
						'admin_label'   => true,
					),

					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Or Choose Play Button From Following Package", 'mascot-core' ),
						"param_name"	=> "style2_pre_packaged_play_btn",
						'description'   => '',
						'value'			=> array(
							esc_html__( '-- Choose Play Button --', 'mascot-core' )		=> '',
							esc_html__( 'Play Button 1', 'mascot-core' )	=> 's1.png',
							esc_html__( 'Play Button 1', 'mascot-core' )	=> 's1.png',
							esc_html__( 'Play Button 2', 'mascot-core' )	=> 's2.png',
							esc_html__( 'Play Button 3', 'mascot-core' )	=> 's3.png',
							esc_html__( 'Play Button 4', 'mascot-core' )	=> 's4.png',
							esc_html__( 'Play Button 5', 'mascot-core' )	=> 's5.png',
							esc_html__( 'Play Button 6', 'mascot-core' )	=> 's6.png',
							esc_html__( 'Play Button 7', 'mascot-core' )	=> 's7.png',
							esc_html__( 'Play Button 8', 'mascot-core' )	=> 's8.png',
							esc_html__( 'Play Button 9', 'mascot-core' )	=> 's9.png',
							esc_html__( 'Play Button 10', 'mascot-core' )	=> 's10.png',
							esc_html__( 'Play Button 11', 'mascot-core' )	=> 's11.png',
							esc_html__( 'Play Button 12', 'mascot-core' )	=> 's12.png',
							esc_html__( 'Play Button 13', 'mascot-core' )	=> 's13.png',
							esc_html__( 'Play Button 14', 'mascot-core' )	=> 's14.png',
							esc_html__( 'Play Button 15', 'mascot-core' )	=> 's15.png',
							esc_html__( 'Play Button 16', 'mascot-core' )	=> 's16.png',
							esc_html__( 'Play Button 17', 'mascot-core' )	=> 's17.png',
						),
						'dependency'	=> array('element' => 'design_style', 'value' => 'style2-button-with-text-right'),
						'save_always'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Text", 'mascot-core' ),
						"param_name"	=> "title",
						'admin_label'   => true,
					),

					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Popup Video URL", 'mascot-core' ),
						"param_name"	=> "popup_video_url",
						'admin_label'   => true,
					),

					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_video_popup_vc_map_modifier') ) {
				mascot_core_charitab_sc_video_popup_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_video_popup_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_video_popup_render( $attr, $content );
		}
		
	}
}